/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN  
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_config.c,v 1.3 2004/09/03 17:32:25 honda Exp $
 */

/*
 *  ץå¸⥸塼Nios2ѡ
 */
#include "jsp_kernel.h"
#include "check.h"
#include "task.h"
#include <nios2.h>

/*
 * ߥϥɥ/ӥåȥޥơ֥
 */
FP  int_handler_table[MAX_INT_NUM];
UW  int_bit_table[MAX_INT_NUM];

/*
 * CPU㳰ϥɥơ֥
 */
FP	exc_handler_table[MAX_EXC_NUM]; 

/*
 * ߤΥͥȲΥ
 * ͥ뵯ưϥΩȤߤʤ1ǽ
 */
UW interrupt_count = 1;

/*
 *  ץå¸ν
 */
void
cpu_initialize()
{
    int i;
    
    /*
     * int_handler_table[],int_plevel_table[]ν
     * ̤Ͽγȯcpu_interrup()ƤӽФ褦
     * no_reg_interrup()Ͽ
     */
    for(i = 0; i < MAX_INT_NUM; i++){
        int_handler_table[i] = no_reg_interrupt;
        int_bit_table[i]  = 1 << i; /* ӥåȥѥ */
    }

    /*
     *  CPU㳰ϥɥơ֥
     */
    for(i = 0; i < MAX_EXC_NUM; i++){
        exc_handler_table[i] = no_reg_exception; 
    }
}

/*
 *  ץå¸νλ
 *  ߶ػ
 */
void
cpu_terminate()
{
    disint();
}


/*
 * ߤε/ػ
 */
SYSCALL ER
ena_int(INTNO intno){
    set_ienable((1 << intno) | current_ienable()); 
}

SYSCALL ER
dis_int(INTNO intno){
    set_ienable(~(1 << intno) & current_ienable());    
}


/*
 * ̤Ͽγߤȯ˸ƤӽФ
 */
void
no_reg_interrupt(void)
{
    syslog(LOG_EMERG, "Unregisted Interrupt Occur!");
    while(1);
}

/*
 * ̤Ͽ㳰ȯ˸ƤӽФ
 */
void
no_reg_exception(void)
{
    syslog(LOG_EMERG, "Unregisted Exception Occur!");
    while(1);    
}

/*
 * װȽȳߥϥɥθƤӽФ
 */
void
int_handler_call(){
    UW status;
    UW mask;
    int i;
    
    interrupt_count++;
    status = current_ipending();
    for(i = 0; i < 32; i++){
        if((status & (1 << i)) != 0x00){
            mask = current_ienable();
            set_ienable(~int_bit_table[i] & mask);
            
            enaint();
            (int_handler_table[i])();
            disint();
            
            set_ienable(mask);
            break;
        }
    }
    interrupt_count--;    
}

/*
 *  㳰ȽCPU㳰ϥɥθƤӽФ
 *  ߤ̤̿㳰Τߤ򥵥ݡ 
 */
void
exc_handler_call(VP p_excinf){
    interrupt_count++;

    enaint();
    (exc_handler_table[0])(p_excinf);
    disint();
    
    interrupt_count--;    
}
