/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: microblaze.c,v 1.8 2003/12/11 04:52:44 honda Exp $
 */

/*                                                                              * Microblaze ɸڥեѥɥ饤
 */
#include <s_services.h>
#include <microblaze.h>


/*
 * UART Lite ʰץɥ饤
 */

/*                                                                       
 * ꥢI/OݡȽ֥å                                         
 */
const SIOPINIB siopinib_table[TNUM_SIOP] = {{}};

/*                                                                      
 *  ꥢI/Oݡȴ֥åΥꥢ                                
 */
SIOPCB  siopcb_table[TNUM_SIOP];

/*                                                                          
 *  ꥢI/OݡID֥åФΥޥ                  
 */
#define INDEX_SIOP(siopid)  ((UINT)((siopid) - 1))
#define get_siopcb(siopid)  (&(siopcb_table[INDEX_SIOP(siopid)]))

Inline void
uart_ena_int(void){
  sil_wrw_mem((VP)UARTLITE_CTREG,
              sil_rew_mem((VP)UARTLITE_CTREG) | UARTLITE_ENABLE_INTR);
}

Inline void
uart_dis_int(void){
  sil_wrw_mem((VP)UARTLITE_CTREG,
              sil_rew_mem((VP)UARTLITE_CTREG) & ~UARTLITE_ENABLE_INTR);
}

/*
 * ʸ?                                                       
 */
Inline BOOL
uart_getready(SIOPCB *siopcb)
{
    return((sil_rew_mem((VP)UARTLITE_SRREG) &
            UARTLITE_RX_FIFO_VALID_DATA) != 0);

}

/*                                                                             
 * ʸǤ뤫?                                                         
 */
Inline BOOL
uart_putready(SIOPCB *siopcb)
{
  return((sil_rew_mem((VP)UARTLITE_SRREG) & UARTLITE_TX_FIFO_FULL) == 0);
}

/*                                                                             
 *  ʸμФ                                                     
 */
Inline UB
uart_getchar(SIOPCB *siopcb)
{
    return((UB)sil_rew_mem((VP)UARTLITE_RXREG));
}

/*                                                                            
 *  ʸν񤭹                                                    
 */
Inline void
uart_putchar(SIOPCB *siopcb, UB c)
{
  sil_wrw_mem((VP)UARTLITE_TXREG, c);
}

/*
 * ؿ
 * UART Lite ˤߤ̤˶ػߵĤ뵡ǽϤʤ
 * Τᡤλˤɬ1ߤ  
 */
/*                                                                             
 *  ߵ                                                             
 */
Inline void
uart_enable_send(SIOPCB *siopcb)
{
  
}

/*                                                                             
 *  ߶ػ                                                             
 */
Inline void
uart_disable_send(SIOPCB *siopcb)
{

}


/*                                                                             
 *  SIOɥ饤Фν롼                                                
 *  1ݡȤʤᡤޤ̣Ϥʤ                                      
 */
void
uart_initialize()
{
    SIOPCB  *siopcb;
    UINT    i;

    /*                                                                         
     *  ꥢI/Oݡȴ֥åν                                  
     */
    for (siopcb = siopcb_table, i = 0; i < TNUM_SIOP; siopcb++, i++) {
        siopcb->siopinib = &(siopinib_table[i]);
        siopcb->openflag = FALSE;
        siopcb->sendflag = FALSE;
    }
}


SIOPCB   *
uart_opn_por(ID siopid, VP_INT exinf){

    SIOPCB      *siopcb;
    const SIOPINIB  *siopinib;

    siopcb = get_siopcb(siopid);
    siopinib = siopcb->siopinib;

    /*
     *  Хåեꥢ
     */
    sil_wrw_mem((VP)UARTLITE_CTREG, UARTLITE_RST_RX_FIFO
                | UARTLITE_RST_TX_FIFO | UARTLITE_ENABLE_INTR);
    
//    sil_wrw_mem((VP)UARTLITE_CTREG, UARTLITE_RST_RX_FIFO
//                | UARTLITE_RST_TX_FIFO );
    
    siopcb->exinf = exinf;
    siopcb->getready = siopcb->putready = FALSE;
    siopcb->openflag = TRUE;

    return(siopcb);
}


void
uart_cls_por(SIOPCB *siopcb){
  sil_wrw_mem((VP)UARTLITE_CTREG, ~UARTLITE_ENABLE_INTR);   /* ߶ػ    */
  siopcb->openflag = FALSE;
  siopcb->sendflag = FALSE;
}



/*                                                                             
 *  ꥢI/OݡȤؤʸ                                            
 */
BOOL
uart_snd_chr(SIOPCB *siopcb, INT chr)
{
    if(uart_putready(siopcb)){
        uart_putchar(siopcb, (UB) chr);
        return(TRUE);
    }
    return(FALSE);
}


/*
 *  ꥢI/OݡȤʸ
 */
INT
uart_rcv_chr(SIOPCB *siopcb)
{
    if (uart_getready(siopcb)) {
        return((INT)(UB) uart_getchar(siopcb));
    }
    return(-1);
}

/*
 *  OPB_UARTLITE ȼߤ̤˵/ػߤ뵡ǽϻʤ
 */

/*
 *  ꥢI/OݡȤΥХåε
 */
void
uart_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{

}

/*
 *  ꥢI/OݡȤΥХåζػ
 */
void
uart_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{

}


/*                                                                            
 *  ꥢI/OݡȤФ߽                                       
 */
static void
uart_isr_siop(SIOPCB *siopcb)
{
    /*
     * åߤΤ߽ACK
     */
    intc_ack_interrupt(1 << (UARTINTLVL - 1));
    
    if (uart_getready(siopcb)) {
        /*
         *  ΥХå롼ƤӽФ
         */
        uart_ierdy_rcv(siopcb->exinf);
    }

    if (uart_putready(siopcb)) {
        /*
         *  ǽХå롼ƤӽФ
         */
        uart_ierdy_snd(siopcb->exinf);
    }
}


/*                                                                             
 *  SIOγߥӥ롼                                                
 */
void
uart_isr()
{
    if (siopcb_table[0].openflag) {
        uart_isr_siop(&(siopcb_table[0]));
    }
}

