/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: dve68k_dga.h,v 1.2 2003/06/04 01:52:23 hiro Exp $
 */

/*
 *	DGAΥ桼ƥƥ
 */

#ifndef _DVE68K_DGA_H_
#define _DVE68K_DGA_H_

/*
 *  DGAγӥåȤ
 */
#define TBIT_ABT	0x40000000u	/* ܡȳߥӥå */
#define TBIT_SQR	0x04000000u	/* SQR ߥӥå */
#define	TBIT_TT0	0x00100000u	/* 0 ߥӥå */
#define	TBIT_GP0	0x00010000u	/* ꥢI/O ߥӥå */

/*
 *  DGAγߥ٥Τ
 */
#define	TIRQ_NMI	0x7u		/* Υޥ֥ */
#define	TIRQ_LEVEL6	0x6u		/* ߥ٥6 */
#define	TIRQ_LEVEL5	0x5u		/* ߥ٥5 */
#define	TIRQ_LEVEL4	0x4u		/* ߥ٥4 */
#define	TIRQ_LEVEL3	0x3u		/* ߥ٥3 */
#define	TIRQ_LEVEL2	0x2u		/* ߥ٥2 */
#define	TIRQ_LEVEL1	0x1u		/* ߥ٥1 */

#define TBIT_ABTIL	24		/* ܡȳ */
#define TBIT_SQRIL	8		/* SRQ  */

#define TBIT_TT0IL	16		/* 0  */
#define TBIT_GP0IL	0		/* ꥢI/O  */

#ifndef _MACRO_ONLY

/*
 *  DGAΥ쥸ؤΥؿ
 */

Inline UW
dga_read(VP addr)
{
	return((UW) dga_rew_reg(addr));
}

Inline void
dga_write(VP addr, UW val)
{
	dga_wrw_reg(addr, (VW) val);
}

Inline void
dga_bit_or(VP addr, UW bitpat)
{
	dga_write(addr, dga_read(addr) | bitpat);
}

Inline void
dga_bit_and(VP addr, UW bitpat)
{
	dga_write(addr, dga_read(addr) & bitpat);
}

Inline void
dga_set_ilv(VP addr, UINT shift, UINT level)
{
	dga_write(addr, (dga_read(addr) & ~(0x07 << shift))
						| (level << shift));
} 

#endif /* _MACRO_ONLY */
#endif /* _DVE68K_DGA_H_ */
