/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_support.S,v 1.16 2005/11/12 14:58:46 hiro Exp $
 */

/*
 *	ץå¸⥸塼 ֥M68040ѡ
 */

#define	_MACRO_ONLY
#include "jsp_kernel.h"
#include "offset.h"

/*
 *  ǥѥå
 *
 *  dispatch ϡޥ⡼ɡ߶ػ߾֤ǸƤӽФʤФʤ
 *  exit_and_dispatch ⡤ޥ⡼ɡ߶ػ߾֤ǸƤӽФ
 *  §Ǥ뤬ͥ뵯ưб뤿ᡤߥ⡼ɤǸƤӽ
 *  ˤбƤ롥
 */
	.text
	.globl dispatch
	.globl exit_and_dispatch
dispatch:
	movem.l %d2-%d7/%a2-%a6, -(%sp)	/* 쥸¸ */
	move.l runtsk, %a0		/* A0  runtsk  */
	move.l %sp, TCB_msp(%a0)	/* å¸ */
	move.l #dispatch_r, TCB_pc(%a0)	/* ¹ԺƳϤ¸ */
	jbra dispatcher

dispatch_r:
	movem.l (%sp)+, %d2-%d7/%a2-%a6	/* 쥸 */
	btst.b #TCB_enatex_bit, TCB_enatex(%a0)
	jbeq dispatch_r_1		/* enatex  FALSE ʤ꥿ */
	tst.l TCB_texptn(%a0)		/* texptn  0 Ǥʤ           */
	jbne call_texrtn		/*   㳰롼θƽФ */
dispatch_r_1:
	rts

exit_and_dispatch:
	or.w #0x1000, %sr		/* ޥ⡼ */
dispatcher:
	/*
	 *  Ǥϥޥ⡼ɡ߶ػ߾֤ǤʤФʤʤ
	 */
	move.l schedtsk, %a0
	move.l %a0, runtsk		/* schedtsk  runtsk  */
	jbeq dispatcher_1		/* runtsk 뤫 */
	move.l TCB_msp(%a0), %sp	/* å */
	move.l TCB_pc(%a0), %a1		/* ¹ԺƳϤ */
	jmp (%a1)
dispatcher_1:
	
	stop #0x2000			/* Ԥʳߥ⡼ɡ */
	/*
	 *  ǳߥ⡼ɤڤ괹Τϡȯ߽
	 *  ˤɤΥåȤȤβȡߥϥɥ
	 *  ΥǥѥåɻߤȤ2Ĥΰ̣롥
	 *
	 *   stop̿ϡIPM  0 ˤ뤬 task_intmask 
	 *  ꤹ٤Ǥ롥M68040 Ǥϡstop ̿Υѥ᡼
	 *  Ȥʤᡤ򤨤 0 ˤƤstop ̿ 8
	 *  ¤٤ơtask_intmask ͤʬϤ뤬ޤ
	 *  յϤʤȹͤˡ
	 *
	 *  ץåԤ⡼ɤ˰ܹԤȡߵĤȤϡ
	 *  Բʬ˹ԤʤɬפM68040 Ǥ stop̿ξԤʤ
	 *  ΤʤˡԲʬ˹Ԥʤʤ硤ߤ
	 *  ľ˳ߤꡤǥ¹Բǽ֤ˤʤ
	 *  ȡ¹Ԥ٤ˤ⤫餺ץåԤ⡼
	 *  ɤˤʤäƤޤ
	 *
	 *  ߤԤĴ֤ϡruntsk  NULL=0ˤꤷʤФʤ
	 *  ʤΤ褦ꤷʤȡߥϥɥ餫 iget_tid 
	 *  ƤӽФݤưͤ˹פʤʤ롥
	 */
	or.w #0x1700, %sr		/* ޥ⡼ɡ߶ػ */
	tst.l reqflg			/* reqflg  FALSE ʤ */
	jbeq dispatcher_1		/*      dispatcher_1  */
	clr.l reqflg			/* reqflg  FALSE  */
	jbra dispatcher
	
/*
 *  ư
 */
	.text
	.globl activate_r
activate_r:
	/*
	 *  ưľϥ㳰ػߤƤ뤿ᡤǥ
	 *  㳰롼ƤӽФΩʤ
	 */
#ifdef SUPPORT_CHG_IPM			/* t_unlock_cpu ν */
	move.w %sr, %d0			/* ߥޥ task_intmask  */
	and.w #~0x0700, %d0
	or.w task_intmask, %d0
	move.w %d0, %sr
#else /* SUPPORT_CHG_IPM */
	and.w #~0x0700, %sr		/* ߵ */
#endif /* SUPPORT_CHG_IPM */
	move.l (%sp)+, %a0		/* εưϤ a0  */
	jmp (%a0)

/*
 *  ߥϥɥ顿CPU㳰ϥɥи
 *
 *  ret_int ϳߥ⡼ɡ߶ػ߾֤ǡret_exc ϥޥ⡼ɡ
 *  ߶ػ߾֤ǸƤӽФʤФʤʤޤ ret_exc ϡ
 *  쥸¸֤ǸƤӽФȡ
 */
	.text
	.globl ret_int
	.globl ret_exc
ret_int:
	addq.l #8, %sp			/* ե졼ΤƤ */
	or.w #0x1000, %sr		/* ޥ⡼ */
	movem.l %d0-%d1/%a0-%a1, -(%sp)	/* å쥸¸ */
ret_exc:
	clr.l reqflg			/* reqflg  FALSE  */
	move.l runtsk, %a0		/* A0  runtsk */
	tst.l enadsp			/* enadsp  FALSE ʤ */
	jbeq ret_int_1			/*         ret_int_1  */
	cmp.l schedtsk, %a0		/* runtsk  schedtsk Ʊʤ */
	jbeq ret_int_1			/*                  ret_int_1  */
	movem.l %d2-%d7/%a2-%a6, -(%sp)	/* ĤΥ쥸¸ */
	move.l %sp, TCB_msp(%a0)	/* å¸ */
	move.l #ret_int_r, TCB_pc(%a0)	/* ¹ԺƳϤ¸ */
	jbra dispatcher

ret_int_r:
	movem.l (%sp)+, %d2-%d7/%a2-%a6	/* 쥸 */
ret_int_1:
	btst.b #TCB_enatex_bit, TCB_enatex(%a0)
	jbeq ret_int_2			/* enatex  FALSE ʤ꥿ */
	tst.l TCB_texptn(%a0)		/* texptn  0 ʤ꥿ */
	jbeq ret_int_2
	jsr call_texrtn			/* 㳰롼θƽФ */
ret_int_2:
#ifdef SUPPORT_CHG_IPM
	move.w 16(%sp), %d0		/* γߥޥ */
	and.w #~0x0700, %d0		/*        task_intmask  */
	or.w task_intmask, %d0
	move.w %d0, 16(%sp)
#endif /* SUPPORT_CHG_IPM */
	movem.l (%sp)+, %d0-%d1/%a0-%a1	/* å쥸 */
	rte

/*
 *  Ԥ
 */
	.globl _sil_dly_nse
_sil_dly_nse:
	subi.l #SIL_DLY_TIM1, %d0	/* D0  SIL_DLY_TIM1  */
	jbhi _sil_dly_nse_1		/* ̤ 0 ʲʤ꥿ */
	rts
_sil_dly_nse_1:
	subi.l #SIL_DLY_TIM2, %d0	/* D0  SIL_DLY_TIM2  */
	jbhi _sil_dly_nse_1		/* ̤ 0 礭Х롼 */
	rts
