/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003-2004 by Platform Development Center
 *                                          RICOH COMPANY,LTD. JAPAN
 * 
 *  嵭ԤϡFree Software Foundation ˤäƸɽƤ 
 *  GNU General Public License  Version 2 ˵ҤƤ狼
 *  (1)(4)ξ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥѲǽʥХʥꥳɡʥ֥륪
 *      ȥե饤֥ʤɡˤηѤˤϡ
 *      ȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭ɽ
 *      Ѿ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥԲǽʥХʥꥳɤηޤϵ
 *      ߹ѤˤϡΤ줫ξȡ
 *    (a) ѤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) Ѥη֤̤ˡˤäơ嵭Ԥ𤹤
 *        ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭Ԥդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥϡ
 *  ܥեȥ˴ؤơŬѲǽޤơʤݾڤԤ
 *  ʤޤܥեȥѤˤľŪޤϴŪ
 *  ʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sfruart.h,v 1.3 2005/11/24 12:41:23 honda Exp $
 */

/*
 *	ꥢI/OǥХSIO˥ɥ饤Сm16rѡ
 */

#ifndef _SFRUART_H_
#define _SFRUART_H_

#include <t_config.h>

/*
 *  ꥢI/Oݡȴ֥å
 */
typedef struct sio_port_control_block	SIOPCB;

/*
 *  Хå롼μֹ
 */
#define SIO_ERDY_SND		1u			/* ǽХå			*/
#define SIO_ERDY_RCV		2u			/* ΥХå			*/

/*
 *  SIOɥ饤Фν롼
 */
extern void	sfruart_initialize(void);

/*
 *  ꥢI/OݡȤΥץ
 */
extern SIOPCB * sfruart_opn_por(ID siopid, VP_INT exinf);

/*
 *  ꥢI/OݡȤΥ
 */
extern void	sfruart_cls_por(SIOPCB *siopcb);

/*
 *  ꥢI/OݡȤؤʸ
 */
extern BOOL	sfruart_snd_chr(SIOPCB *siopcb, char c);

/*
 *  ꥢI/OݡȤʸ
 */
extern INT	sfruart_rcv_chr(SIOPCB *siopcb);

/*
 *  ꥢI/OݡȤΥХåε
 */
extern void	sfruart_ena_cbr(SIOPCB *siopcb, UINT cbrtn);

/*
 *  ꥢI/OݡȤΥХåζػ
 */
extern void	sfruart_dis_cbr(SIOPCB *siopcb, UINT cbrtn);

/*
 *  ꥢI/OݡȤǽХå
 */
extern void	sfruart_ierdy_snd(VP_INT exinf);

/*
 *  ꥢI/OݡȤμΥХå
 */
extern void	sfruart_ierdy_rcv(VP_INT exinf);

#endif /* _SFRUART_H_ */
