/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003-2004 by Naoki Saito
 *             Nagoya Municipal Industrial Research Institute, JAPAN
 *  Copyright (C) 2003-2004 by Platform Development Center
 *                                          RICOH COMPANY,LTD. JAPAN
 * 
 *  嵭ԤϡFree Software Foundation ˤäƸɽƤ 
 *  GNU General Public License  Version 2 ˵ҤƤ狼
 *  (1)(4)ξ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥѲǽʥХʥꥳɡʥ֥륪
 *      ȥե饤֥ʤɡˤηѤˤϡ
 *      ȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭ɽ
 *      Ѿ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥԲǽʥХʥꥳɤηޤϵ
 *      ߹ѤˤϡΤ줫ξȡ
 *    (a) ѤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) Ѥη֤̤ˡˤäơ嵭Ԥ𤹤
 *        ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭Ԥդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥϡ
 *  ܥեȥ˴ؤơŬѲǽޤơʤݾڤԤ
 *  ʤޤܥեȥѤˤľŪޤϴŪ
 *  ʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: hw_timer.h,v 1.5 2007/01/05 02:33:59 honda Exp $
 */

/*
 *	ޥɥ饤СOAKS16ѡ
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <s_services.h>
#include <sil.h>
#include <oaks16.h>

/*
 *  ޳ߥϥɥΥ٥ֹ
 */
#define	INHNO_TIMER	       INT_TA0

/*
 *  ޡγߥ٥
 */

#define INT_LEVEL_TIMER	0x05

#ifndef _MACRO_ONLY

/*
 *  ͤɽη
 */
typedef UH	CLOCK;

/*
 *  ͤɽȥߥñ̤ȤѴ
 *
 *  1msΥޡߤѤΤǤΥå롥
 */
#define TIMER_CLOCK		16000
#define TO_CLOCK(nume, deno)	(TIMER_CLOCK * (nume) / (deno))
#define	TO_USEC(clock)		((clock) * 1000 / TIMER_CLOCK)

/*
 *  ǤΥ޼ñ̤ɽ
 */
#define	MAX_CLOCK	((CLOCK) 0xffff)

/*
 *  ǽɾѥƥФݤν֤θѤ͡ñ̤ɽ
 */
#define	GET_TOLERANCE	100	/* ٤θѤ͡ñ̤ɽ*/
#define	BEFORE_IREQ(clock) \
		((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)

/*
 *  ޤεư
 *
 *  ޤŪʥ޳׵ȯ롥
 */
Inline void
hw_timer_initialize(void)
{
		/* ޽ */
	sil_wrb_mem((VP)TADR_SFR_TABSR, 0x00);		/* ޥ  */
	sil_wrb_mem((VP)TADR_SFR_UDF, 0x00);		/* 󥫥				*/
	sil_wrb_mem((VP)TADR_SFR_TA0MR, 0x00);		/*  ȥf1, ޥ⡼  */
	/*
	 *  ޤ 1ms TIMER_CLOCK ,
	 *  쥸ͤϥޥʥ1.
	 */
	sil_wrh_mem((VP)TADR_SFR_TA0, TIMER_CLOCK-1);/* ͤν				*/
												/* ߥ٥				*/
	set_ic_ilvl((VP)(TADR_SFR_INT_BASE+TADR_SFR_TA0IC_OFFSET), INT_LEVEL_TIMER);
												/* ȳ						*/
	sil_wrb_mem((VP)TADR_SFR_TABSR, TBIT_TABSR_TA0S);
}

/*
 *  ޳׵Υꥢ
 */
Inline void
hw_timer_int_clear(void)
{
	/*
	 *  δؿϥ޳ߥϥɥ餬
	 *  isig_tim ƤӽФ˼¹Ԥ.
	 *  ߤդƤ
	 *  ߥϥɥ˽ܤä
	 *  ׵ӥåȤϥꥢ뤿
	 *  ⤹ɬפʤ. 
	 */
}

/*
 *  ޤ߽
 *
 *  ޤưߤ롥
 */
Inline void
hw_timer_terminate(void)
{
	VB  c;

	c = sil_reb_mem((VP)TADR_SFR_TABSR);
	c &= ~TBIT_TABSR_TA0S;						/* Ƚλ						*/
	sil_wrb_mem((VP)TADR_SFR_TABSR, c);
}

/*
 *  ޤθͤɽФ
 */
Inline CLOCK
hw_timer_get_current(void)
{
	return (TIMER_CLOCK-1)-sil_reh_mem((VP)TADR_SFR_TA0);
}

/*
 *  ޳׵Υå
 */
Inline BOOL
hw_timer_fetch_interrupt(void)
{
	return (sil_reb_mem((VP)(TADR_SFR_INT_BASE+TADR_SFR_TA0IC_OFFSET)) & TBIT_TAiIC_IR) != 0;
}

#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */
