/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_defs.h,v 1.16 2007/03/23 07:22:15 honda Exp $
 */

/*
 *	ץå˰¸H8ѡ
 *
 *  Υ󥯥롼ɥեϡkernel.h  sil.h ǥ󥯥롼ɤ롥
 *  ¾Υե뤫ľܥ󥯥롼ɤ뤳ȤϤʤΥե򥤥
 *  롼ɤˡt_stddef.h  itron.h 󥯥롼ɤΤǡ
 *  ˰¸Ƥ褤
 */

#ifndef _CPU_DEFS_H_
#define _CPU_DEFS_H_

#include <h8.h>		/*  IPM_LEVEL0,1,2  */
#define H8

/* ͥ뵯ưΥå */
#define COPYRIGHT_CPU \
"Copyright (C) 2001-2007 by Industrial Technology Institute,\n" \
"                            Miyagi Prefectural Government, JAPAN\n" \
"Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering\n" \
"                 Tomakomai National College of Technology, JAPAN\n" \
"Copyright (C) 2003-2004 by Katsuhiro Amano\n"

/*
 *  ƥå
 */

#define	TIC_NUME	1		/* ƥåμʬ */
#define	TIC_DENO	1		/* ƥåμʬ */

/*
 *  CPU ΥХȽ˴ؤ
 */

#define SIL_ENDIAN		SIL_ENDIAN_BIG

#ifndef _MACRO_ONLY
typedef	UINT	INHNO;			/* ߥϥɥֹ */
typedef	UINT	EXCNO;			/* CPU㳰ϥɥֹ */
#endif /* _MACRO_ONLY */

/*
 *  åȥƥ¸Υӥ
 *
 * cpu_defs.hsys_defs.h򥤥󥯥롼ɤ֤δط
 * SUPPORT_CHG_IPMޥSUPPORT_VXGET_TIMޥǤϰϤޤʤ
 * _MACRO_ONLYޥǰϤСʬ
 */

/*
 *  ߥޥηȳߥޥѹ
 */
#ifndef _MACRO_ONLY
typedef UB              IPM;            /* ߥޥ */

extern ER       chg_ipm(IPM ipm) throw();
extern ER       get_ipm(IPM *p_ipm) throw();


/*
 *  ץ饤ƥ٥ѤΥǡ¤
 */
typedef struct {
        UB *ipr;        /* ꤹIPR쥸 */
        UB bit;         /* IPR쥸γӥåֹ */
        IPM ipm;        /* ꤹߥ٥ */
                        /* IPM_LEVEL0,IPM_LEVEL1Τ줫 */
} IRC;                  /* IRC:Interrupt Request Controller */


/*
 *  ǽɾѥƥ¬ǽ
 */

/* ǽɾѥƥ */
#ifdef _int64_		/*  64ӥå  */
typedef	UD  SYSUTIM;
#else 	/*  _int64_  */
typedef	UW  SYSUTIM;
#endif	/*  _int64_  */

extern ER   vxget_tim(SYSUTIM *pk_sysutim) throw();

/*
 *  ƥǽ
 */

Inline void
kernel_abort (void)
{
	while (1)
		;
}

#endif /* _MACRO_ONLY */

#endif /* _CPU_DEFS_H_ */
