/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 *  @(#) $Id: sys_config.h,v 1.7 2007/03/23 07:58:33 honda Exp $
 */

/*
 *åȥƥ¸⥸塼Ż HSB8F3048BF25ѡ
 *ͥǻѤ
 *ǡޥؿΥץȥ
 *
 *  Υ󥯥롼ɥեϡt_config.h Τߤ饤󥯥롼ɤ롥
 *  ¾Υե뤫ľܥ󥯥롼ɤƤϤʤʤ
 */

#ifndef _SYS_CONFIG_H_
#define _SYS_CONFIG_H_

/*
 *  ͥ̾Υ͡
 */

#include <sys_rename.h>

/*
 *  桼ե졼
 */
#include <user_config.h>


/*
 *  åȥƥΥϡɥ񸻤
 */

#include <h8_3048f.h>

/*
 *  ưåΥå̾
 */

#define TARGET_NAME     "Hokuto Electronic H8/3048F-ONE STARTER KIT"


#ifndef _MACRO_ONLY

/*
 *  åȥƥ¸ν
 */

extern void     sys_initialize(void);

/*
 *  åȥƥνλ
 *
 *  ƥλ˻ȤROM˥ƽФǼ¸뤳Ȥꤷ
 *  Ƥ롥
 */

extern void     sys_exit(void);

/*
 *  åȥƥʸ
 *
 *  ƥ٥ʸϥ롼ROM˥ƽФǼ¸뤳
 *  ȤꤷƤ롥
 */
extern void     sys_putc(char c) throw();

#endif /* _MACRO_ONLY */

/*
 *  SOFTWARE_TERM_HOOKޥatexitν
 *  ؿγСδؿ̾SOFTWARE_TERM_HOOK
 *ޥȤ롣
 */
/*  ʤ  */


/*
 *  (1) ꥢݡȤ
 *  (2) ޡ
 *  (3) ɥ쥹
 */

/*
 *  SCI ޥ
 */

        /* SCI 򥯥Ԥ֤η׻˻Ѥ롣*/
#define H8_MIN_BAUD_RATE        9600ul

/*
 *  SYSTEM  SCI 
 */
                                /* ƥϤ륷ꥢݡֹ     */
#define LOGTASK_PORTID          SYSTEM_PORTID   /*  user_config.h  */

/*  쥸Υ١ɥ쥹  */
#define SCI_PORT1_BASE          H8SCI0

/*  ץ饤ƥ٥ѤΥǡ  */
#define SCI_PORT1_IPR          H8IPRB
#define SCI_PORT1_IPR_BIT      H8IPR_SCI0_BIT

#define SCI_PORT1_SMR          0u
                        /* եޥå                   */
                        /* ĴƱ                           */
                        /* 饯󥰥8ӥå          */
                        /* ѥƥʤ                         */
                        /* ȥåץӥåȥ󥰥1            */
                        /* å쥯ȡʬ:1         */

#define INHNO_SERIAL_IN         IRQ_RXI0
#define INHNO_SERIAL_OUT        IRQ_TXI0
#define INHNO_SERIAL_ERR        IRQ_ERI0


#if TNUM_PORT == 2

#define SCI_PORT2_BASE          H8SCI1

/*  ץ饤ƥ٥ѤΥǡ  */
#define SCI_PORT2_IPR          H8IPRB
#define SCI_PORT2_IPR_BIT      H8IPR_SCI1_BIT

#define SCI_PORT2_SMR          0u
                        /* եޥå                   */
                        /* ĴƱ                           */
                        /* 饯󥰥8ӥå          */
                        /* ѥƥʤ                         */
                        /* ȥåץӥåȥ󥰥1            */
                        /* å쥯ȡʬ:1         */

#define INHNO_SERIAL2_IN        IRQ_RXI1
#define INHNO_SERIAL2_OUT       IRQ_TXI1
#define INHNO_SERIAL2_ERR       IRQ_ERI1

#endif  /* of #if TNUM_PORT == 2u */

/*
 *  ޤ
 */

#define SYSTEM_TIMER            H8ITU0

#define SYSTEM_TIMER_CNT        (SYSTEM_TIMER + H8TCNT)
#define SYSTEM_TIMER_TCR        (SYSTEM_TIMER + H8TCR)
#define SYSTEM_TIMER_TIOR       (SYSTEM_TIMER + H8TIOR)
#define SYSTEM_TIMER_IER        (SYSTEM_TIMER + H8TIER)
#define SYSTEM_TIMER_IFR        (SYSTEM_TIMER + H8TSR)
#define SYSTEM_TIMER_TSTR       H8ITU_TSTR
#define SYSTEM_TIMER_GR         (SYSTEM_TIMER + H8GRA)

#define SYSTEM_TIMER_STR        H8TSTR_STR0
#define SYSTEM_TIMER_STR_BIT    H8TSTR_STR0_BIT
#define SYSTEM_TIMER_IE         H8TIER_IMIEA            /* interrupt mask */
#define SYSTEM_TIMER_IE_BIT     H8TIER_IMIEA_BIT
#define SYSTEM_TIMER_IF         H8TSR_IMIFA             /* match flag */
#define SYSTEM_TIMER_IF_BIT     H8TSR_IMIFA_BIT

#define INHNO_TIMER             IRQ_IMIA0

#define SYSTEM_TIMER_TCR_BIT    (H8TCR_CCLR0 | H8TCR_TPSC1 | H8TCR_TPSC0)
#define SYSTEM_TIMER_TIOR_BIT   (0u)

/*  ץ饤ƥ٥ѤΥǡ  */
#define SYSTEM_TIMER_IPR                H8IPRA
#define SYSTEM_TIMER_IP_BIT             H8IPR_ITU0_BIT

/*
 *  I/Oݡ DDRν
 *      h8_sil.cDDR롼ǻѤ롣
 *      ݡȣѤΤᡢάƤ롣
 */
#define H8P1DDR0        0xffu	/*  ɥ쥹Х  */
#define H8P2DDR0        0xffu	/*  ɥ쥹Х  */
#define H8P3DDR0        0u	    /*  ǡХ  */
#define H8P4DDR0        0u      /*  ǡХ  */
#define H8P5DDR0        0x0fu	/*  ɥ쥹Х  */
#define H8P6DDR0        0u
#define H8P8DDR0        H8P8DDR_CS1     /*  P83CS1  */
#define H8P9DDR0        0u
#define H8PADDR0        0u
#define H8PBDDR0        0u

/*
 *  SYSCRν
 *      $SYSǥ쥯ȥSYSCR_SYSȤ
 *      ӥå6-4 STSХޡ쥯
 *      ӥå2 NMIEGNMIå
 */
#define SYSCR_SYS	0u


#endif /* _SYS_CONFIG_H_ */
