/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 *  @(#) $Id: h8_sil.h,v 1.7 2007/03/23 07:58:33 honda Exp $
 */

/*
 *  H8SILγĥʥӥåȱ黻
 *
 *  h8.h˵ҤΤ쥬Ȥsil.hȤΥ󥯥롼ɤ
 *  ֤δطΩեȤ
 *  t_config.hľܥ󥯥롼ɤȤsil.hˤ
 *  ե뤬󥯥롼ɤǽ롣
 *
 *  ѥηåǽͭˤ뤿ᡢݥ󥿷
 *  UB *UH *UW *ѤƤ롣
 *
 */

#ifndef _SIL_H8_H_
#define _SIL_H8_H_

#ifndef _MACRO_ONLY

#include <sil.h>
#include <cpu_insn.h>	/*  bitset(), bitclr()  */

/*
 *  8ӥåȥ쥸AND黻
 */
Inline void
h8_anb_reg(UB *mem, UB data)
{
        UB reg = sil_reb_mem((VP)mem);
        reg &= data;
        sil_wrb_mem((VP)mem, (VB)reg);
}

/*
 *  8ӥåȥ쥸OR黻
 */
Inline void
h8_orb_reg(UB *mem, UB data)
{
        UB reg = sil_reb_mem((VP)mem);
        reg |= data;
        sil_wrb_mem((VP)mem, (VB)reg);
}


/*
 *  16ӥåȥ쥸AND黻
 */
Inline void
h8_anh_reg(UH *mem, UH data)
{
        UH reg = sil_reh_mem((VP)mem);
        reg &= data;
        sil_wrh_mem((VP)mem, (VH)reg);
}

/*
 *  16ӥåȥ쥸OR黻
 */
Inline void
h8_orh_reg(UH *mem, UH data)
{
        UH reg = sil_reh_mem((VP)mem);
        reg |= data;
        sil_wrh_mem((VP)mem, (VH)reg);
}

/*
 *  32ӥåȥ쥸AND黻
 */
Inline void
h8_anw_reg(UW *mem, UW data)
{
        UW reg = sil_rew_mem((VP)mem);
        reg &= data;
        sil_wrw_mem((VP)mem, (VW)reg);
}

/*
 *  32ӥåȥ쥸OR黻
 */
Inline void
h8_orw_reg(UW *mem, UW data)
{
        UW reg = sil_rew_mem((VP)mem);
        reg |= data;
        sil_wrw_mem((VP)mem, (VW)reg);
}

/*
 *  ߥ٥
 *
 *  irc  IRCǡƬɥ쥹
 *
 *  UB *iprꤹIPR쥸
 *  UB bit IPR쥸γӥåֹ
 *  IPM ipmꤹߥ٥
 *  IPM_LEVEL0,IPM_LEVEL1Τ줫
 */
Inline void
define_int_plevel(const IRC *irc)
{
        UB *ipr = irc->ipr;
        UB bit = irc->bit;
        IPM ipm = irc->ipm;

        switch(ipm) {
                case IPM_LEVEL0:        /*  ץ饤ƥ٥0  */
                        bitclr(ipr, bit);
                        break;
                case IPM_LEVEL1:        /*  ץ饤ƥ٥1  */
                        bitset(ipr, bit);
                        break;
                default:
                        assert(FALSE);
        }
}

/*
 *I/OݡȤΥǡǥ쥯󡦥쥸DDRؤΥ
 *
 *H8DDRϽ񤭹ѤǤꡢΤޤޤǤϽ˾ΥӥåȤ
 *ѹ뤳ȤǤʤbset,bclr̿ǤԲġ
 *ΤᡢܼǤϡ˥ƥݥѰդơDDR
 *ͤݻˡΤäƤ롣
 */
/*
 *DDRֹ
 *
 *ΥǥåѤ롣
 *ݡ7ѤΤᡢάƤ롣
 */
typedef enum {
	IO_PORT1,
	IO_PORT2,
	IO_PORT3,
	IO_PORT4,
	IO_PORT5,
	IO_PORT6,
	IO_PORT8,
	IO_PORT9,
	IO_PORTA,
	IO_PORTB
} IO_PORT;

extern UB sil_reb_ddr(IO_PORT port) throw();
extern void sil_wrb_ddr(IO_PORT port, UB data) throw();
extern void sil_anb_ddr(IO_PORT port, UB data) throw();
extern void sil_orb_ddr(IO_PORT port, UB data) throw();

#endif /* _MACRO_ONLY */
#endif  /*  _SIL_H8_H_  */
