/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 *  Copyright (C) 2007 by KURUSUGAWA Electronics Industry Inc, JAPAN
 *  Copyright (C) 2008 by Takahisa Yokota
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: mcfuart.h,v 1.1 2005/07/06 00:45:07 honda Exp $
 */

/*
 *   COLDFIRE¢UART ʰץɥ饤
 */

#ifndef _MCFUART_H_
#define _MCFUART_H_

#include <t_config.h>

/*
 *  ꥢI/OݡȽ֥å
 */
typedef struct sio_port_initialization_block
{
	UW reg_base;				/* 쥸Υ١ɥ쥹 */
	UH brr;					/* ܡ졼Ȥ   */
	UB smr;					/* ⡼ɥ쥸   */
	UB int_level;				/* ߥ٥   */
} SIOPINIB;

/*
 *  ꥢI/Oݡȴ֥å
 */
typedef struct sio_port_control_block
{
	const SIOPINIB *siopinib;	/* ꥢI/OݡȽ֥å */
	VP_INT exinf;				/* ĥ */
	BOOL openflag;				/* ץѤߥե饰 */
	BOOL getready;				/* ʸ */
	BOOL putready;				/* ʸǤ */
	VB   imr;				/* ߥޥξ */
} SIOPCB;

/*
 *  ȥ쥸Υɥ쥹Υեå 
 */
#define MCF_UART_UMR1	0x00
#define MCF_UART_UMR2	0x00
#define MCF_UART_USR	0x04
#define MCF_UART_UCSR	0x04
#define MCF_UART_UCR	0x08
#define MCF_UART_URB	0x0c
#define MCF_UART_UTB	0x0c
#define MCF_UART_UIPCR	0x10
#define MCF_UART_UACR	0x10
#define MCF_UART_UISR	0x14
#define MCF_UART_UIMR	0x14
#define MCF_UART_UBG1	0x18
#define MCF_UART_UBG2	0x1c
#define MCF_UART_UIP	0x34
#define MCF_UART_UOP1	0x38
#define MCF_UART_UOP0	0x3c

/*
 *  ȥ쥸
 */
/*  FIFOȥ쥸SCFCRΥӥå  */
#define MCF_UART_UCR_RC_MASK  0x03
#define MCF_UART_UCR_RC_EN   0x01
#define MCF_UART_UCR_RC_DIS  0x02
#define MCF_UART_UCR_TC_MASK  0x0C
#define MCF_UART_UCR_TC_EN   0x04
#define MCF_UART_UCR_TC_DIS  0x08
#define MCF_UART_UCR_MISC_MASK 0x70
#define MCF_UART_UCR_MISC_RRC  0x10
#define MCF_UART_UCR_MISC_RR   0x20
#define MCF_UART_UCR_MISC_RT   0x30
#define MCF_UART_UCR_MISC_RE   0x40
#define MCF_UART_UCR_MISC_RBK  0x50
#define MCF_UART_UCR_MISC_SBK  0x60
/*  ꥢ륳ȥ쥸UIMRΥӥå  */
#define MCF_UART_UIMR_TXRDY 0x01
#define MCF_UART_UIMR_RXRDY 0x02
#define MCF_UART_UIMR_DB    0x04
/*  ꥢ륳ȥ쥸UISRΥӥå  */
#define MCF_UART_UISR_TXRDY 0x01
#define MCF_UART_UISR_RXRDY 0x02
#define MCF_UART_UISR_DB    0x04
/*  ꥢ륹ơ쥸SC1SSRΥӥå  */
#define MCF_UART_USR_RXRDY (0x01)	/* ǥ */
#define MCF_UART_USR_FULL  (0x02)	/* FIFOե   */
#define MCF_UART_USR_TXRDY (0x04)	/* ǥ */
#define MCF_UART_USR_TEMP  (0x08)	/* ȥ󥹥ߥåץƥ */
#define MCF_UART_USR_OE    (0x10)	/* С󥨥顼 */
#define MCF_UART_USR_RE    (0x20)	/* ѥƥ顼 */
#define MCF_UART_USR_FE    (0x40)	/* ե졼ߥ󥰥顼 */
#define MCF_UART_USR_RB    (0x80)	/* ֥졼 */

/*
 *  UBG
 */
#define SMR_CKS 	0x0			/*  ʬ          */
#define BRR9600 	195 			/*  9600 ӥåȥ졼    */
#define BRR19200	97			/*  19200 ӥåȥ졼    */
#define BRR38400	48			/*  38400 ӥåȥ졼    */
#define BRR57600 	32			/*  57600 ӥåȥ졼 	*/
#define BRR115200 	16			/*  115200 ӥåȥ졼 */

/*
 *  Хå롼μֹ
 */
#define SIO_ERDY_SND	1u		/* ǽХå */
#define SIO_ERDY_RCV	2u		/* ΥХå */

/*
 *  SIOɥ饤Фν롼
 */
extern void mcfuart_initialize (void);

/*
 *  ץ󤷤ƤݡȤ뤫
 */
extern BOOL mcfuart_openflag (ID siopid);

/*
 *  ꥢI/OݡȤΥץ
 */
extern SIOPCB *mcfuart_opn_por (ID siopid, VP_INT exinf);

/*
 *  ꥢI/OݡȤΥ
 */
extern void mcfuart_cls_por (SIOPCB * siopcb);

/*
 *  ꥢI/OݡȤؤʸ
 */
extern BOOL mcfuart_snd_chr (SIOPCB * siopcb, char c);

/*
 *  ꥢI/OݡȤʸ
 */
extern INT mcfuart_rcv_chr (SIOPCB * siopcb);

/*
 *  ꥢI/OݡȤΥХåε
 */
extern void mcfuart_ena_cbr (SIOPCB * siopcb, UINT cbrtn);

/*
 *  ꥢI/OݡȤΥХåζػ
 */
extern void mcfuart_dis_cbr (SIOPCB * siopcb, UINT cbrtn);

/*
 *  SIOγߥӥ롼
 */
extern void mcfuart_isr (void);

/*
 *  ꥢI/OݡȤǽХå
 */
extern void mcfuart_ierdy_snd (VP_INT exinf);

/*
 *  ꥢI/OݡȤμΥХå
 */
extern void mcfuart_ierdy_rcv (VP_INT exinf);

#endif /* _MCFUART_H_ */
