/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sample1.c,v 1.6 2007/04/02 03:14:01 honda Exp $
 */

/* 
 *  ץץ(1)
 *
 *  JSPͥδŪưǧ뤿Υץץࡥ
 *
 *  ץγ:
 *
 *  桼󥿥եĥᥤ󥿥ʥID: MAIN_TASK
 *  ͥ: MAIN_PRIORITYˤȡĤ¹Ԥ륿ʥID:
 *  TASK1TASK3ͥ: MID_PRIORITYˤǹ롥ޤư
 *  2äμϥɥʼϥɥID: CYCHDR1ˤѤ롥
 *
 *  ¹Ԥ륿ϡtask_loop 롼פ¹Ԥ٤ˡ
 *  ¹Ǥ뤳Ȥ򤢤魯åɽ롥
 *
 *  ϥɥϡĤͥ١HIGH_PRIORITYMID_PRIORITY
 *  LOW_PRIORITYˤΥǥ塼ž롥ץεưľϡ
 *  ϥɥ߾֤ˤʤäƤ롥
 *
 *  ᥤ󥿥ϡꥢI/OݡȤʸϤԤʸϤ
 *  ԤäƤ֤ϡ¹Ԥ륿¹ԤƤˡϤ줿
 *  ʸб¹Ԥ롥Ϥ줿ʸȽδطϼ̤ꡥ
 *  Control-C ޤ 'Q' Ϥȡץλ롥
 *
 *  '1' : ʹߤΥޥɤ TASK1 ФƹԤ
 *  '2' : ʹߤΥޥɤ TASK2 ФƹԤ
 *  '3' : ʹߤΥޥɤ TASK3 ФƹԤ
 *  'a' :  act_tsk ˤ굯ư롥
 *  'A' : Ф뵯ư׵ can_act ˤꥭ󥻥뤹롥
 *  'e' :  ext_tsk ƤӽФλ롥
 *  't' :  ter_tsk ˤ궯λ롥
 *  '>' : ͥ٤ HIGH_PRIORITY ˤ롥
 *  '=' : ͥ٤ MID_PRIORITY ˤ롥
 *  '<' : ͥ٤ LOW_PRIORITY ˤ롥
 *  'G' : ͥ٤ get_pri ɤ߽Ф
 *  's' :  slp_tsk ƤӽФԤˤ롥
 *  'S' :  tslp_tsk(10) ƤӽФԤˤ롥
 *  'w' :  wup_tsk ˤ굯롥
 *  'W' : Ф뵯׵ can_wup ˤꥭ󥻥뤹롥
 *  'l' :  rel_wai ˤ궯ŪԤˤ롥
 *  'u' :  sus_tsk ˤ궯Ԥ֤ˤ롥
 *  'm' : ζԤ֤ rsm_tsk ˤ롥
 *  'M' : ζԤ֤ frsm_tsk ˤ궯롥
 *  'd' :  dly_tsk(10) ƤӽФַвԤˤ롥
 *  'x' : ˥ѥ 0x0001 㳰׵᤹롥
 *  'X' : ˥ѥ 0x0002 㳰׵᤹롥
 *  'y' :  dis_tex ƤӽФ㳰ػߤ롥
 *  'Y' :  ena_tex ƤӽФ㳰Ĥ롥
 *  'r' : Ĥͥ١HIGH_PRIORITYMID_PRIORITYLOW_PRIORITYˤ
 *        ǥ塼ž롥
 *  'c' : ϥɥư롥
 *  'C' : ϥɥߤ롥
 *  'z' : CPU㳰ȯ롥
 *  'Z' : ץλ롥
 *  'V' : vxget_tim ǽɾѥƥ2ɤࡥ
 *  'v' : ȯԤƥॳɽʥǥեȡˡ
 *  'q' : ȯԤƥॳɽʤ
 */

#include <t_services.h>
#include "kernel_id.h"
#include "sample1.h"

/*
 *  ¹Լ¹Ԥ륿ؤΥåΰ
 */
char	message[3];

/*
 *  롼ײ
 */
UW	task_loop;		/* ǤΥ롼ײ */
UW	tex_loop;		/* 㳰롼ǤΥ롼ײ */

/*
 *  ¹Լ¹Ԥ륿
 */
void task(VP_INT exinf)
{
	volatile UW	i;
	INT		n = 0;
	INT		tskno = (INT) exinf;
	const char	*graph[] = { "|", "  +", "    *" };
	char		c;

	ena_tex();
	while (1) {
		syslog(LOG_NOTICE, "task%d is running (%03d).   %s",
					tskno, ++n, graph[tskno-1]);
		for (i = 0; i < task_loop; i++);
		c = message[tskno-1];
		message[tskno-1] = 0;
		switch (c) {
		case 'e':
			syslog(LOG_INFO, "#%d#ext_tsk()", tskno);
			ext_tsk();
		case 's':
			syslog(LOG_INFO, "#%d#slp_tsk()", tskno);
			syscall(slp_tsk());
			break;
		case 'S':
			syslog(LOG_INFO, "#%d#tslp_tsk(10000)", tskno);
			syscall(tslp_tsk(10000));
			break;
		case 'd':
			syslog(LOG_INFO, "#%d#dly_tsk(10000)", tskno);
			syscall(dly_tsk(10000));
			break;
		case 'y':
			syslog(LOG_INFO, "#%d#dis_tex()", tskno);
			syscall(dis_tex());
			break;
		case 'Y':
			syslog(LOG_INFO, "#%d#ena_tex()", tskno);
			syscall(ena_tex());
			break;
#ifdef CPUEXC1
		case 'z':
			syslog(LOG_NOTICE, "#%d#raise CPU exception", tskno);
			RAISE_CPU_EXCEPTION;
			break;
#endif /* CPUEXC1 */
		case 'Z':
			syslog(LOG_NOTICE, "Sample program ends with exception.");
			kernel_exit();
			break;
		default:
			break;
		}
	}
}

/*
 *  ¹ԤƼ¹Ԥ륿ѤΥ㳰롼
 */
void tex_routine(TEXPTN texptn, VP_INT exinf)
{
	volatile UW	i;
	INT	tskno = (INT) exinf;

	syslog(LOG_NOTICE, "task%d receives exception 0x%04x. ",
					tskno, texptn);
	for (i = 0; i < tex_loop; i++);

	if (texptn & 0x8000) {
		syslog(LOG_INFO, "#%d#ext_tsk()", tskno);
		ext_tsk();
	}
}

/*
 *  CPU㳰ϥɥ
 */
#ifdef CPUEXC1

void
cpuexc_handler(VP p_excinf)
{
	ID	tskid;

	syslog(LOG_NOTICE, "CPU exception handler (p_excinf = %08p).",
							p_excinf);
	if (sns_ctx() != TRUE) {
		syslog(LOG_WARNING,
			"sns_ctx() is not TRUE in CPU exception handler.");
	}
	if (sns_dpn() != TRUE) {
		syslog(LOG_WARNING,
			"sns_dpn() is not TRUE in CPU exception handler.");
	}
	syslog(LOG_DEBUG,
		"sns_loc = %d sns_dsp = %d", (int)sns_loc(), (int)sns_dsp());
	syslog(LOG_DEBUG,
		"vxsns_loc = %d vxsns_ctx = %d vxsns_dsp = %d vxsns_dpn = %d",
		(int)vxsns_loc(p_excinf), (int)vxsns_ctx(p_excinf),
		(int)vxsns_dsp(p_excinf), (int)vxsns_dpn(p_excinf));

	if (!vxsns_loc(p_excinf) && !vxsns_ctx(p_excinf)) {
		syscall(iget_tid(&tskid));
		syscall(iras_tex(tskid, 0x8000));
	}
	else {
		syslog(LOG_NOTICE, "Sample program ends with exception.");
		kernel_exit();
	}
}

#endif /* CPUEXC1 */

/*
 *  ϥɥ
 *
 *  HIGH_PRIORITYMID_PRIORITYLOW_PRIORITY γͥ٤Υǥ塼
 *  ž롥
 */
void cyclic_handler(VP_INT exinf)
{
	irot_rdq(HIGH_PRIORITY);
	irot_rdq(MID_PRIORITY);
	irot_rdq(LOW_PRIORITY);
}


#define PORTID_SCI2	3
#if PORTID_SCI2 == TASK_PORTID
#error PORTID_SCI2 == TASK_PORTID is not allowed.
#endif /*  PORTID_SCI2 == TASK_PORTID  */

static const char output_text[] = "This is SCI2 output test.";

/*
 *  ᥤ󥿥
 */
void main_task(VP_INT exinf)
{
	char	c;
	ID	tskid = TASK1;
	volatile UW	i;
	INT	tskno = 1;
	ER_UINT	ercd;	
	PRI	tskpri;
	SYSTIM	stime1, stime2;
#ifndef OMIT_VGET_TIM
	SYSUTIM	utime1, utime2;
#endif /* OMIT_VGET_TIM */

	vmsk_log(LOG_UPTO(LOG_INFO), LOG_UPTO(LOG_EMERG));
	syslog(LOG_NOTICE, "Sample program starts (exinf = %d).", (int)exinf);
	syslog(LOG_NOTICE, "This program output low level log to port POL_PORTID");
	syscall(serial_ctl_por(TASK_PORTID,
			(IOCTL_CRLF | IOCTL_FCSND | IOCTL_FCRCV)));

	/*  SCI2ؤν  */
	syscall(serial_opn_por(PORTID_SCI2));
	syscall(serial_ctl_por(PORTID_SCI2,
			(IOCTL_CRLF | IOCTL_FCSND | IOCTL_FCRCV)));
	syscall(serial_wri_dat(PORTID_SCI2, output_text, sizeof(output_text)));
	
	/*
 	 *  롼ײ
	 */
	task_loop = LOOP_REF;
	get_tim(&stime1);
	for (i = 0; i < task_loop; i++);
	get_tim(&stime2);
	task_loop = LOOP_REF * 400 / (stime2 - stime1);
	tex_loop = task_loop / 5;

	/*
 	 *  εư
	 */
	act_tsk(TASK1);
	act_tsk(TASK2);
	act_tsk(TASK3);

	/*
 	 *  ᥤ롼
	 */
	do {
		syscall(serial_rea_dat(TASK_PORTID, &c, 1));
		switch (c) {
		case 'e':
		case 's':
		case 'S':
		case 'd':
		case 'y':
		case 'Y':
		case 'z':
		case 'Z':
			message[tskno-1] = c;
			break;
		case '1':
			tskno = 1;
			tskid = TASK1;
			break;
		case '2':
			tskno = 2;
			tskid = TASK2;
			break;
		case '3':
			tskno = 3;
			tskid = TASK3;
			break;
		case 'a':
			syslog(LOG_INFO, "#act_tsk(%d)", tskno);
			syscall(act_tsk(tskid));
			break;
		case 'A':
			syslog(LOG_INFO, "#can_act(%d)", tskno);
			syscall(ercd = can_act(tskid));
			if (ercd >= 0) {
				syslog(LOG_NOTICE, "can_act(%d) returns %d",
						tskno, ercd);
			}
			break;
		case 't':
			syslog(LOG_INFO, "#ter_tsk(%d)", tskno);
			syscall(ter_tsk(tskid));
			break;
		case '>':
			syslog(LOG_INFO, "#chg_pri(%d, HIGH_PRIORITY)", tskno);
			chg_pri(tskid, HIGH_PRIORITY);
			break;
		case '=':
			syslog(LOG_INFO, "#chg_pri(%d, MID_PRIORITY)", tskno);
			chg_pri(tskid, MID_PRIORITY);
			break;
		case '<':
			syslog(LOG_INFO, "#chg_pri(%d, LOW_PRIORITY)", tskno);
			chg_pri(tskid, LOW_PRIORITY);
			break;
		case 'G':
			syslog(LOG_INFO, "#get_pri(%d, &tskpri)", tskno);
			syscall(ercd = get_pri(tskid, &tskpri));
			if (ercd >= 0) {
				syslog(LOG_NOTICE, "priority of task %d is %d",
						tskno, tskpri);
			}
			break;
		case 'w':
			syslog(LOG_INFO, "#wup_tsk(%d)", tskno);
			syscall(wup_tsk(tskid));
			break;
		case 'W':
			syslog(LOG_INFO, "#can_wup(%d)", tskno);
			syscall(ercd = can_wup(tskid));
			if (ercd >= 0) {
				syslog(LOG_NOTICE, "can_wup(%d) returns %d",
						tskno, ercd);
			}
			break;
		case 'l':
			syslog(LOG_INFO, "#rel_wai(%d)", tskno);
			syscall(rel_wai(tskid));
			break;
		case 'u':
			syslog(LOG_INFO, "#sus_tsk(%d)", tskno);
			syscall(sus_tsk(tskid));
			break;
		case 'm':
			syslog(LOG_INFO, "#rsm_tsk(%d)", tskno);
			syscall(rsm_tsk(tskid));
			break;
		case 'M':
			syslog(LOG_INFO, "#frsm_tsk(%d)", tskno);
			syscall(frsm_tsk(tskid));
			break;
		case 'x':
			syslog(LOG_INFO, "#ras_tex(%d, 0x0001)", tskno);
			syscall(ras_tex(tskid, 0x0001));
			break;
		case 'X':
			syslog(LOG_INFO, "#ras_tex(%d, 0x0002)", tskno);
			syscall(ras_tex(tskid, 0x0002));
			break;
		case 'r':
			syslog(LOG_INFO, "#rot_rdq(three priorities)");
			rot_rdq(HIGH_PRIORITY);
			rot_rdq(MID_PRIORITY);
			rot_rdq(LOW_PRIORITY);
			break;
		case 'c':
			sta_cyc(CYCHDR1);
			break;
		case 'C':
			stp_cyc(CYCHDR1);
			break;
#ifndef OMIT_VGET_TIM
		case 'V':
			syscall(vxget_tim(&utime1));
			syscall(vxget_tim(&utime2));
			syslog(LOG_NOTICE, "utime1 = %d, utime2 = %d",
						(UINT) utime1, (UINT) utime2);
			break;
#endif /* OMIT_VGET_TIM */
		case 'v':
			vmsk_log(LOG_UPTO(LOG_INFO), LOG_UPTO(LOG_EMERG));
			break;
		case 'q':
			vmsk_log(LOG_UPTO(LOG_NOTICE), LOG_UPTO(LOG_EMERG));
			break;
		default:
			break;
		}
	} while (c != '\003' && c != 'Q');

	syslog(LOG_NOTICE, "Sample program ends.");
	kernel_exit();
}

