/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005,2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: task.c,v 1.12 2006/02/12 05:29:32 hiro Exp $
 */

/*
 *	⥸塼
 */

#include "jsp_kernel.h"
#include "task.h"
#include <cpu_context.h>

#ifdef __tskini

/*
 *  ¹Ծ֤Υ
 */
TCB	*runtsk;

/*
 *  ǹ̤ͥΥ
 */
TCB	*schedtsk;

/*
 *  ǥѥå㳰롼ư׵ե饰
 */
BOOL	reqflg;

/*
 *  ǥѥåľ
 */
BOOL	enadsp;

/*
 *  ǥ塼
 */
QUEUE	ready_queue[TNUM_TPRI];

/*
 *  ǥ塼ΤΥӥåȥޥå
 *
 *  ӥåȥޥåפ UINT Ƥ뤬ӥåȥޥåץؿͥ
 *  ٤16ʳʲǤ뤳ȤꤷƤ롥
 */
UINT	ready_primap;

/*
 *  ⥸塼ν
 */
void
task_initialize()
{
	UINT	i, j;
	TCB	*tcb;

	runtsk = schedtsk = NULL;
	reqflg = FALSE;
	enadsp = TRUE;

	for (i = 0; i < TNUM_TPRI; i++) {
		queue_initialize(&(ready_queue[i]));
	}
	ready_primap = 0;

	for (i = 0; i < TNUM_TSK; i++) {
		j = INDEX_TSK(torder_table[i]);
		tcb = &(tcb_table[j]);
		tcb->tinib = &(tinib_table[j]);
		tcb->actcnt = FALSE;
		make_dormant(tcb);
		if ((tcb->tinib->tskatr & TA_ACT) != 0) {
			make_active(tcb);
		}
	}
}

#endif /* __tskini */

/*
 *  ӥåȥޥåץؿ
 *
 *  bitmap  1 ΥӥåȤ⡤ǤⲼ̡ʱˤΤΤ򥵡Υ
 *  åֹ֤ӥåֹϡǲ̥ӥåȤ 0 Ȥ롥bitmap  0
 *  ꤷƤϤʤʤδؿǤϡͥ٤16ʳʲǤ뤳Ȥ
 *  ꤷbitmap β16ӥåȤΤߤ򥵡롥
 *  ӥåȥ̿ĥץåǤϡӥåȥ̿Ȥ褦
 *  ľΨɤΤ褦ʾˤϡcpu_insn.h 
 *  ӥåȥ̿Ȥä bitmap_search CPU_BITMAP_SEARCH 
 *  ޥФ褤ޤӥåȥ̿Υդʤ
 *  ͳͥ٤ȥӥåȤȤбѹˤϡPRIMAP_BIT 
 *  ޥФ褤
 *  ޤɸ饤֥ ffs ʤ顤Τ褦ɸ饤
 *  ֥ȤäΨɤǽ⤢롥
 *	#define	bitmap_search(bitmap) (ffs(bitmap) - 1)
 */
#ifndef PRIMAP_BIT
#define	PRIMAP_BIT(pri)		(1u << (pri))
#endif /* PRIMAP_BIT */

#ifndef CPU_BITMAP_SEARCH

Inline UINT
bitmap_search(UINT bitmap)
{
	static const unsigned char search_table[] = { 0, 1, 0, 2, 0, 1, 0,
						3, 0, 1, 0, 2, 0, 1, 0 };
	UINT	n = 0;

	assert((bitmap & 0xffff) != 0);
	if ((bitmap & 0x00ff) == 0) {
		bitmap >>= 8;
		n += 8;
	}
	if ((bitmap & 0x0f) == 0) {
		bitmap >>= 4;
		n += 4;
	}
	return(n + search_table[(bitmap & 0x0f) - 1]);
}

#endif /* CPU_BITMAP_SEARCH */

/*
 *  ǹ̥ͥΥ
 */
#ifdef __tsksched

TCB *
search_schedtsk()
{
	UINT	schedpri;

	schedpri = bitmap_search(ready_primap);
	return((TCB *)(ready_queue[schedpri].next));
}

#endif /* __tsksched */

/*
 *  ¹ԤǤ֤ؤΰܹ
 *
 *  ǹ̤ͥΥ򹹿Τϡ¹ԤǤ륿ʤä
 *  ȡtcb ͥ٤ǹ̤ͥΥͥ٤⤤Ǥ롥
 */
#ifdef __tskrun

BOOL
make_runnable(TCB *tcb)
{
	UINT	pri = tcb->priority;

	tcb->tstat = TS_RUNNABLE;
	LOG_TSKSTAT(tcb);
	queue_insert_prev(&(ready_queue[pri]), &(tcb->task_queue));
	ready_primap |= PRIMAP_BIT(pri);

	if (schedtsk == (TCB *) NULL || pri < schedtsk->priority) {
		schedtsk = tcb;
		return(enadsp);
	}
	return(FALSE);
}

#endif /* __tskrun */

/*
 *  ¹ԤǤ֤¾ξ֤ؤΰܹ
 *
 *  ǹ̤ͥΥ򹹿Τϡtcb ǹ̤ͥΥǤ
 *  Ǥ롥tcb Ʊͥ٤Υ¾ˤϡtcb μ
 *  ǹ̤ͥˤʤ롥Ǥʤϡǥ塼򥵡
 *  ɬפ롥
 */
#ifdef __tsknrun

BOOL
make_non_runnable(TCB *tcb)
{
	UINT	pri = tcb->priority;
	QUEUE	*queue = &(ready_queue[pri]);

	queue_delete(&(tcb->task_queue));
	if (queue_empty(queue)) {
		ready_primap &= ~PRIMAP_BIT(pri);
		if (schedtsk == tcb) {
			schedtsk = (ready_primap == 0) ? (TCB * ) NULL
						: search_schedtsk();
			return(enadsp);
		}
	}
	else {
		if (schedtsk == tcb) {
			schedtsk = (TCB *)(queue->next);
			return(enadsp);
		}
	}
	return(FALSE);
}

#endif /* __tsknrun */

/*
 *  ٻ߾֤ؤΰܹ
 */
#ifdef __tskdmt

void
make_dormant(TCB *tcb)
{
	tcb->priority = tcb->tinib->ipriority;
	tcb->tstat = TS_DORMANT;
	tcb->wupcnt = FALSE;
	tcb->enatex = FALSE;
	tcb->texptn = 0;
	create_context(tcb);
	LOG_TSKSTAT(tcb);
}

#endif /* __tskdmt */

/*
 *  ٻ߾֤¹ԤǤ֤ؤΰܹ
 */
#ifdef __tskact

BOOL
make_active(TCB *tcb)
{
	activate_context(tcb);
	return (make_runnable(tcb));
}

#endif /* __tskact */

/*
 *  ¹Ծ֤Υνλ
 */
#ifdef __tskext

void
exit_task()
{
	make_non_runnable(runtsk);
	make_dormant(runtsk);
	if (runtsk->actcnt) {
		runtsk->actcnt = FALSE;
		make_active(runtsk);
	}
	exit_and_dispatch();
}

#endif /* __tskext */

/*
 *  ǥ塼Υͥ٤ѹ
 *
 *  ǹ̤ͥΥ򹹿Τϡ(1) tcb ǹ̤ͥΥ
 *  Ǥäơͥ٤򲼤硤(2) tcb ǹ̤ͥΥ
 *  Ϥʤѹͥ٤ǹ̤ͥΥͥ٤⤤
 *  Ǥ롥(1) ξˤϡǥ塼򥵡ɬפ롥
 */
#ifdef __tskpri

BOOL
change_priority(TCB *tcb, UINT newpri)
{
	UINT	oldpri = tcb->priority;

	tcb->priority = newpri;
	queue_delete(&(tcb->task_queue));
	if (queue_empty(&(ready_queue[oldpri]))) {
		ready_primap &= ~PRIMAP_BIT(oldpri);
	}
	queue_insert_prev(&(ready_queue[newpri]), &(tcb->task_queue));
	ready_primap |= PRIMAP_BIT(newpri);

	if (schedtsk == tcb) {
		if (newpri >= oldpri) {
			schedtsk = search_schedtsk();
			return(schedtsk != tcb && enadsp);
		}
	}
	else {
		if (newpri < schedtsk->priority) {
			schedtsk = tcb;
			return(enadsp);
		}
	}
	return(FALSE);
}

#endif /* __tskpri */

/*
 *  ǥ塼βž
 *
 *  ǹ̤ͥΥ򹹿Τϡǹ̤ͥΥ
 *  塼˰ưǤ롥
 */
#ifdef __tskrot

BOOL
rotate_ready_queue(UINT pri)
{
	QUEUE	*queue = &(ready_queue[pri]);
	QUEUE	*entry;

	if (!(queue_empty(queue)) && queue->next->next != queue) {
		entry = queue_delete_next(queue);
		queue_insert_prev(queue, entry);
		if (schedtsk == (TCB *) entry) {
			schedtsk = (TCB *)(queue->next);
			return(enadsp);
		}
	}
	return(FALSE);
}

#endif /* __tskrot */

/*
 *  ޤ㳰롼η
 */
typedef void	(*TEXRTN)(TEXPTN texptn, VP_INT exinf);

/*
 *  㳰롼θƽФ
 */
#ifdef __tsktex

void
call_texrtn()
{
	TEXPTN	texptn;

	do {
		texptn = runtsk->texptn;
		runtsk->enatex = FALSE;
		runtsk->texptn = 0;
		t_unlock_cpu();
		LOG_TEX_ENTER(texptn);
		(*((TEXRTN)(runtsk->tinib->texrtn)))(texptn,
						runtsk->tinib->exinf);
		LOG_TEX_LEAVE(texptn);
		if (!t_sense_lock()) {
			t_lock_cpu();
		}
	} while (runtsk->texptn != 0);
	runtsk->enatex = TRUE;
}

/*
 *  㳰롼εư
 */
#ifndef OMIT_CALLTEX

void
calltex()
{
	if (runtsk->enatex && runtsk->texptn != 0) {
		call_texrtn();
	}
}

#endif /* OMIT_CALLTEX */
#endif /* __tsktex */
