/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: eventflag.h,v 1.5 2003/06/04 01:46:16 hiro Exp $
 */

/*
 *	٥ȥե饰ǽ
 */

#ifndef _EVENTFLAG_H_
#define _EVENTFLAG_H_

#include "queue.h"

/*
 *  ٥ȥե饰֥å
 */
typedef struct eventflag_initialization_block {
	ATR	flgatr;		/* ٥ȥե饰° */
	FLGPTN	iflgptn;	/* ٥ȥե饰Υӥåȥѥν */
} FLGINIB;

/*
 *  ٥ȥե饰֥å
 */
typedef struct eventflag_control_block {
	QUEUE	wait_queue;	/* ٥ȥե饰Ԥ塼 */
	const FLGINIB *flginib;	/* ٥ȥե饰֥åؤΥݥ */
	FLGPTN	flgptn;		/* ٥ȥե饰ߥѥ */
} FLGCB;

/*
 *  ٥ȥե饰ǽν
 */
extern void	eventflag_initialize(void);

/*
 *  ٥ȥե饰ԤΥå
 */
extern BOOL	eventflag_cond(FLGCB *flgcb, FLGPTN waiptn,
					MODE wfmode, FLGPTN *p_flgptn);

#endif /* _EVENTFLAG_H_ */
