/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005,2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: t_services.h,v 1.7 2006/01/13 00:34:58 hiro Exp $
 */

/*
 *	ץꥱ ɸ।󥯥롼ɥե
 *
 *  Υ󥯥롼ɥեϡͥưץΥ
 *  եǥ󥯥롼ɤɸ।󥯥롼ɥեǤ롥ǡ
 *  kernel.hʤˤ顤t_stddef.hitron.htool_defs.h
 *  sys_defs.hcpu_defs.ht_syslog.hˤserial.h򥤥󥯥롼ɤƤ
 *  롥ޤץꥱͭפȻפ򤤤ĤޤǤ롥
 *
 *  ֥Υե䥷ƥॳե졼ե
 *  뤫餳Υե򥤥󥯥롼ɤϡ_MACRO_ONLY 
 *  ȤǡޥʳεҤȤǤ롥
 */

#ifndef _T_SERVICES_H_
#define _T_SERVICES_H_

#ifdef __cplusplus
extern "C" {
#endif

/*
 *  ͥƤӽФɬפʥ󥯥롼ɥե
 */
#include <kernel.h>

#ifndef _MACRO_ONLY

/*
 *  ꥢ륤󥿥ե⥸塼
 */
#include <serial.h>

/*
 *  ͥνλ
 */
extern void	kernel_exit(void) throw();

/*
 *  syscallޥ_syscall ޥ
 */

extern void	t_perror(UINT prio, const char *file, int line,
					const char *expr, ER ercd) throw();

Inline ER
_t_perror(const char *file, int line, const char *expr, ER ercd)
{
	if (ercd < 0) {
		t_perror(LOG_ERROR, file, line, expr, ercd);
	}
	return(ercd);
}

Inline ER
_t_panic(const char *file, int line, const char *expr, ER ercd)
{
	if (ercd < 0) {
		t_perror(LOG_EMERG, file, line, expr, ercd);
		kernel_abort();
	}
	return(ercd);
}

#define syscall(s)	_t_perror(__FILE__, __LINE__, #s, (s))
#define _syscall(s)	_t_panic(__FILE__, __LINE__, #s, (s))

#endif /* _MACRO_ONLY */

#ifdef __cplusplus
}
#endif

#endif /* _T_SERVICES_H_ */
