/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2005 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 */

/*
 *  ޥɥ饤СXstormy16ѡ
 */

#include <kernel.h>
#include <s_services.h>
#include <hw_timer.h>
#include <cpu_sfrs.h>

/*
 *  ޤεư
 *
 *  ޤŪʥ޳׵ȯ롥
 */
void hw_timer_initialize(void)
{
                                /*
                                 *  ƥå
                                 */
    _kernel_tic_nume = 5u ;
                                /*
                                 *  ¡RCȯѤ5msγߤȯ
                                 */
    __SFR_BITCLR( __OCR0, 4 ) ;         /* start internal-RC                 */
    __SFRW(__T0LR) = 5000-1 ;           /* Internl-RC is almost 1MHz,        */
                                        /*  so set 5000-1 for 5ms            */
    __SFR(__T0PR) = 0 ;                 /* Prescaler = 1/1                   */
    __SFR(__T0CNT) = 0x0d ;             /* Select internal-RC,               */
                                        /*  start timer and enable interrupt */
                                /*
                                 *  ǥեȤΥޡߥϥɥϿ
                                 */
    _kernel_define_inh( INHNO_TIMER, hw_timer_handler ) ;
                                /*
                                 *  ޡߤLevel1
                                 */
    __SFR_BITCLR( __IL1L, 5 ) ;
    __SFR_BITSET( __IL1L, 4 ) ;
}

/*
 *  ޳׵Υꥢ
 */
void hw_timer_int_clear(void)
{
    __SFR_BITCLR( __T0CNT, 1 ) ;
}

/*
 *  ޤ߽
 */
void hw_timer_terminate(void)
{
                                /*
                                 *  ޤưߤ롥
                                 */
    __SFR(__T0CNT) = 0x00 ;
                                /*
                                 *  ޡߤػ
                                 */
    __SFR_BITCLR( __IL1L, 5 ) ;
    __SFR_BITCLR( __IL1L, 4 ) ;
}

/*
 *  ǥեȤΥ޳ߥϥɥ
 */
void hw_timer_handler( void )
{
                                /*
                                 *  ޳׵Υꥢ
                                 */
    hw_timer_int_clear() ;
                                /*
                                 *  ƥåζ
                                 */
    isig_tim();
}

