/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: eventlog.h,v 1.7 2003/12/15 07:19:22 takayuki Exp $
 */


#ifndef __EVENTLOG_H__
#define __EVENTLOG_H__

#include <constants.h>

#include <stdarg.h>
#include "syslog.h"

	/*
	 *  ITRONǥХå󥰥󥿥եϢ
	 */

	/*
	 *  ǥѥå
	 */
#define DSP_NORMAL		0;	//ƥȤΥǥѥå
#define DSP_NONTSKCTX	1;	//߽CPU㳰Υǥѥå 

	typedef	W		BITMASK;
	typedef UINT	INHNO;

	/* ߥϥɥ */
	typedef struct t_rglog_interrupt{
		INHNO	inhno;	//ߥϥɥֹ
	} T_RGLOG_INTERRUPT;

	/* ߥӥϥɥ(̤) */
	typedef struct t_rglog_isr {
		ID		isrid;	//ߥӥ롼ID
		INHNO	inhno;	//ߥϥɥֹ
	} T_RGLOG_ISR;

	/* ।٥ȥϥɥ */
	typedef struct t_rglog_timerhdr {
		UINT	type;	//ޡμ
		ID		hdrid;	//।٥ȥϥɥID
		VP_INT	exinf;	//ĥ
	} T_RGLOG_TIMERHDR;

	/* CPU㳰ϥɥ */
	typedef struct t_rglog_cupexc {
		ID		tskid;	//оݤȤʤ륿ID
	} T_RGLOG_CPUEXC;

	/* 㳰롼 */
	typedef struct t_rglog_tskexc {
		ID		tskid;	//оݤȤʤ륿ID
	} T_RGLOG_TSKEXC;

	/* Ѳ */
	typedef struct t_rglog_tskstat {
		ID		tskid;		//ID
		STAT	tskstat;	//西
		STAT	tskwait;	//Ԥ
		ID		wobjid;		//ԤоݤΥ֥ID
	} T_RGLOG_TSKSTAT;

	/* ǥѥå㳫 */
	typedef struct t_rglog_dispatch_enter {
		ID		tskid;		//ID
		UINT	disptype;	//ǥѥå
	} T_RGLOG_DISPATCH_ENTER;

	/* ǥѥå㽪λ */
	typedef struct t_rglog_dispatch_leave {
		ID		tskid;		//ID
	} T_RGLOG_DISPATCH_LEAVE;

	/* ӥ */
	typedef struct t_rglog_svc {
		FN		fncno;		//ǽ
		UINT	prmcnt;		//ѥ᡼
		VP_INT	prmary[1];	//ѥ᡼
	} T_RGLOG_SVC;

	/* ȡʸΤߤΥ */
	typedef struct t_rglog_comment {
		UINT	length;		//ʸĹ
		char	strtext[1];	//ʸ(NULLü)-Ǥ
	} T_RGLOG_COMMENT;

	typedef struct t_rglog_header {
		UINT	logtype;
		SYSTIM	logtim;
		BITMASK	valid;
		UINT	bufsz;
	} T_RGLOG_HEADER;

	typedef union t_rglog_body
	{
		T_RGLOG_INTERRUPT		interrupt;
		T_RGLOG_ISR				isr;
		T_RGLOG_TIMERHDR		timerhdr;
		T_RGLOG_CPUEXC			cpuexc;
		T_RGLOG_TSKEXC			tskexc;
		T_RGLOG_TSKSTAT			tskstat;
		T_RGLOG_DISPATCH_ENTER	dispatch_enter;
		T_RGLOG_DISPATCH_LEAVE	dispatch_leave;
		T_RGLOG_SVC				svc;
		T_RGLOG_COMMENT			comment;
	} T_RGLOG_BODY;

	typedef struct DBIFLOG
	{
		struct	t_rglog_header	header;
		union	t_rglog_body	body;
	} DBIFLOG;

	typedef struct t_rglog
	{
		UINT	logtype;
		SYSTIM	logtim;
		BITMASK	valid;
		UINT	bufsz;
		char	buf[1];
	} T_RGLOG;

#ifdef EVENTLOG_ENABLE
#ifdef __cplusplus
#define EXTERN extern "C"
#else
#define EXTERN extern
#endif

		EXTERN void event_write_syslog(const SYSLOG * str);
		EXTERN void event_write(unsigned int logtype, unsigned int valid, UINT bufsz, ... );
		EXTERN void event_write_svc_enter(int fncd, unsigned int params, ... );
		EXTERN void event_write_svc_leave(int fncd, unsigned int ercd, unsigned int retaddr);
		EXTERN void event_write_wait_unknown(int tskid);

#undef EXTERN

#endif //EVENTLOG_ENABLE

#endif //__EVENTLOG_H__

