/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_defs.c,v 1.14 2003/12/15 07:19:22 takayuki Exp $
 */

#define _WIN32_WINNT 0x400

#include <s_services.h>
#include <hal_msg.h>

/*
 * m68käݤߥߥ졼 (Windows HAL)
 */

	/* ߤγߥޥ٥ */
unsigned int CurrentInterruptLevel;

	/* ߴơ֥ */
static struct tagInterruptLevel InterruptLevel[INT_NUMINTERRUPTS];

	/* ߥޥ٥ͭϰϥå */
#define CHECK_IMS(x) ( (x) != 0 && (x) <= INT_NUMINTERRUPTS )

	/* 㳰ơ֥ */
struct tagExceptionLevel ExceptionLevel[EXC_MAXITEMS];

	/* ʬϿƤ¤㳰ϥɥΥɥ쥹 */
static LPTOP_LEVEL_EXCEPTION_FILTER AnotherExceptionFilter;

/*
 *   ƥΤΥƥ륻롼
 *     ɤCRITICAL_SECTIONȤΤ᤿Τ
 *        -> WindowsΥƥ륻ϡITRONǸȤΥǥѥåػߤǼƤ餷
 *           ٥ȤǵƤޤäåɤƥ륻ˤ륹åɤư
 *           ߤƤޤȤǤ餷ʤΤCPUåΤĤǥƥ륻ȤäƤȡ
 *           ¤ϤΥǥѥåػߤʤΤǥϥɥ餬ưƤޤPrimaryThreadSuspendThreadȯԤƥǥåɥåƤޤ
 *           ϻȯäޤʤȤȤϻפʤä
 *           WinProgϤMLǤָƱʤ饯ƥ륻ϻȤʤۤ褤פȤäƤ롣
 */

static HANDLE SystemMutex = NULL;		                //ƥåѤΥߥ塼ƥå֥
static DWORD  SystemMutexOwnerThreadID = 0;				//ƥååɤID
static DWORD  SystemMutexLastOwnerThreadID = 0;			//Ǹ˥ƥåƤåɤID (ǥХå)

	/*
	 *   enter_system_critical_section : ƥΥå
	 *     BOOL * lock : å(ʬϤƥåTRUE֤)
	 */
void enter_system_critical_section(BOOL * lock)
{
	if(SystemMutex != NULL && SystemMutexOwnerThreadID != GetCurrentThreadId())
	{
		WaitForSingleObject(SystemMutex, INFINITE);	
		if(lock != NULL)
			*lock = TRUE;
		SystemMutexOwnerThreadID = GetCurrentThreadId();
	}else
	{
		if(lock != NULL)
			*lock = FALSE;
	}
}

	/*
	 *   leave_system_critical_section : ƥΥå
	 *		BOOL * lock : enter_system_critical_sectionǻѤå
	 */
void leave_system_critiacl_section(BOOL * lock)
{
	assert(lock != NULL);

	if(*lock == TRUE)
	{
		SystemMutexLastOwnerThreadID = SystemMutexOwnerThreadID;
		SystemMutexOwnerThreadID = 0;
		if(SystemMutex != NULL)
			ReleaseMutex(SystemMutex);	
	}
}

	/*
	 *   wait_for_thread_suspension_completion : åɤå֤ߤ 
	 */
ER wait_for_thread_suspension_completion(HANDLE thread)
{
	BOOL lock;

	if(thread == 0 || thread == NULL)
		return E_PAR;

	enter_system_critical_section(&lock);
	SuspendThread(thread);
	leave_system_critiacl_section(&lock);

	return 0;
}



/*
 *  ˼¹Ԥ٤ߥϥɥΤ٥
 *      ipl : ߥޥ٥
 *
 *    ߥ٥ޥiplޤǲäȤˡư٤ߤ򤹤롣
 *    ޥ٥̤γߤξ硢ڥǥ󥰤줿׵ or ˼¹Ԥ
 *    ϤޤäƤϥɥ ¹Ԥ롣ޥ٥ʲξ硢ưƤ
 *    ϥɥ餬Τ߼¹Ԥ롣ʤ0֤
 */
static unsigned int
isns_int( unsigned int ipl )
{
	unsigned int result = INT_NUMINTERRUPTS;
	
	if((CPUStatus & CPU_STAT_LOCK) != 0)
		return 0;

	while(result > ipl)
	{
		result --;
		if( (InterruptLevel[result].Flags & (INT_STAT_PENDING|INT_STAT_RUNNING)) != 0)
			return result+1;
	}
	while(result > 0)
	{
		result --;
		if( (InterruptLevel[result].Flags & INT_STAT_RUNNING) != 0)
			return result+1;
	}
	return 0;
}

static DWORD WINAPI
InterruptHandlerWrapper(LPVOID param)
{
	unsigned int   i;
	unsigned int   PrevLevel;
	BOOL           systemLock;

	struct tagInterruptLevel * intlv = (struct tagInterruptLevel *)param;

	TlsAlloc();

    kprintf(("InterruptHandlerWrapper (%d) : start\n", (intlv - InterruptLevel) + 1 ));

	while(1==1)
	{
			/*  */

		set_logcontrol((intlv->Flags & INT_MOD_LOGMASK) != 0);
		LOG_INH_ENTER((intlv - InterruptLevel)+1);

        assert((CPUStatus & CPU_STAT_LOCK) == 0);
        enter_system_critical_section(&systemLock);
        PrevLevel = CurrentInterruptLevel;
		CurrentInterruptLevel = (unsigned int)(intlv - InterruptLevel)+1;
		intlv->Flags &= ~INT_STAT_PENDING;
		intlv->Flags |=  INT_STAT_RUNNING;
		leave_system_critiacl_section(&systemLock);

        ( (void (*)(void) )(intlv->Routine))();
        
			/* ߸ 
             *    ǰ쵤PrevLevelޤȤƤϤʤ.
             *    ߤˤäƤϡͥ٤㤤ߤæнͥ٤ι⤤ߤοľ˼¹Ԥ졢
             *    ͥ٤ι⤤ߤCurrentInterruptLevel = 0ξ֤äƤޤȤˤʤ롣
             */
		enter_system_critical_section(&systemLock);
		intlv->Flags &= ~INT_STAT_RUNNING;
		i = isns_int(PrevLevel);
		if(i > PrevLevel)
			CurrentInterruptLevel = i - 1;
		else
			CurrentInterruptLevel = PrevLevel;
		leave_system_critiacl_section(&systemLock);

		LOG_INH_LEAVE((intlv - InterruptLevel)+1);

            /* γߤ褦 */
	    HALInterruptRequestAndWait();
	}

    kprintf(("InterruptHandlerWrapper (%d) : exit\n", (intlv - InterruptLevel) + 1 ));

    ExitThread(0);
	return 0;
}

BOOL
def_int(unsigned int ims, void * rtn)
{
	BOOL lock;

	if(!CHECK_IMS(ims) || rtn == NULL)
		return FALSE;

    kprintf(("def_int : [ims:%d]\n", ims));

	ims--;

	enter_system_critical_section(&lock);
	if(InterruptLevel[ims].ThreadHandle != NULL)
	{
		TerminateThread(InterruptLevel[ims].ThreadHandle,0);
		CloseHandle(InterruptLevel[ims].ThreadHandle);
	}
	InterruptLevel[ims].Routine = rtn;
	InterruptLevel[ims].ThreadHandle = CreateThread(NULL,0,InterruptHandlerWrapper,(LPVOID)&InterruptLevel[ims],CREATE_SUSPENDED,&InterruptLevel[ims].ThreadID);
	leave_system_critiacl_section(&lock);

	return TRUE;
}

BOOL
ini_int(void)
{
	int i;

    kprintf(("ini_int : [Start]\n"));

    SystemMutex = CreateMutex(NULL,TRUE,NULL);

	for(i=0;i<INT_NUMINTERRUPTS;i++)
	{
		InterruptLevel[i].Routine      = (void *)0l;
		InterruptLevel[i].ThreadHandle = NULL;
		InterruptLevel[i].ThreadID     = 0;
		InterruptLevel[i].Flags        = INT_MOD_LOGMASK;
	}

		/* ưCPUå֤ذܹԤ */
	CurrentInterruptLevel = 0;	//ߥޥ
	CPUStatus |= CPU_STAT_LOCK;	//CPUǳ߶ػߤ

	ReleaseMutex(SystemMutex);

    kprintf(("ini_int : [Exit]\n"));

	return TRUE;
}

void
fin_int(void)
{
	int    i;
	HANDLE work;

    kprintf(("fin_int : [Start]\n"));

	enter_system_critical_section(NULL);

	for(i=0;i<INT_NUMINTERRUPTS;i++)
	{
		if(InterruptLevel[i].ThreadHandle != NULL)
		{
			TerminateThread(InterruptLevel[i].ThreadHandle,0);
			CloseHandle(InterruptLevel[i].ThreadHandle);
		}
		InterruptLevel[i].Routine = (void *)0l;
		InterruptLevel[i].ThreadHandle = NULL;
		InterruptLevel[i].ThreadID = 0;
		InterruptLevel[i].Flags    = 0;
	}
	CurrentInterruptLevel = 0;

        /* CloseHandle(SystemMutex), SystemMutex = INVALID_HANDLE; ˤ */
	work = SystemMutex;
	SystemMutex = NULL;
	CloseHandle(work);

		//ʹߤCPUå֤Ȼפ
	CPUStatus |= CPU_STAT_LOCK;

    kprintf(("fin_int : [Exit]\n"));
}

BOOL
ras_int(unsigned int ims)
{
	BOOL lock;
	BOOL result = TRUE;

	if(!CHECK_IMS(ims))
		return FALSE;

	ims --;

	enter_system_critical_section(&lock);
	if(InterruptLevel[ims].ThreadHandle == NULL)
	{
		result = FALSE;
	}else
		InterruptLevel[ims].Flags |= INT_STAT_PENDING;
	leave_system_critiacl_section(&lock);
	return result;
}

unsigned int
sns_int( void )
{
	BOOL lock;
	int  result;

	if(sense_lock() == TRUE)
		return 0;

	enter_system_critical_section(&lock);
	result = isns_int(CurrentInterruptLevel);
	leave_system_critiacl_section(&lock);
	return result;
}

HANDLE
sch_int( void )
{
	BOOL   lock;
	HANDLE result;
	unsigned int level;

	if(sense_lock() == TRUE)
		return NULL;

	enter_system_critical_section(&lock);
	level = isns_int(CurrentInterruptLevel);
	if(level != 0)
	{
		result = InterruptLevel[level-1].ThreadHandle;
	}else
		result = NULL;
	leave_system_critiacl_section(&lock);

	return result;
}

DWORD LockerThreadID = 0;

ER
ena_int(unsigned int ims)
{
	BOOL lock;
	int  i;

	enter_system_critical_section(&lock);
	i = isns_int(CurrentInterruptLevel);
	CPUStatus &= ~CPU_STAT_LOCK;
	LockerThreadID = 0;
	leave_system_critiacl_section(&lock);

	if(i != 0)
		HALInterruptRequest(0);

	return 0 /*E_OK*/;
}

ER
dis_int(unsigned int ims)
{
	BOOL lock;

	enter_system_critical_section(&lock);
	CPUStatus |= CPU_STAT_LOCK;
	if(LockerThreadID == 0)
	{
		LockerThreadID = GetCurrentThreadId();
	}else
	{
		DWORD newThreadID = GetCurrentThreadId();
		LockerThreadID = GetCurrentThreadId();	//֥졼֤
	}
	leave_system_critiacl_section(&lock);

	return 0;
}

ER
chg_ims(unsigned int ims)
{
	BOOL lock;
	int  i;

		//chg_ims  ims==0 
	if(ims != 0 && !CHECK_IMS(ims))
		return -17 /*E_PAR*/;

	enter_system_critical_section(&lock);
	CurrentInterruptLevel = ims;
	if(CurrentInterruptLevel == INT_NUMINTERRUPTS)
		CPUStatus |= CPU_STAT_LOCK;
	else
		CPUStatus &= ~CPU_STAT_LOCK;
	i = isns_int(ims);
	leave_system_critiacl_section(&lock);

	if(i != 0)
		HALInterruptRequest(0);

	return 0 /*E_OK*/;
}

ER
get_ims(unsigned int *p_ims)
{
	BOOL lock;

	if(p_ims == (void *)0l)
		return -17 /*E_PAR*/;

	enter_system_critical_section(&lock);
	if((CPUStatus & CPU_STAT_LOCK) != 0)
		*p_ims = INT_NUMINTERRUPTS;
	else
		*p_ims = CurrentInterruptLevel;
	leave_system_critiacl_section(&lock);
	return 0 /*E_OK*/;
}

ER
vget_ims(unsigned int *p_ims)
{
	BOOL lock;

	if(p_ims == (void *)0l)
		return -17 /*E_PAR*/;

	enter_system_critical_section(&lock);
	*p_ims = CurrentInterruptLevel;
	leave_system_critiacl_section(&lock);
	return 0 /*E_OK*/;
}

/*
 * Ǿ̥٥Windows¤㳰ϥɥ
 */

LONG WINAPI
HALExceptionHandler( EXCEPTION_POINTERS * exc )
{
	int i;
	int result;

	if((CPUStatus & CPU_STAT_EXC) == 0)
		CPUStatus |= CPU_STAT_DOUBLEFAULT;

        /* ϼ (֤ޤ...) */
	CPUStatus |= CPU_STAT_EXC;
	for(i=0;i<EXC_MAXITEMS;i++)
	{
		if(ExceptionLevel[i].ExceptionCode == exc->ExceptionRecord->ExceptionCode)
		{
			result = EXCEPTION_CONTINUE_SEARCH;
	
			LOG_EXC_ENTER(i);
			( * ((void (*)(void *,int *))ExceptionLevel[i].Routine)) (exc,&i);
			LOG_EXC_LEAVE(i);

			CPUStatus &= ~CPU_STAT_EXC;
			return result;
		}
	}
	CPUStatus &= ~CPU_STAT_EXC;
	return EXCEPTION_CONTINUE_SEARCH;
}

BOOL
ini_exc(void)
{
	int i;

	for(i=0;i<EXC_MAXITEMS;i++)
	{
		ExceptionLevel[i].ExceptionCode = 0;
		ExceptionLevel[i].Routine = 0l;
	}

	AnotherExceptionFilter = SetUnhandledExceptionFilter(HALExceptionHandler);
	
	return TRUE;
}

void
fin_exc(void)
{
    SetUnhandledExceptionFilter(AnotherExceptionFilter);
}

BOOL
def_exc(DWORD exc, void * routine)
{
	int j;
	int i;

        /* 롼 */
	if(routine == 0l)
	{
        kprintf(("def_exc : [UNREG] 0x%08x\n", exc));

		for(i=0;i<EXC_MAXITEMS;i++)
			if(ExceptionLevel[i].ExceptionCode == exc)
			{
				ExceptionLevel[i].ExceptionCode = 0;
				ExceptionLevel[i].Routine = 0;
				return TRUE;
			}
		return FALSE;
	}

    /* Ͽ롼 */

    kprintf(("def_exc : [REG] 0x%08x\n", exc));

	j = EXC_MAXITEMS;
	for(i=0;i<EXC_MAXITEMS;i++)
	{
		if(ExceptionLevel[i].ExceptionCode != 0)
		{
				/* Ͽ褦ȤƤֹ椬ϿƤʤɤĴ٤ */
			if(ExceptionLevel[i].ExceptionCode == exc)
				return FALSE;
		}else
		{
				/* ֹκǾФ */
			if(j > i)
				j = i;

            /* ϿåΤǡbreakƤϥ */
		}
	}

	FatalAssertion(i == EXC_MAXITEMS, "No available exception slots left.");

		//This sequence will never change
	ExceptionLevel[j].Routine       = routine;
	ExceptionLevel[j].ExceptionCode = exc;

	return TRUE;
}

ER set_intlogmask( unsigned int ims, BOOL mask )
{
	BOOL lock;

	if( !CHECK_IMS(ims) )
		return FALSE;

	-- ims;

	enter_system_critical_section(&lock);
	if(mask == TRUE)
		InterruptLevel[ims].Flags |= INT_MOD_LOGMASK;
	else
		InterruptLevel[ims].Flags &= ~INT_MOD_LOGMASK;
	leave_system_critiacl_section(&lock);

	return TRUE;
}

unsigned int current_timer_clock_unit = TIMER_CLOCK_WINDOWS;

ER set_clk(unsigned int clk)
{
    BOOL lock;

    if(clk == 0)
        clk = TIMER_CLOCK_WINDOWS;

    hw_timer_terminate();
    enter_system_critical_section(&lock);
    current_timer_clock_unit = clk;
    leave_system_critiacl_section(&lock);
    hw_timer_initialize();

    return E_OK;
}
