/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_config.c,v 1.15 2003/12/15 07:19:22 takayuki Exp $
 */


/*
 *	ץå¸⥸塼Windowsѡ
 */
#include <cpu_rename.h>

#include <s_services.h>

#include "jsp_kernel.h"
#include "check.h"
#include "task.h"

#include <hal_msg.h>

volatile char CPUStatus = CPU_STAT_LOCK;	//CPU֥ե饰

/*
 *  ǥѥå
 *    ǥѥåΤprimary_thread.cˤ
 *    Ǥϴåɤ˥ǥѥåФ
 */
void
dispatch()
{
	LOG_DSP_ENTER_TSK(runtsk);
	HALDispatchRequest();	
}

/* ѥǥѥå (ϤΤߤۤʤ) */
void
idispatch()
{
	LOG_DSP_ENTER_INT(runtsk);
	HALDispatchRequest();
}


/*
 *  ߤΥƥȤΤƤƥǥѥå
 *    exit_and_dispatch ϡCPUå֤ǸƤӽФʤФʤʤ
 *
 *    ߼¹ΥTCBꤷ˴ꡣ˴弫ưŪ˥ǥѥåء
 */
void
exit_and_dispatch() 
{
    HANDLE handle;

	HALDestroyRequest(runtsk);

    if((handle = (HANDLE)TlsGetValue(TLS_THREADHANDLE)) != NULL)
        CloseHandle(handle);

    TlsFree(TLS_THREADHANDLE);
    TlsFree(TLS_LOGMASK);

	ExitThread(0);
}


/*
 *  ץå¸ν
 */

void
cpu_initialize()
{
    kprintf(("cpu_initialize()\n"));

	/*
	 *  ߥߥ졼ν
	 */
	ini_int();

	/*
	 * Ǿ̹¤㳰ϥɥ
	 */
	ini_exc();
}

/*
 *  ץå¸νλ
 */
void
cpu_terminate()
{
    kprintf(("cpu_terminate()\n"));

    fin_int();  //ߥߥ졼
	fin_exc();  //Ǿ̹¤㳰ϥɥβ
}


/*
 * ư롼
 *
 */

DWORD WINAPI
activate_r( LPVOID param)
{
	TCB * tcb = (TCB *)param;

	TlsAlloc();
	TlsSetValue(TLS_LOGMASK, 0);
    TlsSetValue(TLS_THREADHANDLE, tcb->tskctxb.ThreadHandle);

    kprintf(("Task %d : activated\n", (tcb - tcb_table) + 1));

	(*(void(*)(VP_INT))tcb->tinib->task)(tcb->tinib->exinf);
	ext_tsk();
	return 0;
}

/*
 *  atexitϿ줿ؿɽФ (Windowsϲ⤷ʤ -> CRTǤ)
 */
void call_atexit(void)
{}


/*
 *   ̿ŪʼԤФн롼
 */
void FatalAssertion(int exp, LPCSTR format, ...)
{
	extern HANDLE PrimaryThreadHandle;
	extern HANDLE CurrentRunningThreadHandle;

	if(!exp)
	{
		va_list vl;
		char    buffer[1024];

			/* 顼ͤߤ */
		wsprintf(buffer, "Critical assertion fail occured !!\nGetLastError = 0x%08x\n\n", GetLastError());

			/* ͥ뤬ưФƤ... */		
		if(PrimaryThreadHandle != NULL)
		{
				/* ͥμ¹Ԥߤ */
			dis_int(0);
			if(CurrentRunningThreadHandle != NULL)
				SuspendThread(CurrentRunningThreadHandle);
			hw_timer_terminate();
		}

			/* ٹɽ */
		va_start(vl, format);
		wvsprintf(buffer + lstrlen(buffer), format, vl);
		MessageBox(PrimaryDialogHandle, buffer, "Assertion Failed", MB_OK|MB_ICONERROR);

			/* ͥ */
		HALQuitRequest();
	}
}

	/*
	 *   Ϥɤ뤫
	 */
void set_logcontrol(BOOL enable)
{
	BOOL result;
	result = TlsSetValue(TLS_LOGMASK, (LPVOID)(enable == TRUE ? 0 : 1));
	if(result == 0)
	{
		TlsAlloc();
		TlsSetValue(TLS_LOGMASK, (LPVOID)(enable == TRUE ? 0 : 1));
	}
}

    /*
     *   ͥΥǥХåprintf
     */
void _kernel_debugprintf(const char * format, ... )
{
    va_list vl;
    int     words;
    DWORD   count;
    char    buffer[1024];

    va_start(vl, format);
    words = wvsprintf(buffer, format, vl);

    if(words != 0)
        WriteFile(GetStdHandle(STD_OUTPUT_HANDLE), buffer, words, &count, NULL);
}

#ifdef _MSC_VER     //cygwinξcpu_insn.S˵

 /*
  * 㳰ư롼
  *   ƥȤפ뤿ᡢ
  *   㳰ưΥåɾư뤿Υ롼
  */
void __declspec(naked) TaskExceptionPerformer(void)
{
		/* 쥸 */
	__asm	pusha
	__asm	sub		esp, FPU_CONTEXTSIZE
	__asm	fsave	[esp]

		/* 㳰εư */
	__asm	call	call_texrtn

		/* ߥޥᤷ */
	__asm	mov		ebx, DWORD PTR runtsk
	__asm	mov		eax, [ebx]TCB.tskctxb.InterruptLevel
	__asm	push	eax
	__asm	call	chg_ims
	__asm	add		esp, 4

		/* 쥸 */
	__asm	finit
	__asm	frstor	[esp]
	__asm	add		esp, FPU_CONTEXTSIZE
	__asm	popa
	__asm	ret
}

#endif

