/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2002 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  Copyright (C) 2005 by Freelines CO.,Ltd
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_support.S,v 1.10 2007/01/05 02:10:17 honda Exp $
 */

/*
 *	ץå¸⥸塼 ֥V850ESѡ
 */

#define	_MACRO_ONLY
#include "v850asm.inc"
#include "jsp_kernel.h"
#include "offset.h"

/*
 *  ǥѥå
 */
Function	__kernel_dispatch

	/*
	 * ƥȤ 
	 */
	Push	ep
	addi	-120, sp, sp
	mov	sp, ep
	sst.w	r1, 116[ep]
	sst.w	r2, 112[ep]
	sst.w	r3, 108[ep]
	sst.w	r4, 104[ep]
	sst.w	r5, 100[ep]
	sst.w	r6,  96[ep]
	sst.w	r7,  92[ep]
	sst.w	r8,  88[ep]
	sst.w	r9,  84[ep]
	sst.w	r10, 80[ep]
	sst.w	r11, 76[ep]
	sst.w	r12, 72[ep]
	sst.w	r13, 68[ep]
	sst.w	r14, 64[ep]
	sst.w	r15, 60[ep]
	sst.w	r16, 56[ep]
	sst.w	r17, 52[ep]
	sst.w	r18, 48[ep]
	sst.w	r19, 44[ep]
	sst.w	r20, 40[ep]
	sst.w	r21, 36[ep]
	sst.w	r22, 32[ep]
	sst.w	r23, 28[ep]
	sst.w	r24, 24[ep]
	sst.w	r25, 20[ep]
	sst.w	r26, 16[ep]
	sst.w	r27, 12[ep]
	sst.w	r28,  8[ep]
	sst.w	r29,  4[ep]
	sst.w	r31,  0[ep]

	/* åȼεưϤ¸ */
	Lea	__kernel_runtsk, ep
	sld.w	0[ep], ep
	sst.w	sp, TCB_sp[ep]
	Lea	dispatch_r, r10
	sst.w	r10, TCB_pc[ep]
	stsr	psw, r10
	sst.w	r10, TCB_psw[ep]

	/*
	 * Υν __kernel_dispatch_1
	 *  ϳ߶ػ߾֤ɬפ롣
	 */
Label	__kernel_dispatch_1
	/* runtsk = schedtsk */
	Lea	__kernel_schedtsk, r10
	ld.w	0[r10], r10
	Lea	__kernel_runtsk, r11
	st.w	r10, 0[r11]
	cmp	r10,r0
	bne	1f

	/*
	 * ư٤Ϥʤ...ɥ롼
	 */

	/* ߥåڤؤ */
	Lea	STACKTOP, sp
	/* intnest򣱤ˤ */
	mov	r0, r10
	add	1, r10
	Lea	_intnest, r11
	st.w	r10, 0[r11]

	/* Ԥ */
	ei
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	di

	/* intnest򥯥ꥢ */
	Lea	_intnest, r10
	st.w	r0, 0[r10]

	br	__kernel_dispatch_1

1:
	/* åȼεưϤ */
	mov	r10, ep
	sld.w	TCB_pc[ep], r31
	sld.w	TCB_sp[ep], sp
	sld.w	TCB_psw[ep], r10
	ldsr	r10, psw
	jmp	r31

	/* ǥѥå롼 */
Label	dispatch_r
	Lea	__kernel_runtsk, r10
	ld.w	0[r10], r10
	ld.w	TCB_enatex[r10], r11
	tst1	TCB_enatex_bit, 0[r11]
	be	1f
	ld.w	TCB_texptn[r10], r11
	cmp	r0, r11
	be	1f

	/* 㳰 */
	jarl	__kernel_calltex, r31
1:
	mov	sp, ep
	sld.w	116[ep], r1
	sld.w	112[ep], r2
	sld.w	108[ep], r3
	sld.w	104[ep], r4
	sld.w	100[ep], r5
	sld.w	 96[ep], r6
	sld.w	 92[ep], r7
	sld.w	 88[ep], r8
	sld.w	 84[ep], r9
	sld.w	 80[ep], r10
	sld.w	 76[ep], r11
	sld.w	 72[ep], r12
	sld.w	 68[ep], r13
	sld.w	 64[ep], r14
	sld.w	 60[ep], r15
	sld.w	 56[ep], r16
	sld.w	 52[ep], r17
	sld.w	 48[ep], r18
	sld.w	 44[ep], r19
	sld.w	 40[ep], r20
	sld.w	 36[ep], r21
	sld.w	 32[ep], r22
	sld.w	 28[ep], r23
	sld.w	 24[ep], r24
	sld.w	 20[ep], r25
	sld.w	 16[ep], r26
	sld.w	 12[ep], r27
	sld.w	  8[ep], r28
	sld.w	  4[ep], r29
	sld.w	  0[ep], r31
	addi	120, ep, sp
	Pop     ep
	jmp	r31

/*
 *  ư
 */
Function	__kernel_activate_r

	Lea	__kernel_runtsk, ep
	ld.w	0[ep], ep
	ld.w	TCB_tinib[ep], ep
	ld.w	TINIB_exinf[ep], r6
	ld.w	TINIB_task[ep], r10
	Lea	_ext_tsk, r31
	
	ei

	jmp	r10

/*
 *  ߤΥƥȤΤƤƥǥѥå
 *    CPUå֤ǸƤӽФʤФʤʤ
 */
Function	__kernel_exit_and_dispatch
	di
	Lea	_intnest, r10
	st.w	r0, 0[r10]
	br	__kernel_dispatch_1


.extern _InterruptHandlerEntry
.extern __kernel_runtsk
.extern __kernel_calltex

/*
 * ߥϥɥ
 */
Function	vector_handler

	/* ΰκ */
	addi	-16,  sp, sp
	st.w	 ep, 12[sp]
	st.w	r10,  8[sp]
	st.w	r11,  4[sp]
	st.w	r12,  0[sp]

	/*
	 * ϥɥ鵯ưϤɤ߽Ф
	 *    R10 : ϥɥ
	 */
	stsr	ecr, r10
	shr	2, r10
	add	-4, r10
	Lea	_InterruptHandlerEntry, r11
	add	r10, r11
	ld.w	0[r11], r10

	/* ϥɥ餬̵¨λ */
	cmp	r0,r10
	bne	1f

	/* ߥϥɥ餬ϿƤʤ硧
	   r6˲ơäδؿƤǤ뤫¾Υ쥸˲
	   ǽƤcpu_experr()halt
	   뤫̵¥롼פƤΤǤδؿäƤʤä
	   褦ˤʤ¾Υ쥸¸ۤ褤 */
	stsr	ecr, r6
	jarl	_cpu_experr, r31
	br	end_handler

1:
	/*
	 * ĤΥ쥸 
	 */
	addi	-116, sp, ep
	mov	ep, sp			/* åȿ */
	sst.w	r1, 112[ep]
	sst.w	r2, 108[ep]
	sst.w	r3, 104[ep]
	sst.w	r4, 100[ep]
	sst.w	r5,  96[ep]
	sst.w	r6,  92[ep]
	sst.w	r7,  88[ep]
	sst.w	r8,  84[ep]
	sst.w	r9,  80[ep]
	sst.w	r13, 76[ep]
	sst.w	r14, 72[ep]
	sst.w	r15, 68[ep]
	sst.w	r16, 64[ep]
	sst.w	r17, 60[ep]
	sst.w	r18, 56[ep]
	sst.w	r19, 52[ep]
	sst.w	r20, 48[ep]
	sst.w	r21, 44[ep]
	sst.w	r22, 40[ep]
	sst.w	r23, 36[ep]
	sst.w	r24, 32[ep]
	sst.w	r25, 28[ep]
	sst.w	r26, 24[ep]
	sst.w	r27, 20[ep]
	sst.w	r28, 16[ep]
	sst.w	r29, 12[ep]
	sst.w	r31,  8[ep]
	stsr	eipc,   r6		/* ¿ųк */
	sst.w	r6 ,  4[ep]
	stsr	eipsw,  r6
	sst.w	r6 ,  0[ep]

	/* ¿ųߥåȥͥȥ󥿤򥤥󥯥 */
	Lea	_intnest, r11
	ld.w	0[r11], r6
	add	1, r6
	st.w	r6, 0[r11]
	cmp	1, r6
	ble	1f

	/* ¿ų...Ǥ˳ߥåˤʤäƤ */
	jr	2f
1:
	/* ¿ųߤǤʤ */
	/* åڤؤ */
	mov	sp, r11
	Lea	STACKTOP, sp
	Push	r11

	Lea	end_int, r31
	/* ߵ */
	ei
	/* ϥɥ鵯ư */
	jmp	r10

	/*
	 * ߤ
	 */
Label	end_int
	/* ߶ػ */
	di

	/* å */
	ld.w	0[sp], sp

	/* intnestǥ */
	Lea	_intnest, r11
	ld.w	0[r11], r10
	mov	1, r11
	sub	r11, r10
	Lea	_intnest, r11
	st.w	r10, 0[r11]

	/* 
	 * ǥѥå׵᤬뤫
	 */
	Lea	__kernel_reqflg, r10
	ld.w	0[r10], r11
	cmp	r0, r11
	bz	recover_from_int
	st.w	r0, 0[r10]
	jr	ret_int

2:
	Lea	end_int_nest, r31
	/* ߵ */
	ei
	/* ϥɥ鵯ư */
	jmp	r10

	/*
	 * ߤ
	 */
Label	end_int_nest
	/* ߶ػ */
	di

	/* intnestǥ */
	Lea	_intnest, r11
	ld.w	0[r11], r10
	mov	1, r11
	sub	r11, r10
	Lea	_intnest, r11
	st.w	r10, 0[r11]

recover_from_int:
	/*
	 * 쥸 
	 */
	mov	sp, ep

	sld.w	112[ep], r1
	sld.w	108[ep], r2
	sld.w	104[ep], r3
	sld.w	100[ep], r4
	sld.w	 96[ep], r5
	sld.w	 92[ep], r6
	sld.w	 88[ep], r7
	sld.w	 84[ep], r8
	sld.w	 80[ep], r9
	sld.w	 76[ep], r13
	sld.w	 72[ep], r14
	sld.w	 68[ep], r15
	sld.w	 64[ep], r16
	sld.w	 60[ep], r17
	sld.w	 56[ep], r18
	sld.w	 52[ep], r19
	sld.w	 48[ep], r20
	sld.w	 44[ep], r21
	sld.w	 40[ep], r22
	sld.w	 36[ep], r23
	sld.w	 32[ep], r24
	sld.w	 28[ep], r25
	sld.w	 24[ep], r26
	sld.w	 20[ep], r27
	sld.w	 16[ep], r28
	sld.w	 12[ep], r29
	sld.w	  8[ep], r31
	sld.w	  4[ep], r10
	ldsr	    r10, eipc
	sld.w	  0[ep], r10
	ldsr	    r10, eipsw

	addi	116, ep, sp


end_handler:
	/*
	 * ΰ
	 */
	addi	 16, sp, sp
	ld.w	 -4[sp], ep
	ld.w	 -8[sp], r10
	ld.w	-12[sp], r11
	ld.w	-16[sp], r12
	reti


/*
 * ߤˤȤʤǥѥåȽ
 */
ret_int:
	/* ǥѥåػߡ */
	Lea	__kernel_enadsp, r10
	ld.w	0[r10], r10
	cmp	r0, r10
	be	ret_int_r

	/* ڤؤɬפ뤫 */
	Lea	__kernel_schedtsk, r10
	ld.w	0[r10], r10
	Lea	__kernel_runtsk, r11
	ld.w	0[r11], r11
	cmp	r10,r11
	be	ret_int_r

	/* TCBȤ */
	mov	ep, r11
	Lea	__kernel_runtsk, ep
	sld.w	0[ep], ep			/* ep = _kernel_runtsk */

	sst.w	sp, TCB_sp[ep]
	Lea	ret_int_r, r10
	sst.w	r10, TCB_pc[ep]
	stsr	psw, r10
	sst.w	r10, TCB_psw[ep]
	mov	r11, ep

	/* ǥѥå */
	stsr	eipsw, r10
	ori	0x20, r10, r10
	ldsr	r10, eipsw
	Lea	__kernel_dispatch_1, r10
	ldsr	r10, eipc
	reti

ret_int_r:
	di

	Lea	__kernel_runtsk, r10
	ld.w	0[r10], r10
	ld.w	TCB_enatex[r10], r11
	tst1	TCB_enatex_bit, 0[r11]
	be	1f
	ld.w	TCB_texptn[r10], r11
	cmp	r0, r11
	be	1f

	/* 㳰 */
	jarl	__kernel_calltex, r31
1:
	/* ȤФ */
	jr	recover_from_int

/*
 * CPUå֤μ
 *
 *   ߶ػߤʤCPUå
 */
Function	_sense_lock
	stsr	psw, r10
	shr	5, r10
	andi	1, r10, r10
	jmp	r31


