/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2006 by Witz Corporation, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_insn.h,v 1.1 2006/04/10 08:19:25 honda Exp $
 */

/*
 *	ץåü̿Υ饤ؿTLCS-900L1ѡ
 */

#ifndef	_CPU_INSN_H_
#define	_CPU_INSN_H_

/*
 *  ơ쥸SRˤθͤɽФ
 */
#pragma inline current_sr
UH
current_sr()
{
	Asm("	push	sr");
	Asm("	pop		hl");
	return(__HL);
}

/*
 *  ơ쥸SRˤθͤѹ
 */
#pragma inline set_sr
void
set_sr(UH sr)
{
	__HL = sr;
	Asm("	push	hl");
	Asm("	pop		sr");
}

/*
 *  NMI٤Ƥγߤػ
 */
/*
 *  ei #7פȡdiפƱεǽǤ뤬ei̿ϼ¹Ըľͭ
 *  ʤ뤿ei̿Ѥ
 */
#pragma inline disint
void
disint()
{
	Asm("	ei	7	");
}

/*
 *  ٤Ƥγߤ
 */
#pragma inline enaint
void
enaint()
{
	Asm("	ei	0	");
}

/*
 *  ǥ塼ΤΥӥåȥޥåץؿ
 *
 *  ӥåȥޥåפβ16ӥåȤѤǲ̥ӥåȤͥ٤б
 *  롥
 */
#define	CPU_BITMAP_SEARCH

#pragma inline bitmap_search
UINT
bitmap_search(UINT bitmap)
{
	/*
	 *  ΥɤϡbitmapUINTˤ16ӥåȤǤ뤳Ȥꤷ
	 *  Ƥ롥
	 */
	__HL = bitmap;
	Asm("	bs1f	a, hl");
	return (UINT)__A;
}

#endif /* _CPU_INSN_H_ */
