/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *                     2003         by Advanced Data Controls, Corp
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_support.sh,v 1.4 2003/12/19 11:48:37 honda Exp $
 */


#define _MACRO_ONLY
#include "jsp_kernel.h"
#include "offset.h"
#include <t_config.h>
 			

/*GHS ֥鵼̿Ѵ*/
#define	long	data.l
#define	org	offset

/*GHS ROM˥ߥȥ꡼ɥ쥹*/
#ifdef 	GHS_STUB
#define	_CpuExceptionHandler	0xa0000848
#endif


/*
 *  㳰/߽롼
 *  SH3ϥ٥ơ֥㳰,TRAPAȯVBR+0x100Ϥ
 *  //NMIߤȯȡVBR+0x600Ϥ¹Ԥ롣
 */
        
/*
 *	VBR ꤹ
 */
    .section .text
    .align 2        
    .global _BASE_VBR
_BASE_VBR:
     bra _start
     nop
     nop
     nop

/*
 *  Exception 100 vector
 *  ɥ쥹顼,å̿㳰Trapa㳰ȯȼ¹Ԥ롣
 *
 *  CPU㳰ϥɥϡ󥿥ƥȤǼ¹Ԥ롢ΤᡢCPU㳰ϥ
 *  ɥƤӽФ㳰/ߤ򼨤쥸Х1 r7 쥸򥤥
 *  Ȥ꥿󤷤Ƥ˥ǥȤ롣CPU㳰ƥ
 *  Ȥȯregflg  TRUE ˤʤäˡ ret_exc ʬ롣
 *  regflg å˳ߤػߤʤȡreqflg å˵
 *  ư줿ߥϥɥǥǥѥå׵ᤵ줿ˡǥѥå
 *  ʤ
 *
 *		
 *  㳰ȯȡ㳰ȯΥƥȤǤspc,pr,ssr,r0r7
 *  롣㳰ȯǤΥƥȤĴ󥿥ƥȤʤ
 *  _exception_from_int¹Ԥ򳫻Ϥ롣㳰װEXPEVT쥸ɤߡ
 *  exc_tableCPU㳰ϥɥγϤɤ߹ࡣȯ㳰Ф
 *  CPU㳰ϥɥ餬ϿƤʤС_no_reg_exception˥֥ơ
 *  ssr,sr,spc,prƤϤߤ롣CPU㳰ϥɥ餫꥿󤷤
 *  顢reqflgĴ0ʳʤrec_exc()ӡ0ʤ鸵ν˥꥿
 *  롣
 *
 *
 *  BLӥåȤΰˤĤ
 *  ssr,spc ΥƥȤᤷ rte ȯԤݤˤϡߡNMI 
 *  ޤˤդʤ褦 BL ӥåȤ1ˤɬפ롥㳰/ߥ
 *  ɥ齪λˤ BL ӥåȤ1ˤ IPM  MAX_IPM ꤹ롥ϡ
 *  BL ӥåȤ1ξ㳰ȯ CPU ꥻåȤ뤳Ȥθơ
 *  Τᡤssr,spcľBL1ꤷƤ롥
 *       
 */	
			

    .org   0x0100              /*  _BASE_VBR + 0x0100Ϥ   */
    .align 2
    .global _general_exception
_general_exception:
#ifdef GHS_STUB /* GHS */
	mov.l	r0,@-r15
	mov.l	r1,@-r15
	mov.l   _expevt,r0
	mov.l   @r0,r1     
	shlr2   r1           
	shlr    r1
	mov.l   _exc_table_exc,r0
	mov.l   @(r0,r1),r0        
	tst     r0,r0
	mov.l	@r15+,r1	
	mov.l	@r15+,r0
	bt      _rom_exception   /* _rom_exceptionإ             */
#endif
 /* spc,pr,ssr 򥹥å¸ */
    stc.l  spc,@-r15          
    sts.l  pr,@-r15               
    stc.l  ssr,@-r15
    stc.l  gbr,@-r15					
    sts.l  macl,@-r15					
    sts.l  mach,@-r15
    stc.l  r0_bank,@-r15 /* 㳰ȯr0r7¸        */    
    stc.l  r1_bank,@-r15
    stc.l  r2_bank,@-r15
    stc.l  r3_bank,@-r15
    stc.l  r4_bank,@-r15
    stc.l  r5_bank,@-r15
    stc.l  r6_bank,@-r15    
    stc.l  r7_bank,@-r15
    tst    r7,r7               /* 㳰ȯΥƥȤȽ            */
    bf/s   _exception_from_exc /* ȯ㳰/ߥϥɥʤ饸 */
     add    #0x01,r7	       /* 㳰/ߥͥȲ򥤥󥯥   */
    mov    r15,r1              /* 褬ߥϥɥǤʤΤǥ  */
    mov.l  _stacktop_exc,r15   /* ؤΥåݥ󥿤¸    */ 
    mov.l r1,@-r15            
#ifdef GHS_HOOK
	mov.l   r1,@-r15
	mov.l   r7,@-r15
	stc     spc,r0
	mov.l   r0,r5
	mov.l   _expevt,r0        /* ߵĤȾä쥸¸    */
	mov.l   _exception_hook_dis,r2
	jsr     @r2
	mov.l   @r0,r4            /* EXPEVT쥸		              */
	mov.l   @r15+,r7
	mov.l   @r15+,r1
#endif

    mov.l  _expevt,r0          /* 㳰ĤȾä쥸¸      */
    mov.l  @r0,r5              /* EXPEVT쥸                      */
    ldc    r1,r4_bank          /* CPU㳰ϥɥؤΰ                   */
    ldc    r5,r5_bank	     
    mov.l  _unmak_rb_bl_exc,r2 /* BLӥåȤ0ˡ쥸Х󥯤ڤؤ   */
    stc    sr,r3               
    and    r3,r2			
    ldc    r2,sr               
    shlr2  r5                  /* EXPEVT3ӥåȱե                   */
    shlr   r5                
    mov.l  _exc_table_exc,r0   /* exc_tableΥɥ쥹r0                 */
    mov.l  @(r0,r5),r2         /* ϥɥΥɥ쥹                  */
    tst    r2,r2               /* ϥɥ餬ϿƤʤ㳰ʤ        */
    bt     _no_reg_exception   /* no_reg_exceptionإ                */
    jsr    @r2                 /* CPU㳰ϥɥ                         */
     nop
    mov.l  _mask_md_ipm_exc,r0
    ldc    r0,sr               /* ߶ػ                              */
    stc    r7_bank,r7          /* 㳰/ߤΥͥȲǥ   */
    dt     r7
    ldc    r7,r7_bank
    mov.l  _reqflg_exc,r2      /* reqflgΥå                          */
    mov.l  @r2,r1
    tst    r1,r1               /* reqflgFALSEʤret_to_task_exc    */
    bt/s   _ret_to_task_exc    /*                               */
     mov.l  @r15,r15           /* 褬ʤΤǥå᤹        */
    xor    r0,r0               
    bra    ret_exc
     mov.l  r0,@r2             /* reqflg򥯥ꥢ                            */


/*
 *   exception_from_int
 *   CPU㳰ȯΥƥȤ󥿥ƥȤξν
 *   ƥȤξȤνΰ㤤ϡCPU㳰ϥɥ
 *   λɬν뤳ȤǤ롣
 */
	
_exception_from_exc:
#ifdef GHS_HOOK
	mov.l   r7,@-r15
	stc     spc,r0
	mov.l   r0,r5
	mov.l   _expevt,r0       /* ߵĤȾä쥸¸    */
	mov.l   _exception_hook_dis,r2
	jsr     @r2
	mov.l   @r0,r4           /* EXPEVT쥸                      */
	mov.l   @r15+,r7
	
#endif
    mov.l   _expevt,r0        /* 㳰ĤȾä쥸¸      */
    mov.l   @r0,r5            /* EXPEVT쥸                      */
    ldc     r15,r4_bank       /* CPU㳰ϥɥؤΰ                   */
    ldc     r5,r5_bank	     
    mov.l   _unmak_rb_bl_exc,r2 /* BLӥåȤ0ˡ쥸Х󥯤ڤؤ */
    stc     sr,r3
    and     r3,r2			
    ldc     r2,sr               
    shlr2   r5                /* EXPECT3ӥåȱե                   */
    shlr    r5                	
    mov.l   _exc_table_exc,r0 /* exc_tableΥɥ쥹r0                 */
    mov.l   @(r0,r5),r2       /* ϥɥΥɥ쥹                  */
    tst     r2,r2             /* ϥɥ餬ϿƤʤ㳰ʤ        */
    bt      _no_reg_exception /* no_reg_exceptionإ                */
    jsr     @r2               /* CPU㳰ϥɥ                         */
     nop
    mov.l  _mask_md_ipm_exc,r0
    ldc    r0,sr              /* BL=1,߶ػ                         */
    stc    r7_bank,r7         /* 㳰/ߤΥͥȲǥ   */
    dt     r7
    ldc    r7,r7_bank
_ret_to_task_exc:
    mov.l  @r15+,r7           /* r0r1,ssr,pr,spc     */
    mov.l  @r15+,r6
    mov.l  @r15+,r5
    mov.l  @r15+,r4
    mov.l  @r15+,r3
    mov.l  @r15+,r2
    mov.l  @r15+,r1        
    mov.l  _mask_md_bl_exc,r0 
    ldc    r0,sr             /* BL1                                   */
    mov.l  @r15+,r0
    lds.l  @r15+,mach                
    lds.l  @r15+,macl        
    ldc.l  @r15+,gbr               
    ldc.l  @r15+,ssr            
    lds.l  @r15+,pr
    ldc.l  @r15+,spc
    rte
     nop

#ifdef GHS_STUB /* GHS */
_rom_exception:
	stc.l	ssr,@-r15
	stc.l	spc,@-r15
	mov.l	r0,@-r15
	mov.l	r1,@-r15
	mov.l	L._CpuException1,r1
	jmp	@r1
	mov	#1,r0

	.align	4
L._CpuException1:
	.data.l	_CpuExceptionHandler
#endif

/*	
 *  no_reg_exception()
 *  CPU㳰ȤϿƤʤ㳰ȯȸƤӽФ
 *  㳰ɡ㳰ȯpc,sr,prϤƥͥ
 *  ߤ롣
 */					
_no_reg_exception:
    mov.l  _expevt,r5
    mov.l  @r5,r4
    stc    spc,r5
    stc    ssr,r6
    sts    pr,r7
    mov.l  _cpu_expevt_k,r1
    jsr    @r1
     nop

	.align  4
_stacktop_exc:
    .long  STACKTOP            /* ΩΥåν  */
_expevt:	
    .long  EXPEVT
_exc_table_exc:	
    .long  _exc_table
_unmak_rb_bl_exc:		
    .long  0x4fffffff
_mask_md_ipm_exc:	
    .long  0x40000000 + MAX_IPM << 4	
_reqflg_exc:
    .long  _reqflg
_cpu_expevt_k:	
    .long  _cpu_expevt	
_mask_md_bl_exc:	
    .long  0x50000000 + MAX_IPM << 4	

#ifdef GHS_HOOK
	.global _exception_hook
_exception_hook_dis:
	.long   _exception_hook
#endif


	
/*
 *  ǥѥå
 *
 *  _dispatch ϡr7_bank1 = 0,߶ػ߾֤ǸƤӽФʤФʤ
 *  _exit_and_dispatch ⡤r7_bank1 = 0߶ػ߾֤ǸƤӽФ
 *  Τ§Ǥ뤬ͥ뵯ưб뤿ᡤr7_bank1 = 1ǸƤ
 *  ФˤбƤ롥
 */

    .text
    .align 2
    .global _dispatch
_dispatch:
    sts.l  pr,@-r15         /* pr,r8r15 򥹥å¸           */
    mov.l  r14,@-r15        /* r0r7ϸƤӽФ¸Ƥ뤿  */    
    mov.l  r13,@-r15        /* ¸ɬפ̵                    */    
    mov.l  r12,@-r15
    mov.l  r11,@-r15
    mov.l  r10,@-r15
    mov.l  r9, @-r15
    mov.l  r8, @-r15
    mov.l  _runtsk_dis,r2   /* r0 <- runtsk                          */
    mov.l  @r2,r0
    mov.l  r15,@(TCB_sp,r0) /* åTCB¸ 60ʲʤOK*/		
    mov.l  dispatch_r_k,r1  /* ¹ԺƳϤ¸                    */
    mov.l  r1,@(TCB_pc,r0)  /* ¹ԺƳϤTCB¸  60ʲʤOK */
    bra    dispatcher
     nop

dispatch_r:	
    mov.l  @r15+,r8         /* 쥸                       */
    mov.l  @r15+,r9
    mov.l  @r15+,r10
    mov.l  @r15+,r11
    mov.l  @r15+,r12
    mov.l  @r15+,r13
    mov.l  @r15+,r14
    lds.l  @r15+,pr
    /*
     *  㳰롼εư
     *  dispatch_rdispatcherƤӽФ뤿ᡤ
     *  tcbΥɥ쥹r0äƤ롥      
     */
    mov.l  @(TCB_enatex,r0),r1
    mov.l  _enatex_mask_dis,r2
    tst    r1,r2
    bt     dispatch_r_1         /* enatex  FALSE ʤ꥿ */
    mov.l  @(TCB_texptn,r0),r1  /* texptn               */
    tst    r1,r1
    bt     dispatch_r_1         /* texptn  0̵        */
    mov.l  _call_texrtn_dis,r1  /* 㳰롼θƤӽФ */
    jmp    @r1        
     nop                          
dispatch_r_1:   
    rts
     nop                

    .global _exit_and_dispatch
_exit_and_dispatch:
    xor    r1,r1                 /* r7_bank10ꥢ             */
    ldc    r1,r7_bank
dispatcher:
    /*
     * ˤϳ߶ػߤ뤳
     */
    mov.l  _schedtsk_dis,r12    /* r0 <- schedtsk                   */
    mov.l  @r12,r0             
    cmp/eq #0,r0                /* schedtsk 뤫              */
    bt     dispatcher_1         /* ̵Х                 */
#ifdef GHS_HOOK 
	mov.l   _dispatch_hook_dis,r2
	jsr     @r2
	mov     r0,r4
	mov.l   @r12,r0
#endif

    mov.l  _runtsk_dis,r2
    mov.l  r0,@r2               /* schedtskruntsk               */
    mov.l  @(TCB_sp,r0),r15     /* TCB饿å      */
    mov.l  @(TCB_pc,r0),r1      /* TCB¹ԺƳϤ        */
    jmp    @r1 
     nop
dispatcher_1:
    /* ߥǥͤɤ߹ΤϸΨΤǻѰդ
     * r8  : ߶ػߤΤSR   
     * r9  : ԤSR
     * r10 : reqflg
     * r11 : 0x01
     * r12 : 0x00
     * r13 : sleepSRξ       
     */
    mov.l  _mask_md_ipm_dis,r8  /* ߶ػߤSR             */
#ifdef NO_SLEEP
    mov.l  _mask_md_dis,r9      /* ԤSR           */        
#else
    mov.l  _mask_bl_md_dis,r9   /* ԤSR           */
#endif                          
#ifdef SUPPORT_CHG_IPM
    mov.l  _task_intmask_k,r2
    mov.l  @r2,r3
    or     r3,r9
#endif
    mov.l  _reqflg_dis,r10
    mov    #0x01,r11
    xor    r12,r12
    mov.l  _stacktop_dis,r15   /* åߥå     */
    ldc    r11,r7_bank         /* r7_bank1 1ˤƳ߾֤ */        
dispatcher_2:        
    /*
     *  ǳߥ⡼ɤڤ괹Τϡȯ߽
     *  ˤɤΥåȤȤβȡߥϥɥ
     *  ΥǥѥåɻߤȤĤΰ̣롥
     */
     /*
      *  ߵĸsleep̿¹Ԥȡߵ̿μ¹
      *  ׵᤬äƤ硤ߵ̿μ¹Ԥȶ˳ߤ
      *  դ줽ˡreqflgΥåǤϤʤ sleep 
      *  äƤޤ
      *  ϡߤεĤ sleep ֤ؤΰܹԤȥߥå˼
      *  ԤǤʤȤ˵롥
      *  Τᡤsleep ¹ľ SR ѹǤ BL ӥåȤ'1'ꤹ
      *  뤳ȤǡߤεĤ sleep ֤ؤΰʹߤ򥢥ȥߥå˼¹
      *  롥
      *  ldc r9,sr ǤBLӥåȤåȤ뤿ᡤߤϼդ
      *  ꡼ץ⡼ɤ˰ܹԤ롥꡼ץ⡼ϡBLӥåȤ1Ǥ
      *  ߤդ뤿(SH7709ϡɥޥ˥奢 8-10)꡼
      *  ץ⡼ɤؤΰܹľ˳ߤե꡼ץ⡼ɤ롥
      */
               
    ldc    r9,sr               /* ߤε                   */
#ifndef NO_SLEEP
    sleep                      /* Ԥ                       */
#endif /* NO_SLEEP */                
    ldc    r8,sr               /* ߶ػ                     */  
    mov.l  @r10,r7             /* r7 <- reqflg                     */
    tst    r7,r7               /* reqflg  FALSEʤ              */
    bt     dispatcher_2        /* dispatcher_2                   */
    ldc    r12,r7_bank         /* r7_bank1 򥯥ꥢ                */        
    mov.l  r12,@r10            /* reqflg  FALSE                */
    bra    dispatcher
     nop	
    .align 4
_runtsk_dis:	
    .long _runtsk
_schedtsk_dis:	
    .long _schedtsk
_enatex_mask_dis:    
    .long TCB_enatex_mask
_call_texrtn_dis:	
    .long _call_texrtn
_mask_md_ipm_dis:	
    .long 0x40000000 + MAX_IPM << 4
_mask_md_dis:	
    .long 0x40000000
_mask_bl_md_dis:	
    .long 0x50000000	        
dispatch_r_k:	
    .long dispatch_r
_stacktop_dis:
    .long STACKTOP           /* ΩΥåν	*/
_reqflg_dis:
    .long  _reqflg
#ifdef GHS_HOOK
	.global _dispatch_hook
_dispatch_hook_dis:
	.long   _dispatch_hook
#endif


/* 
 *  ߥϥɥ/CPU㳰ϥɥи
 *
 * 褬reqflgåȤƤΤߤˤ롣
 * r7_bank1 = 0,߶ػ߾,å쥸¸
 * ֤ǸƤӽФȡ 
 *	
 */
    .text
    .align 2
    .globl ret_int
    .globl ret_exc
ret_exc:
ret_int:
    mov.l  _runtsk_ret,r1     /* r0 <- runtsk                  */
    mov.l  @r1,r0           
    mov.l  _enadsp_ret,r2     /* enadspΥå              */
    mov.l  @r2,r3
    tst    r3,r3           
    bt     ret_int_1           
    mov.l  _schedtsk_ret,r4   /* r5 <- schedtsk                */ 
    mov.l  @r4,r5
    cmp/eq r0,r5              /* runtsk  schedtsk      */
    bt     ret_int_1
    mov.l  r14,@-r15          /* ĤΥ쥸¸          */
    mov.l  r13,@-r15					
    mov.l  r12,@-r15					
    mov.l  r11,@-r15					
    mov.l  r10,@-r15					
    mov.l  r9,@-r15					
    mov.l  r8,@-r15
    mov    #TCB_sp,r1        /* å¸           */
    mov.l  r15,@(r0,r1)    
    mov.l  ret_int_r_k,r1    /* ¹ԺƳϤ¸             */
    mov    #TCB_pc,r2	
    mov.l  r1,@(r0,r2)  
    bra    dispatcher
     nop
    
ret_int_r:
    mov.l  @r15+,r8		
    mov.l  @r15+,r9		
    mov.l  @r15+,r10		
    mov.l  @r15+,r11		
    mov.l  @r15+,r12		
    mov.l  @r15+,r13		
    mov.l  @r15+,r14		
ret_int_1:
    /*
     *  㳰롼εư
     *  ret_int_r  dispatcher ƤӽФ뤿ᡤtcbΥɥ쥹r0
     *  äƤ롥
     *  ʤߤνиǥåȯʤϥǥѥå
     *  ̤餺 ret_int ľ ret_int_1        
     */
    mov.l  @(TCB_enatex,r0),r1
    mov.l  _enatex_mask_ret,r2
    tst    r1,r2
    bt     ret_int_2            /* enatex  FALSE ʤ꥿  */
    mov.l  @(TCB_texptn,r0),r1  /* texptn                */
    tst    r1,r1
    bt     ret_int_2            /* texptn  0̵T<= 0    */
    mov.l _call_texrtn_ret,r1   /* 㳰롼θƤӽФ  */
    jsr   @r1        
     nop       
ret_int_2:               
#ifdef SUPPORT_CHG_IPM
    mov    #32,r0
    mov.l  @(r0,r15),r1
    mov.l  _unmask_ipm,r2
    and    r2,r1
    mov.l  _task_intmask_k,r2
    mov.l  @r2,r3
    or     r3,r1
    mov.l  r1,@(r0,r15)
#endif /* SUPPORT_CHG_IMP */
    mov.l  @r15+,r7            /* spc,pr,ssr,å쥸 */
    mov.l  @r15+,r6        
    mov.l  @r15+,r5
    mov.l  @r15+,r4
    mov.l  @r15+,r3
    mov.l  @r15+,r2
    mov.l  @r15+,r1
    mov.l  _mask_md_bl_ret,r0
    ldc    r0,sr               /* BL1                               */
    mov.l  @r15+,r0
    lds.l  @r15+,mach                
    lds.l  @r15+,macl        
    ldc.l  @r15+,gbr       
    ldc.l  @r15+,ssr    
    lds.l  @r15+,pr
    ldc.l  @r15+,spc
    rte
     nop
        
    .align 4
_runtsk_ret:
    .long _runtsk
_schedtsk_ret:	
    .long _schedtsk
_enadsp_ret:	
    .long _enadsp
ret_int_r_k:
    .long ret_int_r
_enatex_mask_ret:    
    .long TCB_enatex_mask        
_call_texrtn_ret:	
    .long _call_texrtn
_mask_md_bl_ret:	
    .long  0x50000000

/*
 *  ư
 */ 
    .text
    .align 2
    .globl _activate_r
_activate_r:
    stc    sr,r0               /* ߵ */
    mov.l  _unmask_ipm,r1
    and    r1,r0	
#ifdef SUPPORT_CHG_IPM
    mov.l  _task_intmask_k,r1
    mov.l  @r1,r2
    or     r2,r0
#endif /* SUPPORT_CHG_IPM */
    ldc    r0,sr
    mov.l  @r15+,r1
    lds.l  @r15+,pr
    mov.l  @r15+,r4
    jmp    @r1
     nop
    .align 4
_unmask_ipm:
    .long  0xffffff0f
#ifdef SUPPORT_CHG_IPM		
_task_intmask_k:
    .long _task_intmask
#endif /* SUPPORT_CHG_IPM */
		
		
/*
 *  Exception 600 vector
 *  ߤȯȼ¹Ԥ롣		
 *
 *
 *  SH3ϳߤȯȤ٤VBR+0x600Ϥץ¹Ԥ뤿ᡢ
 *  ֤롼Ǥޤåڤؤ쥸¸,IPM,
 *  װȽԤθBLӥåȤ0ˤƳߥϥɥƤɬ
 *  롣
 *  װбߥϥɥγϤint_table[]Ͽ
 *  ƸƤӽФեåȤη׻ϡװ쥸򱦤2ӥåȥեȤ
 *  ƹԤװ쥸SH7708ǤINTEVT쥸˥åȤ뤬
 *  SH7709SH7709AǤINTEVT2˥åȤ뤿ᡢifdefˤڤʬƤ
 *  롣ޤΥǥХˤĤƳװ쥸ϤͤIPM
 *  δ֤ˤϴطʤᡢƳװбIPMSRƤ
 *  int_plevel_table[]ϿƤɤ߽Ф
 *
 *  reqflg å˳ߤػߤʤȡreqflg å
 *  ˵ư줿ߥϥɥǥǥѥå׵ᤵ줿ˡǥ
 *  ѥåʤ
 *
 */

    .org    0x0600        /* _BASE_VBR + 0x0600Ϥ */
    .align 2
    .global _interrupt
_interrupt:    
#ifdef GHS_STUB
	mov.l	r0,@-r15
	mov.l	r1,@-r15
	mov.l   _intevt,r0 
	mov.l   @r0,r1     
	shlr2   r1           
	shlr    r1
/*	mov.l   _int_table_k,r0
	mov.l   @(r0,r1),r0
*/	
	mov.l	@r15+,r1
	mov.l	@r15+,r0
	bt      _rom_interrupt   
#endif
    stc.l  spc,@-r15       /* ¿ųߤȾäƤޤΤ        */
    sts.l  pr,@-r15        /* spc,pr,ssr,gbr,macl,mach                    */
    stc.l  ssr,@-r15    
    stc.l  gbr,@-r15                    
    sts.l  macl,@-r15                    
    sts.l  mach,@-r15                                                    
    stc.l  r0_bank,@-r15   /* ,r0r7򥹥å¸   */ 
    stc.l  r1_bank,@-r15
    stc.l  r2_bank,@-r15
    stc.l  r3_bank,@-r15
    stc.l  r4_bank,@-r15
    stc.l  r5_bank,@-r15
    stc.l  r6_bank,@-r15    
    stc.l  r7_bank,@-r15
    tst    r7,r7                 /* ȯΥƥȤȽ  */  
    bf/s    _interrupt_from_int  /* 㳰/ߥϥɥʤ饸   */
     add    #0x01,r7             /* ߤΥͥȲ򥤥󥯥*/
    mov    r15,r1                /* åؤΥåݥ  */
    mov.l  _stacktop_k,r15       /* 󥿤¸                          */
    mov.l  r1,@-r15            
#ifdef GHS_HOOK
	mov.l   r7,@-r15
	stc     spc,r0
	mov.l   r0,r5
	mov.l   _intevt,r0          /* 㳰װ쥸              */
	mov.l   _interrupt_hook_dis,r2
	jsr     @r2
	mov.l   @r0,r4              
	mov.l   @r15+,r7
#endif
    mov.l  _intevt,r0            /* 㳰װ쥸              */
    mov.l  @r0,r4              
    shlr2  r4                    /* 3ӥåȱեȤեåȤ */
    shlr   r4                  
    mov.l  _int_plevel_table_k,r0 
    mov.l  @(r0,r4),r5           /* ߤͥ٤               */
    mov.l  _int_table_k,r0    
    mov.l  @(r0,r4),r2           /* ߥϥɥΥɥ쥹    */
    ldc    r2,r2_bank            /* Х0ڤؤ뤿ᥳԡ       */    
    ldc    r5,sr                 /* ʹ߳ߤդ롣      */
    jsr    @r2                   /* ߥϥɥ                  */
     nop
    mov.l  _mask_md_ipm_ret,r0
    ldc    r0,sr                 /* ߶ػ                           */
    stc    r7_bank,r7            /* 㳰/ߤΥͥȲǥ*/
    dt     r7
    ldc    r7,r7_bank
    mov.l  _reqflg_k,r4          /* reqflgΥå                       */
    mov.l  @r4,r1
    tst    r1,r1                 /* reqflgFALSEʤret_to_task_int */
    bt/s   _ret_to_task_int      /*                            */
     mov.l  @r15,r15             /* 褬ʤΤǥå᤹     */
    xor    r0,r0
    bra    ret_int
     mov.l  r0,@r4               /* reqflg򥯥ꥢ                   */
_interrupt_from_int:
#ifdef GHS_HOOK
	mov.l   r7,@-r15
	stc     spc,r0
	mov.l   r0,r5
	mov.l   _intevt,r0             /* 㳰װINTEVT2쥸    */
	mov.l   _interrupt_hook_dis,r2
	jsr     @r2
	mov.l   @r0,r4
	mov.l   @r15+,r7
#endif
    mov.l   _intevt,r0           /* 㳰װ쥸           */
    mov.l   @r0,r4
    shlr2   r4                   /* եåȤ               */
    shlr    r4                   /* եåȤ               */    
    mov.l   _int_plevel_table_k,r0 
    mov.l   @(r0,r4),r5            /* ߤͥ٤           */
    mov.l   _int_table_k,r0        
    mov.l   @(r0,r4),r2            /* ߥϥɥΥɥ쥹 */
    ldc     r2,r2_bank             /* Х0ڤؤ뤿ᥳԡ    */
    ldc     r5,sr                  /* ʹ߳ߤդ롣   */
    jsr     @r2                    /* ߥϥɥ               */ 
     nop
    mov.l  _mask_md_ipm_ret,r0
    ldc    r0,sr                   /* ߶ػ                     */
    stc    r7_bank,r7              /* 㳰/ߤΥͥȲǥ*/
    dt     r7
    ldc    r7,r7_bank
_ret_to_task_int:
    mov.l  @r15+,r7                /* ߸                 */
    mov.l  @r15+,r6
    mov.l  @r15+,r5
    mov.l  @r15+,r4
    mov.l  @r15+,r3
    mov.l  @r15+,r2
    mov.l  @r15+,r1
    mov.l  _mask_md_bl_int,r0 
    ldc    r0,sr                   /* BL 1                         */
    mov.l  @r15+,r0
    lds.l  @r15+,mach                
    lds.l  @r15+,macl        
    ldc.l  @r15+,gbr                       
    ldc.l  @r15+,ssr
    lds.l  @r15+,pr
    ldc.l  @r15+,spc
    rte
     nop
#ifdef GHS_STUB
_rom_interrupt:
	stc.l	ssr,@-r15
	stc.l	spc,@-r15
	mov.l	r0,@-r15
	mov.l	r1,@-r15
	mov.l	L._CpuException6,r1
	jmp	@r1
	mov	#6,r0

	.align	4
L._CpuException6:
	.data.l	_CpuExceptionHandler
#endif
    /*
     * ̤Ͽγߤȯȡλ INTEVT,INTEVT2,SR,PC 
     * cpu_interrupt()ƤӽФ
     */   
    .global _no_reg_interrupt
_no_reg_interrupt:
    mov.l _intevt1,r0
    mov.l @r0,r4
#if defined(SH7709) || defined(SH7709A) || defined(SH7729R) || defined(SH7727) 
    mov.l _intevt2,r0    
    mov.l @r0,r5
#endif 
    stc   spc,r6
    stc   ssr,r7
    mov.l _cpu_interrupt_k,r1
    jsr   @r1
     nop
    .align  4
_stacktop_k:
    .long  STACKTOP            /* 󥿥ΩΥåν  */
_intevt:        
#if defined(SH7708) || defined(SH7750)    
    .long  INTEVT
#else
    .long  INTEVT2
#endif    
_int_table_k:    
    .long    _int_table       
_int_plevel_table_k:    
    .long    _int_plevel_table 
_reqflg_k:
    .long  _reqflg
_mask_md_ipm_ret:    
    .long  0x40000000 + MAX_IPM << 4
_mask_md_bl_int:    
    .long  0x50000000
_intevt1:        
    .long  INTEVT
#if defined(SH7709) || defined(SH7709A) || defined(SH7729R) || defined(SH7727) 
_intevt2:        
    .long  INTEVT2
#endif 
_cpu_interrupt_k:
    .long  _cpu_interrupt   
#ifdef GHS_HOOK
_interrupt_hook_dis:
	.long   _exception_hook
#endif

   
/*
 *  Ԥ
 */
	.globl _sil_dly_nse
_sil_dly_nse:
    mov.l  _sil_dly_tim1, r1
    add    r1, r4
    cmp/pl r4
    bt     _sil_dly_nse1
    rts
     nop
_sil_dly_nse1:            
    mov.l  _sil_dly_tim2, r1
    add    r1, r4
    cmp/pl r4
    bt     _sil_dly_nse1
    rts
     nop   
    .align 4
_sil_dly_tim1:
    .long  -SIL_DLY_TIM1    
_sil_dly_tim2:                         
    .long  -SIL_DLY_TIM2
