/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_insn.h,v 1.5 2005/07/06 00:45:07 honda Exp $
 */

/*
 *	ץåü̿Υ饤ؿSH1/2ѡ
 */

#ifndef	_CPU_INSN_H_
#define	_CPU_INSN_H_

/*
 *  ơ쥸SRˤθͤɽФ
 */
Inline UW
current_sr(void)
{
	UW sr;
	Asm("stc  sr,%0" : "=r"(sr));
	return(sr);
}

/*
 *  ơ쥸SRˤθͤѹ
 */
Inline void
set_sr(UW sr)
{
	Asm("ldc %0, sr" : : "r"(sr) );
}

/*
 *  NMI٤Ƥγߤػ
 *  ʥͥ뤬ߤΤ߶ػߡ
 */
Inline void
disint()
{
    set_sr((current_sr() & ~0x000000f0u) |  (MAX_IPM << 4) );
}

/*
 *  ٤Ƥγߤ
 */
Inline void
enaint()
{
	set_sr(current_sr() & ~0x000000f0u);
}

/*
 *  ٥١쥸VBRˤθͤɽФ
 */
Inline VP
current_vbr()
{
	VP	vbr;

	Asm("stc vbr,%0" : "=r"(vbr));
	return(vbr);
}

/*
 *  ٥١쥸VBRˤ
 */
Inline void
set_vbr(VP vbr)
{
	Asm("ldc  %0, vbr" : : "r"(vbr) );
}

/*
 *  ǥ塼ΤΥӥåȥޥåץؿ
 *
 *¸ѰդؿѤΤ
 *CPU_BITMAP_SEARCHޥʤ
 */

#endif /* _CPU_INSN_H_ */
