/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2004 by SEIKO EPSON Corp, JAPAN
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 */
#include	"smcvals.h"
#include	"stdio.h"
#include	"cpu_rename.h"

FILE	_iob[FOPEN_MAX + 1];		/* standard i/o stream */

FILE	*stdin; 			/* standard input */
FILE	*stdout;			/* standard output */
FILE	*stderr;			/* standard error */

int 	errno;				/* error number */

unsigned int  seed; 			/* seed of random value */

unsigned char *ucNxtAlcP;	/* next memory allocate address */
unsigned char *ucBefAlcP;	/* one previous allocated address */
unsigned char *end_alloc;	/* end memory allocate address */

#ifndef DBL_LNG_TYPE

#define DBL_LNG_TYPE

/*  the architecture of double floating point
 *
 *   0 1          11                  31 32                               63 bit
 *   -----------------------------------------------------------------------
 *  | |   exponent  |                    fraction                           |
 *   -----------------------------------------------------------------------
 *
 *  |               |                   |                                   |
 *  |     12bits          20 bits       |             32 bits               |
 *  |            lower word             |            higher word            |
 *
 *         bit    0         sign bit         (  1 bit  )
 *              1 - 11      exponent part    ( 11 bits )
 *             12 - 63      fraction part    ( 52 bits )
 *
 */

typedef union {
		struct {
#ifdef	BIG_ENDIAN
			unsigned long _LL;
			unsigned long _LH;
#else
			unsigned long _LH;
			unsigned long _LL;
#endif
		} st;
	} DBL_LNG;

#endif

DBL_LNG _HUGE;				/* HUGE VALUE */

unsigned char *_STACK_TOP;		/* address of stack top */
unsigned char *_STACK_BOTTOM;		/* address of stack bottom */

long gm_sec;

/*
 * initialize routine
 */

void init_lib()
{

  /* initialize allocate address */
  end_alloc = (unsigned char *)_STACK_TOP;
  ucNxtAlcP = (unsigned char *)(_BOUND((unsigned long)_STACK_BOTTOM));
  ucBefAlcP = (unsigned char *)NULL;

  errno = 0;				/* clear error number */

  seed = 1; 				/* initialize random seed */

  gm_sec = -1;				/* initialize time */

  _HUGE.st._LL = 0x7ff00000;		/* HUGE VALUE */
  _HUGE.st._LH = 0;

/*
 *  INITIALIZE STANDARD STREAMS
 */

  _iob[0]._flg = _UGETN;		/* initialize stdin stream */
  _iob[0]._buf = 0;
  _iob[0]._fd = 0;

  _iob[1]._flg = _UGETN;		/* initialize stdout stream */
  _iob[1]._buf = 0;
  _iob[1]._fd = 1;

  _iob[2]._flg = _UGETN;		/* initialize stderr stream */
  _iob[2]._buf = 0;
  _iob[2]._fd = 2;

  stdin = &_iob[0];
  stdout = &_iob[1];
  stderr = &_iob[2];

}

