/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  Copyright (C) 2004 by SEIKO EPSON Corp, JAPAN
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include "s_services.h"

/*
 *  ޳ߥϥɥΥ٥ֹ
 */
#define INHNO_TIMER		S1C33_INHNO_P16TIMER1B

#define S1C33_P16TIMER_CLOCK	40000000

#ifndef _MACRO_ONLY
/*
 *  ؿλ
 */
extern	ER	ena_int(INHNO);
extern	ER	dis_int(INHNO);

/*
 *  16ӥåȥ1ν
 */
Inline void
hw_timer_initialize(void)
{
	/*
	 *  16ӥåȥ1B ߶ػ
	 */
	dis_int(INHNO_TIMER);

	/*
	 *  16ӥåȥ1B װꥢ
	 */
	(*(s1c33Intc_t *) S1C33_INTC_BASE).bIntFactor[2] |= 0x40;

	/*
	 *  16bit1
	 *
	 *  ޥåON  16ʬ  16ӥåȥ1B  1ms
	 */
	(*(s1c33TimerControl_t *) S1C33_TIMER_CONTROL_BASE).bP16ClkCtrl[1]
		= 0x0b;
	(*(s1c33P16Timer_t *) S1C33_P16TIMER_BASE).stChannel[1].uwComp[1]
		= ((S1C33_P16TIMER_CLOCK * 1) / (16 * 1000));

	/*
	 *  16ӥåȥޥꥻå
	 */
	(*(s1c33P16Timer_t *) S1C33_P16TIMER_BASE).stChannel[1].bControl = 0x02;

	/*
	 *  16ӥåȥ1B ߵ
	 */
	ena_int(INHNO_TIMER);


	/*
	 *  16ӥåȥ1 ư
	 */
	(*(s1c33P16Timer_t *) S1C33_P16TIMER_BASE).stChannel[1].bControl = 0x01;

	return;
}

/*
 *  16ӥåȥ1װΥꥢ
 */
Inline void
hw_timer_int_clear(void)
{
	/*
	 *  16ӥåȥ1B װꥢ
	 */
	(*(s1c33Intc_t *) S1C33_INTC_BASE).bIntFactor[2] |= 0x40;

	return;
}

/*
 *  16ӥåȥ1
 */
Inline void
hw_timer_terminate(void)
{
	/*
	 *  16ӥåȥ1B ߶ػ
	 */
	dis_int(INHNO_TIMER);

	/*
	 *  16ӥåȥ1
	 */
	(*(s1c33P16Timer_t *) S1C33_P16TIMER_BASE).stChannel[1].bControl = 0x00;

	return;
}

#endif /* _MACRO_ONLY  */
#endif /* _HW_TIMER_H_ */
