/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  Copyright (C) 2004 by SEIKO EPSON Corp, JAPAN
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 */

#ifndef	_CPU_INSN_H_
#define	_CPU_INSN_H_

/*
 *  쥸ؿ
 */

/*
 *  ơ쥸(PSR)θͤɽФ
 */
Inline UW
get_psr(void)
{
	UW psr;

	Asm("ld.w %0, %%psr": "=r"(psr));

	return psr;
}

/*
 *  ơ쥸(PSR)θͤѹ
 */
Inline void
set_psr(register UW psr)
{
	Asm("ld.w %%psr, %0": : "r"(psr));
}

/*
 *  åݥ(SP)θͤɽФ
 */
Inline VP
get_sp(void)
{
	VP sp;

	Asm("ld.w %0, %%sp": "=r"(sp));

	return sp;
}

/*
 *  åݥ(SP)θͤѹ
 */
Inline void
set_sp(VP sp)
{
	Asm("ld.w %%sp, %0": : "r"(sp));
}

/*
 *  ץ५(PC)θͤѹ
 */
Inline void
set_pc(VP pc)
{
	Asm("jp %0": "=r"(pc) : "0"(pc));
}

/*
 *  ȥåץ١쥸(TTBR)θͤɽФ
 */
Inline VP
get_ttbr(void)
{
#ifdef __c33std
	return (VP) ((volatile s1c33Bcu_t *) S1C33_BCU_BASE)->ulTtbr;
#else
	VP ttbr;

	Asm("ld.w %0, %%ttbr": "=r"(ttbr));

	return ttbr;
#endif /* __c33std */
}

/*
 *  ǥ塼ΤΥӥåȥޥåץؿ
 *  ӥåȥޥåפβ16ӥåȤѤǲ̥ӥåȤͥ٤б
 */
#ifdef CPU_BITMAP_SEARCH
Inline UINT
bitmap_search(UINT bitmap)
{
	INT offset;
	INT bit;

	Asm("swap %0, %1": "=r"(bitmap): "r"(bitmap));
	Asm("mirror %0, %1": "=r"(bitmap): "r"(bitmap));
	Asm("scan1 %0, %1": "=r"(bit): "r"(bitmap));
	if(bit != 8){
		return bit;
	}

	Asm("sll %0, %1": "=r"(bitmap): "r"(bit));
	offset = bit;
	Asm("scan1 %0, %1": "=r"(bit): "r"(bitmap));

	return offset + bit;
}
#endif	/* CPU_BITMAP_SEARCH */

#endif /* _CPU_INSN_H_ */
