/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  Copyright (C) 2004 by SEIKO EPSON Corp, JAPAN
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 */


/*
 *	ץå¸⥸塼(S1C33)
 */

#include "jsp_kernel.h"
#include "check.h"
#include "task.h"
#include "itron.h"
#include "s1c33.h"
#include "sys_config.h"

/*
 *  CPUå
 */
UINT	tps_OrgIntLevel;

/*
 *  ߥͥȥ
 */
UINT	tps_IntNestCnt;

/*
 *  쥸 
 */
ER	get_Offset(INTNO);
ER	get_BitFlag(INTNO);

/*
 *  ץå¸ν
 */
void
cpu_initialize()
{
	tps_IntNestCnt = 0;			/* ߥͥȥȤν */
	tps_OrgIntLevel = TPS_INIT_INTLEVEL;

	/*
	 *  ߵĥե饰ꤷOSγߤޥ
	 */
	set_psr((TPS_CPULOCK_LEV << 8) | S1C33_PSR_FLAG_IE);

}

/*
 *  ץå¸νλ
 */
void
cpu_terminate()
{

}

/*
 *  ư
 */
void
activate_r(void)
{
	unlock_cpu();
	Asm("xld.w %r0, ext_tsk");		/* ֤ext_tsk */
	Asm("pushn %r0");
	Asm("ld.w %%r6, %0": : "r"(runtsk->tinib->exinf));
	set_pc(runtsk->tinib->task);
}

/*
 *  ǥѥå
 *
 *  dispatchϥƥȡCPUå֤ǸƤӽФ
 *  exit_and_dispatchƱͤͥ뵯ưб뤿
 *  󥿥ƥȡCPUå֤θƤӽФˤб
 *  Ƥ롣
 */
void
dispatch(void)
{
	TCB * task;

	Asm("pushn %r3");
	task = runtsk;
	task->tskctxb.sp = get_sp();
	task->tskctxb.pc = && dispatch_1;	/* gccĥǽѤ */
	Asm("xjp _kernel_exit_and_dispatch");
dispatch_1:
	Asm("popn %r3");
	task = (TCB * volatile) runtsk;
	if ((task->enatex != FALSE) && (task->texptn != 0)) {
		Asm("xjp _kernel_calltex");	/* 㳰ϥɥ鵯ư	*/
	}
}

void
exit_and_dispatch(void)
{
	register UW	ulPsr;

	lock_cpu();			/* CPUå	*/
	runtsk = schedtsk;
	if (runtsk != NULL) {
		set_sp(runtsk->tskctxb.sp);
		set_pc(runtsk->tskctxb.pc);
	}

	set_sp(STACKTOP);			/* ¹Բǽʥʤ	*/
	ulPsr = get_psr();			/* ߤĤƥ٥	*/
	ulPsr |= S1C33_PSR_FLAG_IE;	/* ȯԤ					*/
	set_psr(ulPsr);
	unlock_cpu();

	while (1) {
		Asm("halt");
	}
}

/*
 *  ߥϥɥ/CPU㳰ϥɥи
 */
void
ret_int(void)
{
	static	TCB * task;

	reqflg = FALSE;
	task = runtsk;

	if (task == NULL) {			/* ɥإפ */
		Asm("xjp _kernel_exit_and_dispatch");
	}

	if ((enadsp != FALSE) && (task != schedtsk)) {
#ifndef	__c33adv
		Asm("pushn %r1");
#endif	/* __c33adv */
		task->tskctxb.sp = get_sp();
		task->tskctxb.pc = && ret_int_2;/* gccĥǽ */
						/* ǥѥåإ */
		Asm("xjp _kernel_exit_and_dispatch");
ret_int_2:
#ifndef	__c33adv
		Asm("popn %r1");
#endif	/* __c33adv */
	}
	task = (TCB * volatile) runtsk;
	if ((task->enatex != FALSE) && (task->texptn != 0)) {
		call_texrtn();			/* 㳰ϥɥ鵯ư	*/
	}
#ifdef	__c33adv
	Asm("pops %sor");
#else	/* __c33adv */
	Asm("ld.w %alr, %r1");
	Asm("ld.w %ahr, %r0");
#endif	/* __c33adv */

#if TPS_DAREA_CNT == 4				/* ǡꥢݥ󥿿	*/
	Asm("popn %r11");			/* popԤ		*/
#elif TPS_DAREA_CNT == 3
	Asm("popn %r12");
#elif TPS_DAREA_CNT == 2
	Asm("popn %r13");
#elif TPS_DAREA_CNT == 1
	Asm("popn %r14");
#else
	Asm("popn %r15");
#endif /* TPS_DAREA */

	Asm("reti");				/* CPUå֤	*/
						/* Υӥ뤫	*/
						/* ꥿󤹤˲	*/
}


/*
 *  ߥ٥ѹ
 */
ER
chg_ilv(ILEVNO ilevno)
{
	UW	ulPsr;
	ER	ercd;

	LOG_CHG_ILV_ENTER(ilevno)
	CHECK_TSKCTX_UNL();
	if(ilevno > TPS_INTLEV_MAX){
		ercd = E_PAR;
	} else {
		ulPsr = get_psr();			/* ߤPSRͤ	*/
		ulPsr = (ulPsr & ~S1C33_PSR_MASK_IL) | (ilevno << 8);
		set_psr(ulPsr);				/* PSRͤ򹹿		*/
		ercd = E_OK;
	}
exit:
	LOG_CHG_ILV_LEAVE(ercd)				/* Set New IL		*/
	return(ercd);
}

/*
 *  ߥ٥
 */
ER
get_ilv(ILEVNO *p_ilevno)
{
	UW	ulPsr;
	ER	ercd;

	LOG_GET_ILV_ENTER(p_ilevno)
	CHECK_TSKCTX_UNL();
	if(p_ilevno == NULL){
		ercd = E_PAR;
	} else {
		ulPsr = get_psr();			/* ߤγߥ٥ */
		*p_ilevno = (ulPsr & S1C33_PSR_MASK_IL) >> 8;
		ercd = E_OK;
	}
exit:
	LOG_GET_ILV_LEAVE(ercd, piLevno)
	return(ercd);
}

#ifndef __c33pe
/*
 *  ȯĽ
 */
ER
ena_int(INTNO intno)
{
	INT	iOffset, iBitFlag;

	iOffset = get_Offset(intno);			/* 쥸֤ */
	iBitFlag = get_BitFlag(intno);

	if(iOffset == E_PAR || iBitFlag == E_PAR){
		return (E_PAR);
	}
							/* ߤĤ */
	(*(s1c33Intc_t *) S1C33_INTC_BASE).bIntEnable[iOffset] |= (UB)iBitFlag;

	return (E_OK);
}

/*
 *  ȯػ߽
 */
ER
dis_int(INTNO intno)
{
	INT	iOffset, iBitFlag;

	iOffset = get_Offset(intno);			/* 쥸֤  */
	iBitFlag = get_BitFlag(intno);

	if(iOffset == E_PAR || iBitFlag == E_PAR){
		return (E_PAR);
	}
							/* ߤػߤ */
	(*(s1c33Intc_t *) S1C33_INTC_BASE).bIntEnable[iOffset] &= ~((UB)iBitFlag);

	return (E_OK);
}

/*
 *  ȯװꥢ
 */
ER
clr_int(INTNO intno)
{
	INT	iOffset, iBitFlag;

	iOffset = get_Offset(intno);			/* 쥸֤ */
	iBitFlag = get_BitFlag(intno);

	if(iOffset == E_PAR || iBitFlag == E_PAR){
		return (E_PAR);
	}
#ifdef	__c33adv
	if(intno > S1C33_INHNO_SERIAL3TX){		/* /ػߥ쥸װ    */
		iOffset -= 0x0d;			/* ե饰쥸Υեå */
	}						/* ֤פʤ       */
#endif /* __c33adv */
							/* װ򥯥ꥢ */
	(*(s1c33Intc_t *) S1C33_INTC_BASE).bIntFactor[iOffset] = ((UB)iBitFlag);

	return (E_OK);
}
#else  /* __c33pe */
#error "*_int() are valid for C33 Standard/Advanced macro."
#endif /* __c33pe */
