/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_config.h,v 1.2 2004/10/07 17:10:56 honda Exp $
 */

/*
 *	ץå¸⥸塼PowerPCѡ
 *ͥǻѤ
 *ǡޥؿΥץȥ
 *
 *  Υ󥯥롼ɥեϡt_config.h Τߤ饤󥯥롼ɤ롥
 *  ¾Υե뤫ľܥ󥯥롼ɤƤϤʤʤ
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *  ͥ̾Υ͡
 */
#include <cpu_rename.h>

/*
 *  PowerPCץå쥸
 */
#include <powerpc.h>


/*
 *  ץåü̿Υ饤ؿ
 */
#ifndef _MACRO_ONLY
#include <cpu_insn.h>
#endif /* _MACRO_ONLY */


/*
 *  TCB ΥեɤΥӥå
 *
 *  cpu_context.h 쥬ȤȤΰ¸δطǡ
 *  cpu_context.h ˤʤ
 */
#define	TBIT_TCB_TSTAT		8	/* tstat եɤΥӥå */
#define	TBIT_TCB_PRIORITY	8	/* priority եɤΥӥå */

/*
 *  åɬפʥޡ
 *  
 *  PowerPC EABIǵꤵƤ륳󥰡٥󥷥ǤϴؿƤ
 *  ФΥե졼ॹåݥ󥿤ؤƤ8Х(sp+4)
 *  (sp+7)Ϥ˸ƤФ줿¦ξ򤵤롣Τᡢ֥롼
 *  󤫤C롼ƤӽФսä˳ߥȥ¸
 *  ˤǤդɬפǤ롣
 *  Ūˤϰʲβս꤬롣
 *   (1) ȥåץ롼
 *   (2) ư
 *     (2-1) 㳰롼ư
 *   (3) ߥϥɥ鵯ư
 *   (4) CPU㳰롼ư
 *  
 *  åӤ
 *  
 *   ؿƤӽФsp  ---------------------- 
 *              |                      |
 *           +4  ----------------------
 *              |                      |C롼θƤӽФ
 *           +8  ----------------------   ˤ񤭹ޤ
 *  
 *  
 *  64ӥåȲκݤˤդɬפǤ롣
 *  
 */
#define STACK_MARGIN	8


#ifndef _MACRO_ONLY
/*
 *  ƥȥ֥å
 *sp4ХȶǤ뤳Ȥ뤿ᡢ
 *UW*Ƥ롣
 */

typedef struct task_context_block {
        UW	*sp;            /* åݥ */
        FP	pc;             /* ץ५ */
} CTXB;

/*
 *  ƥֻ
 */

/*
 *  ƥȻ
 *  
 *    
 *    TRUE 󥿥ƥ
 *    FALSEƥ
 *
 *SPRG0ߥͥȥ󥿤ѤƤ
 *  ߥͥȥ󥿤ɤ߽Фľ˳ߤȯƤ⡢
 *  äȤˤϥƥȤ⸵äƤ
 *
 */
Inline BOOL
sense_context()
{
    UW intnest;
    
    intnest = current_sprg0();    	/*  intnest  SPRG0  */
    return(intnest > 0);
}

/*
 *  CPUåֻ
 *  
 *    
 *    TRUE CPUå
 *    FALSECPUå
 *
 *  MSRɤ߽Фľ˳ߤȯƤ⡢äȤˤ
 *  MSR⸵äƤ
 *
 */
Inline BOOL
sense_lock()
{
    return(!(current_msr() & MSR_EE));
}

#define t_sense_lock    sense_lock
#define i_sense_lock    sense_lock



/*
 *  CPUåȤβ
 *
 *  MSREEӥåȤCPUå¸Ƥ롣
 *  ߥޥϳߥȥˤ롣
 *  ػߤȳߥޥΩƤ뤿ᡢ
 *  ñ˼Ǥ롣
 */

/*  ƥ  */
#define t_lock_cpu      disint      /*  cpu_insn.h  */
#define t_unlock_cpu    enaint      /*  cpu_insn.h  */

/*  󥿥ƥ  */
#define i_lock_cpu      disint      /*  cpu_insn.h  */
#define i_unlock_cpu    enaint      /*  cpu_insn.h  */


/*
 *  ǥѥå
 */

/*
 *  ǹ̥ͥؤΥǥѥåcpu_support.S
 *
 *  dispatch ϡƥȤƤӽФ줿ӥ
 *  ǡCPUå֤ǸƤӽФʤФʤʤ
 */
extern void	dispatch(void);

/*
 *  ߤΥƥȤΤƤƥǥѥåcpu_support.S
 *
 *  exit_and_dispatch ϡCPUå֤ǸƤӽФʤФʤʤ
 */
extern void	exit_and_dispatch(void);

/*
 *  ߥϥɥ顿CPU㳰ϥɥ
 */

/*
 *  ߥϥɥεơ֥
 */
extern FP int_table[];

/*
 *  㳰٥εơ֥
 */
extern FP exc_table[];


Inline void
define_inh(INHNO intno, FP inthdr)
{
    int_table[intno] = inthdr;

#ifdef GDB_STUB     /*  α  */

#endif
}

/*
 *   CPU㳰ϥɥ
 */

Inline void
define_exc(EXCNO excno, FP exchdr)
{
    exc_table[excno] = exchdr;

#ifdef GDB_STUB     /*  α  */

#endif
}


/*
 *  ߥϥɥνޥ
 */

#define INTHDR_ENTRY(inthdr)  extern void inthdr(void)

#define INT_ENTRY(inthdr) inthdr

/*
 *  CPU㳰ϥɥνޥ
 *
 */
#define EXCHDR_ENTRY(exchdr)  extern void exchdr(VP sp)

#define EXC_ENTRY(exchdr)     exchdr

/*
 *  CPU㳰ȯΥƥ֤λ
 */

/*
 *  CPU㳰ȯΥƥȽ
 *  
 *    
 *    TRUE CPU㳰ȯ󥿥ƥ
 *    FALSECPU㳰ȯ˥ƥ
 *
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
    UW  intnest;
    
    intnest = current_sprg0();    	/*  intnest  SPRG0  */

    /*
     * ӤΤϡ߼¹CPU㳰ʬ
     * ߥͥȥ󥿤󥯥ȤƤ뤿
     */
    return(intnest > 1);
}


/*
 * 㳰ϥɥΰp_excinfؤϤ
 * SSR1쥸ޤǤΥեå
 * 
 * MSRΥԡSSR1쥸ϡå(OFFSET_SSR1+1)ܤ
 * ѤޤƤ롣
 * support.SSAVE_GPR0_12_SPRG򻲾 
 */
#define OFFSET_SSR1	12

/*
 *  CPU㳰ȯCPUå֤λ
 *  
 *    
 *    TRUE CPU㳰ȯCPUå
 *    FALSECPU㳰ȯCPUå
 *  
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
    UW  ssr1;

    ssr1 = *((volatile UW *)p_excinf + OFFSET_SSR1);
    return( !(ssr1 & MSR_EE) );
}

/*
 *  ץå¸ν
 */
extern void cpu_initialize(void);

/*
 *  ץå¸νλ
 */
extern void cpu_terminate(void);

/*
 *  ΥϻΥå¤
 */
typedef struct exc_stack {
	UW	r0;
	UW	r3;
	UW	r4;
	UW	r5;
	UW	r6;
	UW	r7;
	UW	r8;
	UW	r9;
	UW	r10;
	UW	r11;
	UW	r12;
	UW	srr0;	/*   쥸0*/
	UW	srr1;	/*   쥸1*/
	UW	lr;	/*   󥯡쥸 	*/
	UW	ctr;	/*   ȡ쥸	*/
	UW	cr;	/*   ǥ󡦥쥸 	*/
	UW	xer;	/*   ڥ졼ξＱ̥쥸*/
			/*  ʥ꡼䥪Хեʤɡ  */
	UW	exc_no;	/*   㳰ֹ 	*/
} EXCSTACK;

/*  åΥǡɽ  */
void syslog_data_on_stack(EXCSTACK *sp);

/*
 * ϿƤʤ㳰ȯΥ (cpu_config.c)
 */
extern void no_reg_exception(EXCSTACK *);



#endif /* _MACRO_ONLY */
#endif /* _CPU_CONFIG_H_ */

/*  end of file  */
