/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_insn.h,v 1.3 2004/09/03 17:32:25 honda Exp $
 */

#ifndef	_CPU_INSN_H_
#define	_CPU_INSN_H_

#include <nios2.h>

Inline UW
current_status(void)
{
    UW status;
    Asm("rdctl %0, status" : "=r" (status));
    return(status);
}

Inline UW
current_estatus(void)
{
    UW status;
    Asm("rdctl %0, estatus" : "=r" (status));
    return(status);
}

Inline UW
current_bstatus(void)
{
    UW status;
    Asm("rdctl %0, bstatus" : "=r" (status));
    return(status);
}

Inline UW
current_ipending(void)
{
    UW status;
    Asm("rdctl %0, ipending" : "=r" (status));
    return(status);
}

Inline UW
current_ienable(void)
{
    UW status;
    Asm("rdctl %0, ienable" : "=r" (status));
    return(status);
}

Inline void
set_status(UW status)
{
    Asm("wrctl status, %0" :: "r" (status));
}

Inline void
set_ienable(UW ienable)
{
    Asm("wrctl ienable, %0" :: "r" (ienable));
}

Inline void
disint(void)
{
    set_status(current_status() & ~STATUS_PIE);
}

Inline void
enaint()
{
    set_status(current_status() | STATUS_PIE);    
}

#endif /* _CPU_INSN_H_ */
