/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#ifndef _RTE_VR5500_CB_
#define _RTE_VR5500_CB_

#define RTE_VR5500_CB

/*
 *  ǥХγƥ١ɥ쥹
 */

/* ꥢ륳ȥ (TL16PIR552) */
#define UART_CH01	0xb9001000
#define UART_CH02	0xb9002000
#define PRINTER_PPCS	0xb9003000
#define PRINTER_ECPCS	0xb9004000

/*  (uPD71054) */
#define TIMER_BASE_ADDR	0xb9005000

/* ߥȥ(PIC) */
#define ICU_BASE_ADDR	0xb9000000

/*
 *  ǥХ˶뤵륯å
 */
/* ꥢ˶뤵륯åȿ [Hz]ʥܡ졼ǻѡ
 * 16MHz = 16000000 Hz ; ܡɤΥޥ˥奢p21ȡ */
#define XIN_CLOCK	16000000u

/* ޤ˶뤵륯åȿ [kHz]
 *TO_CLOCK 1ߥü(1kHz)ȯ뤿˻ѡ
 * (2MHz = 2000kHz ; ܡɤΥޥ˥奢p22) */
#define TIMER_CLOCK	2000u

/*
 *  ǥХγߥޥ
 *
 *  ͥ : () ꥢ룱 -> ꥢ룰 -> ޣ ()
 */

/*
 *  ꥢ룰ߤγߥޥѡ
 *  ߥ٥Ʊ٥ꤷƤ
 */
#define CORE_IPM_SCC		INIT_CORE_IPM	/* MIPS3(SR)ѥǡ */

#define ICU_IPM_INT0_SCC0	TIMER0		/* ߥȥѥǡ */
#define ICU_IPM_INT1_SCC0	0u

/*  ꤹߥޥIPMǵҤ */
#define IPM_SCC0	{ CORE_IPM_SCC, {ICU_IPM_INT0_SCC0, ICU_IPM_INT1_SCC0} }

/*
 *  ꥢ룱ߤγߥޥѡ
 *  ߥ٥Ʊ٥ꤷƤ
 *  MIPS3ѤΥǡϡSCC0ȶ
 */
#define ICU_IPM_INT0_SCC1	(TIMER0 | SERIAL0) /* ߥȥѥǡ */
#define ICU_IPM_INT1_SCC1	0u

/*  ꤹߥޥIPMǵҤ */
#define IPM_SCC1	{ CORE_IPM_SCC, {ICU_IPM_INT0_SCC1, ICU_IPM_INT1_SCC1} }

/*
 *  ޣߤγߥޥ
 *  ܼǤϡ޳ߤäȤϡƤγߤػߤƤ롣
 */
#define CORE_IPM_TIMER		INIT_CORE_IPM	/* MIPS3(SR)ѥǡ */

#define ICU_IPM_INT0_TIMER0	0u		/* ߥȥѥǡ */
#define ICU_IPM_INT1_TIMER0	0u

/*  ꤹߥޥIPMǵҤ */
#define IPM_TIMER0	{ CORE_IPM_TIMER, {ICU_IPM_INT0_TIMER0, ICU_IPM_INT1_TIMER0} }

#endif /* _PIC_ICU_H_ */
