/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#define _MACRO_ONLY

#include "jsp_kernel.h"		/* INIT_SR */

/*
 *   MIPS3ѥȥåץ⥸塼
 *     ꥻåȥ٥  0xbfc00000Ϥ
 *   
 *   ͥϥץꥱȥ󥯤ƻѤʤΤ
 *   JSPͥΤ߻Ѥ롣
 */

	.section ".reset","xa"

	.set noreorder

	.align 2
	.global	reset

reset:
	/*
	 *  CPU쥸ν
	 */

	/* HI, LO (쥸) */
	mthi	zero
	mtlo	zero

	/* sp (åݥ󥿡󥿥ƥ)
	     _stack_top ϡƥ¸(󥫥ץȿ侩) */
	la	sp, _stack_top

	/* gp (Хݥ)
	     _gp ϡƥ¸(󥫥ץȿ侩) */
	la	gp, _gp

	/* k0 (/CPU㳰ͥȥ) */
	li	k0, 0x1		/* ưޤǤϡ󥿥ƥȤǤ
				   ¹ԤȤߤʤ */
	/* k1ϡѤȤѤƤΤǽʤ */

	/*
	 *  CP0쥸ν
	 */

	/* SR (ơ쥸)
	     (ǥγߥޥꤹ롣ϡ¼Ūʳϡ
	     ߥȥǹԤᡣ)
	     INIT_SR ϡsys_config.h  */
	li	t0, INIT_SR
	mtc0	t0, Status

	/* Config (ե쥸)
	     INIT_CONFIG_MASK ϡsys_config.h  */
	mfc0	t0, Config
	li	t1, INIT_CONFIG_MASK
	or	t0, t0, t1
	mtc0	t0, Config

	/* WatchLo (åLo쥸) */
	mtc0	zero, WatchLo

	/* Compare (ӥ쥸) */
	li	t0, 0xffffffff
	mtc0	t0, Compare

	/*
	 *  hardware_init_hook ƤӽФ(0Ǥʤ)
	 *
	 *  åȥϡɥ˰¸ϡ
	 *    hardware_init_hook ȤؿѰդ롥
	 *      ROMκݡRAMѲǽˤ뤿ΥХȥν
	 *    ϡsys_support.S  hardware_init_hook Ƥ롥
	 */
hardware_init:
	la	t0, hardware_init_hook
	beq	t0, zero, bss_clear
	nop
	jalr	ra, t0
	nop

	/*
         * bss򥯥ꥢ
	 */
bss_clear:
	la	t1, __bss_start
	la	t2, __bss_end
	beq	t1, t2, data_sec_copy
	nop
        sw	zero, (t1)
loop_bss_clear:
        addi	t1, t1, 4
        sub	t3, t2, t1
        bgez 	t3, loop_bss_clear
        sw	zero, (t1)

	/*
	 *  data (ROMб)
	 *
	 *  __idata_start  __idata_end ޤǤ__data_start ʹߤ˥ԡ
	 */
data_sec_copy:
	la	t1, __idata_start
	la	t2, __idata_end
	beq	t1, t2, software_init
	nop
	la	t3, __data_start
loop_data_sec_copy:
	lw	t5, (t1)
        sw	t5, (t3)
        addi	t1, t1, 4
        addi	t3, t3, 4
        sub	t4, t2, t1
        bgtz 	t4, loop_data_sec_copy
	nop

	/*
	 *  software_init_hook ƤӽФ0 Ǥʤ
	 *
	 *  եȥĶä˥饤֥ˤ˰¸ɬפʽ
	 *  ϡsoftware_init_hook ȤؿѰդ롥
	 */
software_init:
	la	t0, software_init_hook
	beq	t0, zero, start_kernel
	nop
	jalr	ra, t0
	nop

	/*
         *  ͥư
	 */
start_kernel:
	la	t0, kernel_start
	j	t0
	nop
