/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#define _MACRO_ONLY

#include "jsp_kernel.h"

	.section ".exce_vec_map","xa"
		/* exce_vec_map εҤϡ1kbyte˼
		   ȡ(0xbfc00000-0xbfc00400 ϰ)
		   ϡ0xbfc00400 ΰˡinit 
		   ʤӤ text 󤬵Ҥ뤿ᡣ*/

	.set noreorder

	.align 2

/*
 *  㳰٥ɥ쥹Ǥʬ (BEV=1)
 */

/*
 *  ɥꥻåȡեȥꥻåȡNMI(Non Maskable Interrupt)
 *     ơ쥸BEVӥåȤ
 *         ¸ʤ0xbfc00000  (kseg1ΰ表åʤ)
 */

	.global start	/* ȥ꡼ݥ */

start:
reset_and_NMI:
	mfc0	k0, Status
	li	k1, SR_SR
	and	k1, k0, k1
	bne	k1, zero, NMI_exception
	nop

	/* ɥꥻåȻ */
	la	k1, reset
	jr	k1
	nop

	/* եȥꥻåȡNMI  */
NMI_exception:
	la	k1, reset
	jr	k1
	nop

/*
 *  TLB԰㳰JSPͥǤTLB̤ѡ
 *      ơ쥸BEVӥåȤ
 *          1ΤȤ0xbfc00200  (kseg1ΰ表åʤ)
 *          0ΤȤ0x80000000  (kseg0ΰ表å夢)
 */
	.org 0x200

TLB_miscompare_exception:
	move	a0, sp
	mfc0	a1, Status
	mfc0	a2, Cause
	la	k1, cpu_experr
	jr	k1
	nop

/*
 *  XTLB԰㳰JSPͥǤTLB̤ѡ
 *      ơ쥸BEVӥåȤ
 *          1ΤȤ0xbfc00280  (kseg1ΰ表åʤ)
 *          0ΤȤ0x80000080  (kseg0ΰ表å夢)
 */
	.org 0x280

XTLB_miscompare_exception:
	move	a0, sp
	mfc0	a1, Status
	mfc0	a2, Cause
	la	k1, cpu_experr
	jr	k1
	nop

/*
 *  å奨顼㳰
 *      ơ쥸BEVӥåȤ
 *          1ΤȤ0xbfc00300  (kseg1ΰ表åʤ)
 *          0ΤȤ0xa0000100  (kseg0ΰ表å夢)
 */
	.org 0x300

cashe_error_exception:
	move	a0, sp
	mfc0	a1, Status
	mfc0	a2, Cause
	la	k1, cpu_experr
	jr	k1
	nop

/*
 *  ¾㳰㳰/߽롼
 *  (MIPSƥϳߥ٥ơ֥ߤ㳰
 *   Ȥʬ)
 *      ơ쥸BEVӥåȤ
 *          1ΤȤ0xbfc00380  (kseg1ΰ表åʤ)
 *          0ΤȤ0x80000180  (kseg0ΰ表å夢)
 */

	.org 0x200 + 0x180	/* TLB԰㳰0x180ϸ */

other_exception:
	la	k1, general_exception
	jr	k1
	nop
