/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2007 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 

 *  @(#) $Id: start.S,v 1.10 2007/05/30 03:56:47 honda Exp $
 */

#define _MACRO_ONLY

#include <m32rasm.inc>
#include <s_services.h>
		
/*
 *  ȥåץ롼 
 */
	.text
	.align 4
	.globl start

start:
	.extern		kernel_start
	.extern		hardware_init_hook
	.extern		software_init_hook
	.extern 	reset

	/* pswν */
	ldi		r0, 0	
	mvtc	r0, psw

	/* ߥåݥ󥿤ν */
	lea		r15, __stack
	
	/* EIT١쥸 */
	lea		r0, reset
	mvtc	r0, cr5

	/* ϡɥ롼εư */
	lea		r0, hardware_init_hook
	beqz	r0, L1
	jl		r0

L1:
	/* .bssΥꥢ */
	xor		r0, r0
	lea		r1, __sbss
	lea		r2, __ebss
	beq		r1, r2, L3
L2:
	st		r0, @-r2
	bne		r1, r2, L2

L3:
	/* .dataν */
	lea		r1, __sidata
	lea		r2, __eidata
	lea		r3, __sdata

	addi	r3, -4
	beq		r1, r2, L5
L4:	ld		r0, @r1+
	st		r0, @+r3
	bne		r1, r2, L4

L5:
	/* եȥ롼εư */
	lea		r0, software_init_hook
	beqz	r0, L6
	jl		r0

L6:
	/* ߥޥ */
	ld24 	r0, ICUIMASK + 1
	ldi 	r1, 7				/* ٤Ƥγ׵դ */
	stb 	r1, @r0 			

	/* ͥ뵯ư */
	bl		kernel_start

L7:	bra		L7
