/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sys_defs.h,v 1.2 2007/05/28 02:03:55 honda Exp $
 */

/*
 *  åȥƥ˰¸m3a_za36/10MHz
 */

#ifndef _SYS_DEFS_H_
#define _SYS_DEFS_H_

#define m3a_za36

/*
 *  ޥåץɥ쥸
 */

/* ߴϢΥ쥸 */
#define ICUISTS		0xeff004
#define ICUIREQ0	0xeff008
#define ICUIREQ1	0xeff00c
#define ICUSBICR	0xeff018
#define ICUIMASK	0xeff01c

#define __ICUCR(x)	ICUCR_##x
#define _ICUCR(x)	__ICUCR(x)
#define ICUCR_INT	0xeff200
#define ICUCR_MFT	0xeff23c
#define ICUCR_SIO	0xeff2bc
#define ICUCR(x,y)	(_ICUCR(x) + (0x4*y))

/* ޴Ϣ쥸 */
#define MFTCR			0xefc000
#define MFTRPR			0xefc004
#define MFTMOD(x)		(0xefc100 + ((x) * 0x100))
#define MFTBOS(x)		(0xefc104 + ((x) * 0x100))
#define MFTCUT(x)		(0xefc108 + ((x) * 0x100))
#define MFTRLD(x)		(0xefc10c + ((x) * 0x100))
#define MFTMCMPRLD(x)	(0xefc110 + ((x) * 0x100))

/* ꥢϢ쥸 */
#define SIOCR(x)	(0xefd000 + ((x) * 0x100))
#define SIOMOD0(x)	(0xefd004 + ((x) * 0x100))
#define SIOMOD1(x)	(0xefd008 + ((x) * 0x100))
#define SIOSTS(x)	(0xefd00c + ((x) * 0x100))
#define SIOTRCR(x)	(0xefd010 + ((x) * 0x100))
#define SIOBAUR(x)	(0xefd014 + ((x) * 0x100))
#define SIORBAUR(x)	(0xefd018 + ((x) * 0x100))
#define SIOTXB(x)	(0xefd01c + ((x) * 0x100))
#define SIORXB(x)	(0xefd020 + ((x) * 0x100))

/* ץޥ֥I/OݡȴϢ쥸 */
#define PIEN		0xef1000
#define PDATA(x)	(0xef1020+(x))
#define PDIR(x)		(0xef1040+(x))
#define PMOD(x)		(0xef1060+((x)*2))
#define PODCR(x)	(0xef1080+((x)*2))

/* Хȥ */
#define BSELCR(x)	(0xef5000 + ((x)*4))

/* SDRAMȥ */
#define SDRF0		0xef6000
#define SDRF1		0xef6004
#define SDIR0		0xef6008
#define SDIR1		0xef600c
#define SDBR		(0xef6010)
#define SDADR(x)	(0xef6020 + ((x)*32))
#define SDER(x)		(0xef6024 + ((x)*32))
#define SDTR(x)		(0xef6028 + ((x)*32))
#define SDMOD(x)	(0xef602c + ((x)*32))

/* CPUư⡼ɴϢΥ쥸 */
#define CPUCLKCR	0xef4000
#define CLKMOD		0xef4004
#define PLLCR		0xef4008

#ifndef _MACRO_ONLY

/*
 *  INTNOȳߤζػ/
 */
typedef	unsigned char INTNO;		/* ֹ */

/*
 *  åȥƥ¸Υӥ
 */
typedef	unsigned long SYSUTIM;	/* ǽɾѥƥ */

Inline void kernel_abort(void)
{
    extern void _kernel_sys_exit(void);
    _kernel_sys_exit();
}

extern ER	vxget_tim(SYSUTIM *pk_sysutim);

#endif /* _MACRO_ONLY */

/*
 *  ƥå
 */
#define	TIC_NUME	1		/* ƥåμʬ */
#define	TIC_DENO	1		/* ƥåμʬ */

#endif /* _SYS_DEFS_H_ */
