/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2006 by Monami Software Limited Partnership, JAPAN	
 *  Copyright (C) 2007 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_support.S,v 1.12 2007/05/30 03:56:47 honda Exp $
 */

/*
 *	ץå¸⥸塼 ֥M32Rѡ
 */

#define	_MACRO_ONLY

#include <cpu_rename.h>

#include <m32rasm.inc>
#include <s_services.h>

#include "offset.h"

#define _trap_handler_0 _kernel__trap_handler_0
#define _trap_handler_1 _kernel__trap_handler_1
#define _trap_handler_2 _kernel__trap_handler_2
#define _trap_handler_3 _kernel__trap_handler_3
#define _trap_handler_4 _kernel__trap_handler_4
#define _trap_handler_5 _kernel__trap_handler_5
#define _trap_handler_6 _kernel__trap_handler_6
#define _trap_handler_7 _kernel__trap_handler_7
#define _trap_handler_8 _kernel__trap_handler_8
#define _trap_handler_9 _kernel__trap_handler_9
#define _trap_handler_10 _kernel__trap_handler_10
#define _trap_handler_11 _kernel__trap_handler_11
#define _trap_handler_12 _kernel__trap_handler_12
#define _trap_handler_13 _kernel__trap_handler_13
#define _trap_handler_14 _kernel__trap_handler_14
#define _trap_handler_15 _kernel__trap_handler_15

	.extern	_kernel_runtsk
	.extern	_kernel_schedtsk
	.extern	_kernel_reqflg
	.extern _kernel_enaflg
	.extern	InterruptHandlerEntry
	.extern	ExceptionHandlerEntry
	.extern	ext_tsk
		
/*
 *  EIT٥ȥ
 */
	.section ".vector","ax"
	.global	  reset
	.extern   start

	.balign 0x10
reset:
	bra		start

	.balign 0x10
vector_entry_SBI:
    /* 
	 *  ƥ֥졼
	 */
	bra 	vector_entry_SBI

	.balign 0x10
vector_entry_RIE:
    /* 
	 *  ͽ̿㳰Reserved Instruction Exception
	 */
	stmdb	"r0,r1"
	ldi		r1, #(EXC_RIE*4-4)
	bra		_exception_handler

	.balign 0x10
vector_entry_AE:
    /* 
	 *  ɥ쥹㳰Address Exception
	 */
	stmdb	"r0,r1"
	ldi		r1, #(EXC_AE*4-4)
	bra		_exception_handler

	.balign 0x10
vector_entry_trap:
    /*
	 *  ȥåץ٥ȥ
	 */
	bra		_trap_handler_0
	bra		_trap_handler_1
	bra		_trap_handler_2
	bra		_trap_handler_3
	bra		_trap_handler_4
	bra		_trap_handler_5
	bra		_trap_handler_6
	bra		_trap_handler_7
	bra		_trap_handler_8
	bra		_trap_handler_9
	bra		_trap_handler_10
	bra		_trap_handler_11
	bra		_trap_handler_12
	bra		_trap_handler_13
	bra		_trap_handler_14
	bra		_trap_handler_15

/*
 *  ߥ٥ȥȳߥϥɥ鵯ư
 *
 *  ȯΥϡɥư
 *
 *  psw쥸smiepmcӥåȤbsmbiebpmbcӥåȤ
 *  롥bpcˤϳȯpcͤ롥
 *
 *	bsm <- sm
 *  bie <- ie
 *  bpm <- pm
 *  bc <- c
 *  bpc <- ȯpc
 *
 *	psw쥸smiepmcӥåȤʲΤ褦˹롥
 *
 *	sm <- 0
 *  ie <- 0
 *  pm <- 0
 *  c <- 0
 *
 *쥸Ѥ
 *  r0-r1ʺΰ
 *  r0-r7r14acc(hi/lo)bpcpswICUISTSpswʳߥϥɥƽ
 *  
 *  ܤpswʳϡȯΥƥȤбå
 *  򤹤롥2ܤpswϡߥϥɥμ¹ľ뤿ˡ
 *  ɬߥå򤹤롥ٱǥѥåˤϡ嵭
 *  쥸ʳˤ⡤r8-r13򤷤ƥǥѥåƤӽФ
 */
	.balign 0x10
interrupt_handler:

	/* 
	 *  ѥ쥸 
	 *
	 *  ǽ˺ѥ쥸򥹥å򤹤롥ȯľϡɬ
	 *  ߥåˤʤΤǡ򤹤ѥ쥸ϳ
	 *  ߥåѤޤ롥
	 */
	stmdb	"r0,r1"

	/* 
	 *  ȯΥƥȽ
	 *
	 *  pswbsmӥåȤȯ˻ѤƤå
	 *  롥bsm0ξϡߥåѤƤȤˤʤ
	 *  ǡߥƥȤǳߤȯȽǤ롥bsm1ξ
	 *  ϡ桼åѤƤȤˤʤΤǡ
	 *  ȤǳߤȯȽǤ롥Ԥξϡΰr0
	 *  r1ˤѤľɬפʤ
	 */
	mvfc	r0, psw
	and3	r1, r0, 0x8000
	beqz	r1, L1

	/* 
	 *  쥸Υ桼åؤѤľ  
	 *
	 *  ƥȤǳߤȯϡߥå
	 *  򤷤ѥ쥸r0r1桼åѤľɬפ롥
	 */

	or3		r0, r0, 0x80		
	mvtc	r0, psw				/* 桼åءsp = spu */

	mvfc	r1, spi
	ld		r0, @(4, r1)		/* 򤷤r0ߥåФ */
	st		r0, @-sp			/* r0桼åѤ */
	ld		r0, @r1				/* 򤷤r1ߥåФ */
	st		r0, @-sp			/* r1桼åѤ */
	addi	r1, 8				/* ߥåȥå᤹ */
	mvtc	r1, spi				/* ߥå֤spi¸ */
	mvfc	r0, psw

L1:
	/* 
	 *  ƥȤ
	 * 
	 *  r2-r7, r14, acch, accl, bpc, psw, ߥޥICUISTS,psw
	 *  ν˥å򤹤롥Ǥϡɬpswr0¸Ƥ
	 *  롥
	 */
	stmdb	"r2,r3,r4,r5,r6,r7,r14"
	mvfachi	r1
	st		r1, @-sp			/* acch */
	mvfaclo	r1
	st		r1, @-sp			/* accl */
	mvfc	r1, bpc
	st		r1, @-sp			/* bpc */
	st 		r0, @-sp			/* psw */

	ld24	r1, ICUISTS
	ld		r0, @r1				/* ߥޥɤ߹ߡʳ׵ϥꥢ*/
	st		r0, @-sp			/* ߥޥ */

	lea		r1, InterruptHandlerEntry /* ߥϥɥơ֥Ƭɥ쥹Ф */
	srli	r0, 22				/* װֹ */
	addi	r0, -1				/* ߥϥɥơ֥Υǥå׻ */
	slli	r0, 2				/* ߥϥɥơ֥ΥեåȤ׻ */
	add		r1, r0				/* ߥϥɥơ֥γߥϥɥΥɥ쥹׻ */
	ld		r1, @r1				/* ߥϥɥεưϤФ */

L2:
	/*
	 *  ߥϥɥθƽФ
	 *
	 *  psw򤷡ߥå, ߵĤˤƳߥϥɥ
	 *  ƤӽФߥϥɥ餫Ϥeit_handler_rȤ롥
	 *  ǡpsw򤹤Τϡeit_handler_rκǽǡѤ
	 *  å᤹ɬפ뤿ǡɬߥå򤷤Ƥ
	 *  
	 */
	mvfc	r2, psw						
	and3	r3, r2, 0xff7f				
	mvtc	r3, psw						/* ߥå */
	st		r2, @-sp					/* pswߥå */
	lea		r14, eit_handler_r 			/* Ϥ */
	or3		r3, r3, 0x40				
	mvtc	r3, psw						/* ߵ */
	jmp		r1							/* ϥɥ鵯ư */

	.text
	.align 4
eit_handler_r:
	/*
	 *  EITϥɥ餫
	 *
	 *  EITϥɥμ¹ԤλȸƤӽФ롥ȯΥ
	 *  ƥȡ׵̵ͭǥѥåġػ߾֤顤Ŭ
	 *  ڤԤʤ
	 */
	ld		r0, @sp+
	mvtc	r0, psw			/* ߥåpswEITȯ
							   ΥƥȤ롥ߤ϶ػ߾֡
							    */

	ld24 	r1, ICUIMASK
	ld 		r2, @sp+
	st 		r2, @r1			/* ߥޥ */

	and3	r0, r0, 0x8000
	beqz	r0, recover_int	/* EITȯΥƥȤߥƥ
							   ȤǤС¿ųߤǤȽǤ
							   ¨¤˶ */

	/* 
	 *  ƥȤؤ롼
	 *
	 *  ǥѥå㳰ư׵᤬ʤϡ¨¤˶롼
	 *  ֡ٱǥѥåԤʤǥѥå׵᤬
	 *  ж̤recover_intˤԤʤ
	 */
	lea		r0, _kernel_reqflg
	ld		r1, @r0
	beqz	r1, recover_int		/* 롼 */

	/* 
	 *  ǥѥå㳰ư׵᤬ν
	 *
	 *  ޤǥѥå׵ե饰reqflgˤ򥯥ꥢ롥ơǥ
	 *  ѥåĥե饰enadspˤFALSEξȡruntskschedtsk 
	 *  Ʊˤϡǥѥåˡ㳰ư롼
	 *  ֡ǥѥåĤƤꡤruntskschedtskۤʤ
	 *  ˤϡٱǥѥåԤ
	 */
	ldi		r1, #0
	st		r1, @r0				/* reqflg򥯥ꥢ */

	lea 	r0,  _kernel_enadsp
	ld 		r0, @r0
	beqz 	r0, recover_task 	/* enaflgΥå */

	lea		r0, _kernel_runtsk
	lea		r1, _kernel_schedtsk
	ld		r0, @r0	
    ld		r1, @r1
    beq		r0, r1, recover_task	/* runtskschedtskƱϥ
								       㳰ư */

	/*
	 *  㳰߽иǤٱǥѥå
	 *
	 *  򤷤ƤʤĤΥ쥸򤷡¹Ծ֥pcsp
	 *  򤷤ƤǥѥåƤӽФ
	 */
	stmdb	"r8,r9,r10,r11,r12,r13"

	lea		r0, _kernel_runtsk
	ld		r0, @r0

	lea		r1, recover_task_r
	st		r1, @(TCB_pc, r0)
	st		sp, @(TCB_sp, r0)
	bra		_kernel_exit_and_dispatch

	.align 4
recover_task_r:
	ldmia	"r13,r12,r11,r10,r9,r8"

recover_task:
	/* 
	 *  㳰ư
	 *
	 *  ǡenatexTRUEǡtexptn0ǤʤС㳰롼
	 *  ƤӽФcalltexνơruntsk->enatexTRUEǡ
	 *  runtsk->texptn0Ǥʤˡcall_texrtnƤ֡ˤ򤳤˥
	 *  饤ŸΨɤδʰײΤcalltex 
	 *  ƤӽФ
	 */
	bl		_kernel_calltex

recover_int:
	/* 
	 *  EITͥٳߤؤޤ
	 *
	 *  򤷤֡r2-r7, r14, acch, accl, bpc, pswˤεսǥ
	 *  Ф롥ޤѥ쥸r0r1ˤ
	 *  롥
	 */
	ld 		r0, @sp+
	mvtc 	r0, psw						/* psw */
	ld		r0, @sp+			
	mvtc	r0, bpc						/* bpc */
	ld		r0, @sp+	
	mvtaclo	r0							/* accl */
	ld		r0, @sp+
	mvtachi	r0							/* acchl */
	ldmia	"r14,r7,r6,r5,r4,r3,r2"		/* ¾Υ쥸 */
	ldmia	"r1,r0"						/* ѥ쥸 */
	rte									/* ߽ */

	.section ".vector","ax"
	/*
	 *  ȥåפΥȥ : ȥåֹγǼ
	 */
	.irp num,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15
		.align	4

	_kernel__trap_handler_\num:
		stmdb	"r0,r1"
		ldi		r1, #((\num + EXC_TRAP00 - 1) * 4)
		bra		_exception_handler
	.endr
		
/*
 *  㳰ȥåץϥɥ
 *
 *  㳰ȯˤϡå쥸򤷤㳰װr1
 *  äƤˤб㳰ϥɥƤӽФ㳰ϥɥ餫
 *  ϡߥϥɥ餫ȶ̡eit_handler_rˤǤ롥
 *
 *  㳰ȯΥϡɥư
 *
 *  psw쥸smiepmcӥåȤbsmbiebpmbcӥåȤ
 *  롥bpcˤ㳰򵯤̿pcͤ롥
 *
 *	bsm <- sm
 *  bie <- ie
 *  bpm <- pm
 *  bc <- c
 *  bpc <- 㳰򵯤̿Υɥ쥹
 *
 *	psw쥸smiepmcӥåȤʲΤ褦˹롥
 *
 *	sm <- 
 *  ie <- 0
 *  pm <- 0
 *  c <- 0
 *
 *  쥸Ѥ
 *
 *  r0-r1ʺΰ衤٥κǽ
 *  r2-r7r14acc(hi/lo)bpcpswICUIMASK㳰ϥɥƽ
 *
 *  ǡICUISTSǤϤʤICUIMASK򤹤Τϡ㳰˳
 *  ߤȯˡICUISTSɹߤˤװꥢ
 *  ƤޤΤɤǤ롥
 */
_exception_handler:

	stmdb 	"r2,r3,r4,r5,r6,r7,r14"
	mvfachi r0
	st 		r0, @-sp
	mvfaclo r0
	st 		r0, @-sp
	mvfc 	r0, bpc
	st 		r0, @-sp
	mvfc 	r2, psw
	st 		r2, @-sp
	ld24 	r0, ICUIMASK
	ld 		r0, @r0
	st 		r0, @-sp

	lea		r0, ExceptionHandlerEntry
	add		r0, r1
	ld		r1, @r0				/* 㳰ϥɥΥɥ쥹 */

	mv 		r0, sp				/* åΰ֤㳰ϥɥΰ
								    */
	and3 	r3, r2, 0x7f00
	srli 	r3, 8
	mvtc 	r3, psw 			/* ߥåߵľ֤ */
	st 		r2, @-sp			/* 㳰ȯľpswߥå */
	lea 	r14, eit_handler_r 
	jmp 	r1
				
Function _kernel_dispatch
	/*
	 *  ؤΤ
	 *
	 *  Υ롼ϡƥȡCPUå֡ǥѥ
	 *  ľ֤ǸƤӽФ롥ƽиǤ¸ʤ쥸򥹥
	 *  򤷡pcspTCB򤹤롥pcϥǥѥåи
	 *  dispatch_rˤꤹ롥
	 */
	stmdb	"r8,r9,r10,r11,r12,r13,r14"

	lea 	r0, _kernel_runtsk
	lea		r1, dispatch_r
	ld		r0, @r0
	st		r1, @(TCB_pc, r0)		/* dispatch_r˵äƤ */
	st		sp, @(TCB_sp, r0)		/* åݥ󥿤 */

Function _kernel_exit_and_dispatch
	/*
	 *  ؤ
	 *
	 *  schedtskǤʤå롥schedtskǤʤϡ
	 *  ؤ˰ܤ롥ξϡߤĤƥ롼פ
	 *  ˰ܤ롥
	 */	
	xor		r0, r0
	mvtc	r0, psw						/* ߶ػߡߥå */
	
	lea		r1,  _kernel_schedtsk
L6:	ld		r0, @r1
	bnez	r0, L7						/* schedtsk̵ͭå */

	/* 
	 *  ư٤ʤν
	 *
	 *  ư٤ʤϡߤĤƥ롼פ롥롼
	 *  פǳߤĤ¹ԲǽԤġ
	 */
	ldi		r0, 0x40
	mvtc	r0, psw						/* ߵ */
	xor		r0, r0
	mvtc	r0, psw						/* ߶ػ */

	lea 	r0, _kernel_reqflg
	xor 	r2, r2
	st 		r2, @r0 					/* reqflg = 0 */
	bl 		L6

L7:
    /* 
	 *  ؤ
	 *
	 *  ¹楿runtskˤ˺ǹ̥ͥschedtskˤꤷ
	 *  å桼åؤ롥runtskTCBsppc
	 *  롥Ǥϡr0 = schedtskǤ롥
	 */
	lea		r2, _kernel_runtsk
	st		r0, @r2 					/* runtsk = schedtsk */

	ldi 	r1, 0x80
	mvtc 	r1, psw 					/* 桼å߶ػ */

	ld		sp, @(TCB_sp, r0)			/* åݥ󥿤 */
	ld		r0, @(TCB_pc, r0)			/* ץ५󥿤 */
	jmp		r0

	.align 4
Label dispatch_r
	/* 
	 *  ǥѥåνи
	 * 
	 *  dispatch򤷤쥸㳰롼
	 *  ӽФ
	 */
	bl 		_kernel_calltex 
    ldmia 	"r14,r13,r12,r11,r10,r9,r8" 
	rts

Function _kernel_activate_r
	/*
	 *  εư롼
	 *
	 *  runtskΥ֥å饿ؿȳĥФ
	 *  ơĥ쥸r0ˤꤹ롥ext_tskƤӽФ
	 *  ˥λ礬뤿ᡤؿϤ
	 *  ext_tskꤹ롥ưƴλƤ顤ߤĤ
	 *  ƥؿ֡
	 */
	lea		r2, _kernel_runtsk
	ld		r2, @r2
	ld		r2, @(TCB_tinib, r2)		/* r2 = runtsk->tinib */
	ld		r0, @(TINIB_exinf, r2)
	ld		r1, @(TINIB_task,  r2)

	lea		r14, ext_tsk				/* Ϥext_tsk */

	ldi 	r2, 0xc0
	mvtc 	r2, psw						/* 桼åߵ */
	jmp		r1							/* ؿ */
