/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#ifndef _SYS_CONFIG_H_
#define _SYS_CONFIG_H_

/*
 *  ͥ̾Υ͡
 */
#include <sys_rename.h>

/*
 *  ƥ¸Υ󥯥롼ɥեɤ߹
 */
#include <h8s2350.h>
#include <mispo_h8s2350.h>

/*
 *  vgxet_tim 򥵥ݡȤ뤫ɤ
 */
#define	SUPPORT_VXGET_TIM

/*
 *  ꥢݡȿ
 */
#define TNUM_PORT	2u	/* ݡȤ륷ꥢݡȤο */
#define	TNUM_SIOP	2u	/* ݡȤ륷ꥢI/OݡȤο */

/*
 *  ƥॿ˴ؤ
 */
#define	LOGTASK_PORTID	1	/* ƥϤ륷ꥢݡֹ */
#define	CONSOLE_PORTID	1	/* 󥽡Ϥ륷ꥢݡֹ */
		/* CONSOLE_PORTID : monitor  */

/*
 *  ԤΤ
 */
#define	SIL_DLY_TIM1	22620
#define	SIL_DLY_TIM2	3865

#ifndef _MACRO_ONLY

/*
 *  åȥƥ¸ν
 */

extern void	sys_initialize(void);

/*
 *  åȥƥνλ
 *
 *  ƥλ˻ȤROM˥ƽФǼ¸뤳Ȥꤷ
 *  Ƥ롥
 */

extern void	sys_exit(void);

/*
 *  åȥƥʸ
 *
 *  ƥ٥ʸϥ롼ROM˥ƽФǼ¸뤳
 *  ȤꤷƤ롥
 */

extern void	sys_putc(char c) throw();

#endif /* _MACRO_ONLY */

/*============================================================================*/
/* ʲϡ̥ɥȤ̵ȼ */

/*
 *  JSPͥưΥޥå (release.ld)
 *      0x000000 - 0x01ffff     ΰ(128kB)
 *      0x200000 -              ǡΰ(128kB)
 *               - 0x21ffff     Ωѥå꽪λ
 */

/*
 *  JSPͥưΥޥå (debug.ld)
 *      0x200000 - 0x20ffff     ΰ(64kB)
 *      0x210000 -              ǡΰ(64kB-8kB(for GDB_STUB))
 *               - 0x21efff     Ωѥå꽪λ
 */

/*
 *   åΰ
 */
#ifndef GDB_STUB
#define STACKTOP    	0x21fffc	/* Ωѥåν */
#else /* GDB_STUB */
#define STACKTOP    	0x21effc	/* Ωѥåν */
#endif /* GDB_STUB */

#define str_STACKTOP	TO_STRING(STACKTOP)

/*
 *  ߥ٥
 */
#define SCI0_INT_LVL	3u		/* SCIͥ0γߥ٥ */
#define SCI1_INT_LVL	3u		/* SCIͥ1γߥ٥ */
#define TPU0_INT_LVL	5u		/* TPUͥ0γߥ٥ */

/*
 *  ꥢ륳ȥΥܡ졼Ȥ
 */
/* #define BAUD_RATE	9600u */	/* bps */
#define BAUD_RATE	38400u
/* #define BAUD_RATE	57600u */

#endif /* _SYS_CONFIG_H_ */
