/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#define _MACRO_ONLY
#include <jsp_kernel.h>
#include <hw_serial.h>


/*
 *  ߥ٥ơ֥
 *    ٥ơ֥ϸʤΤǡߤνΥ٥
 *    ʲΥ٥ơ֥ľܽ񤭹ɬפ롣
 */

	.h8300s
	.section .vectors
	.align 4

/*	.global _vectors*/

_vectors:
	.long	start				/*  0, 0x0000: ѥꥻå	*/
	.long	start    			/*  1, 0x0004: ޥ˥奢ꥻå	*/
	/*  ----------------------------------------------------------  */
	.long	no_reg_exception		/*  2, 0x0008: ƥͽ		*/
	.long	no_reg_exception		/*  3, 0x000c: ƥͽ		*/
	.long	no_reg_exception		/*  4, 0x0010: ƥͽ		*/
	/*  ---ȥ졼-----------------------------------------------  */
	.long	no_reg_exception		/*  5, 0x0014: ȥ졼			*/
	/*  ----------------------------------------------------------  */
	.long	no_reg_exception		/*  6, 0x0018: ƥͽ		*/
	/*  ---NMI----------------------------------------------------  */
	.long	start				/*  7, 0x001c:   NMI		*/
	/*  ---ȥå̿-------------------------------------------  */
	.long	no_reg_exception		/*  8, 0x0020: ȥå̿		*/
	.long	no_reg_exception		/*  9, 0x0024: ȥå̿		*/
	.long	no_reg_exception		/* 10, 0x0028: ȥå̿		*/
	.long	no_reg_exception		/* 11, 0x002c: ȥå̿		*/
	/*  ----------------------------------------------------------  */
	.long	no_reg_exception		/* 12, 0x0030: ƥͽ		*/
	.long	no_reg_exception		/* 13, 0x0034: ƥͽ		*/
	.long	no_reg_exception		/* 14, 0x0038: ƥͽ		*/
	.long	no_reg_exception		/* 15, 0x003c: ƥͽ		*/
	/*  ------------------------------------------------  */
	.long	no_reg_exception		/* 16, 0x0040: IRQ0	*/
	.long	no_reg_exception		/* 17, 0x0044: IRQ1	*/
	.long	no_reg_exception		/* 18, 0x0048: IRQ2	*/
	.long	no_reg_exception		/* 19, 0x004c: IRQ3 	*/
	.long	no_reg_exception		/* 20, 0x0050: IRQ4	*/
	.long	no_reg_exception		/* 21, 0x0054: IRQ5	*/
	.long	no_reg_exception		/* 22, 0x0058: IRQ6	*/
        .long	no_reg_exception		/* 23, 0x005c: IRQ7	*/
        /*  ---DTC----------------------------------------------------  */
        .long	no_reg_exception		/* 24, 0x0060: SWDTEND(եȥưǡžλ)	*/
        /*  åɥå--------------------------------------  */
	.long	no_reg_exception		/* 25, 0x0064: WOVI(󥿡Х륿)	*/
	/*  ---եå女ȥ-------------------------------  */
	.long	no_reg_exception		/* 26, 0x0068: CMI(ڥޥå)	*/
        /*  ----------------------------------------------------------  */
	.long	no_reg_exception		/* 27, 0x006c: ꥶ	*/
 	/*  ---A/D----------------------------------------------------  */
	.long	no_reg_exception		/* 28, 0x0070: ADI(A/DѴνλ)	*/
	/*  ----------------------------------------------------------  */
	.long	no_reg_exception		/* 29, 0x0074: ꥶ	*/
	.long	no_reg_exception		/* 30, 0x0078: ꥶ	*/
	.long	no_reg_exception		/* 31, 0x007c: ꥶ	*/
	/*  ---TPUͥ0-------------------------------------------  */
	.long	_INT_ENTRY(timer_handler)	/* 32, 0x0080: TGI0A	*/
	.long	no_reg_exception		/* 33, 0x0084: TGI0B	*/
	.long	no_reg_exception		/* 34, 0x0088: TGI0C	*/
	.long	no_reg_exception		/* 35, 0x008c: TGI0D	*/
	.long	no_reg_exception		/* 36, 0x0090: TCI0V	*/
	/*  ----------------------------------------------------------  */
	.long	no_reg_exception		/* 37, 0x0094: ꥶ	*/
	.long	no_reg_exception		/* 38, 0x0098: ꥶ	*/
	.long	no_reg_exception		/* 39, 0x009c: ꥶ	*/
	/*  ---TPUͥ1-------------------------------------------  */
	.long	no_reg_exception		/* 40, 0x00a0: TGI1A	*/
	.long	no_reg_exception		/* 41, 0x00a4: TGI1B	*/
	.long	no_reg_exception		/* 42, 0x00a8: TCI1V	*/
	.long	no_reg_exception		/* 43, 0x00ac: TCI1U	*/
	/*  ---TPUͥ2-------------------------------------------  */
	.long	no_reg_exception		/* 44, 0x00b0: TGI2A	*/
	.long	no_reg_exception		/* 45, 0x00b4: TGI2B	*/
	.long	no_reg_exception		/* 46, 0x00b8: TCI2V	*/
	.long	no_reg_exception		/* 47, 0x00bc: TCI2U	*/
	/*  --TPUͥ3--------------------------------------------  */
	.long	no_reg_exception		/* 48, 0x00c0: TGI3A	*/
	.long	no_reg_exception		/* 49, 0x00c4: TGI3B	*/
	.long	no_reg_exception		/* 50, 0x00c8: TGI3C	*/
	.long	no_reg_exception		/* 51, 0x00cc: TGI3D	*/
	.long	no_reg_exception		/* 52, 0x00d0: TCI3V	*/
	/*  ----------------------------------------------------------  */
 	.long	no_reg_exception		/* 53, 0x00d4: ꥶ	*/
	.long	no_reg_exception		/* 54, 0x00d8: ꥶ	*/
	.long	no_reg_exception		/* 55, 0x00dc: ꥶ	*/
	/*  ---TPUͥ4-------------------------------------------  */
	.long	no_reg_exception		/* 56, 0x00e0: TGI4A	*/
	.long	no_reg_exception		/* 57, 0x00e4: TGI4B	*/
	.long	no_reg_exception		/* 58, 0x00e8: TCI4V	*/
	.long	no_reg_exception		/* 59, 0x00ec: TCI4U	*/
	/*  ---TPUͥ5-------------------------------------------  */
	.long	no_reg_exception		/* 60, 0x00f0: TGI5A	*/
	.long	no_reg_exception		/* 61, 0x00f4: TGI5B	*/
	.long	no_reg_exception		/* 62, 0x00f8: TCI5V	*/
	.long	no_reg_exception		/* 63, 0x00fc: TCI5U    */
     	/*  ----------------------------------------------------------  */
	.long	no_reg_exception		/* 64, 0x0100: ꥶ	*/
	.long	no_reg_exception		/* 65, 0x0104: ꥶ	*/
	.long	no_reg_exception		/* 66, 0x0108: ꥶ	*/
	.long	no_reg_exception		/* 67, 0x010c: ꥶ	*/
	.long	no_reg_exception		/* 68, 0x0110: ꥶ	*/
	.long	no_reg_exception		/* 69, 0x0114: ꥶ	*/
	.long	no_reg_exception		/* 70, 0x0118: ꥶ	*/
	.long	no_reg_exception		/* 71, 0x011c: ꥶ	*/
	/*  ---DMAC---------------------------------------------------  */
	.long	no_reg_exception		/* 72, 0x0120: DEND0A	*/
	.long	no_reg_exception		/* 73, 0x0124: DEND0B	*/
	.long	no_reg_exception		/* 74, 0x0128: DEND1A	*/
	.long	no_reg_exception		/* 75, 0x012c: DEND1B	*/
	/*  ----------------------------------------------------------  */
	.long	no_reg_exception		/* 76, 0x0130: ꥶ	*/
	.long	no_reg_exception		/* 77, 0x0134: ꥶ	*/
	.long	no_reg_exception		/* 78, 0x0138: ꥶ	*/
	.long	no_reg_exception		/* 79, 0x013c: ꥶ	*/
	/*  ---SCIͥ0-------------------------------------------  */
	.long	_INT_ENTRY(sio1_handler_error)	/* 80, 0x0140: ERI0	*/
	.long	_INT_ENTRY(sio1_handler_in)	/* 81, 0x0144: RXI0	*/
	.long	_INT_ENTRY(sio1_handler_out)	/* 82, 0x0148: TXI0	*/
	.long	no_reg_exception		/* 83, 0x014c: TEI0	*/
        /*  ---SCIͥ1-------------------------------------------  */
#if TNUM_SIOP >= 2
	.long	_INT_ENTRY(sio2_handler_error)	/* 84, 0x0150: ERI1	*/
	.long	_INT_ENTRY(sio2_handler_in)	/* 85, 0x0154: RXI1	*/
	.long	_INT_ENTRY(sio2_handler_out)	/* 86, 0x0158: TXI1	*/
	.long	no_reg_exception		/* 87, 0x015c: TEl1	*/
#else
	.long	no_reg_exception		/* 84, 0x0150: ERI1	*/
	.long	no_reg_exception		/* 85, 0x0154: RXI1	*/
	.long	no_reg_exception		/* 86, 0x0158: TXI1	*/
	.long	no_reg_exception		/* 87, 0x015c: TEl1	*/
#endif /* TNUM_SIOP >= 2 */
        /*  ----------------------------------------------------------  */
	.long	no_reg_exception		/* 88, 0x0160: ꥶ	*/
	.long	no_reg_exception		/* 89, 0x0164: ꥶ	*/
	.long	no_reg_exception		/* 90, 0x0168: ꥶ	*/
	.long	no_reg_exception		/* 91, 0x016c: ꥶ	*/
