/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#ifndef	_CPU_INSN_H_
#define	_CPU_INSN_H_

/* ˤѤƤ롢MAX_IPM  cpu_config.h  */

#ifndef _MACRO_ONLY

/*
 *  쥸ؿ
 */

/* ǥ󥳡ɥ쥸CCRˤθͤɽФ */
Inline UB current_ccr(void)
{
	UB	ccr;

	Asm( "stc.b	ccr, %0l" : "=r"(ccr) );

	return(ccr);
}

/* ǥ󥳡ɥ쥸CCRˤθͤѹ */
Inline void set_ccr(UB ccr)
{
	Asm( "ldc.b	%0l, ccr" ::"r"(ccr) );
}

/* ƥɥ쥸EXRˤθͤɽФ */
Inline UB current_exr(void)
{
	UB	exr;

	Asm( "stc.b	exr, %0l" : "=r"(exr) );

	return(exr);
}

/* ǥ󥳡ɥ쥸EXRˤθͤѹ */
Inline void set_exr(UB exr)
{
	Asm( "ldc.b	%0l, exr" :: "r"(exr) );
}

/*
 *  ߥޥ饤֥ (ߥ⡼ɣ)
 */

/* ߤγߥޥɽФ */
Inline IPM current_intmask(void)
{
	return(  (IPM)  (current_exr() &  EXR_I_MASK) );
}

/* ߥޥ */
Inline void set_intmask(IPM intmask)
{
	set_exr( (IPM) ((current_exr() & ~EXR_I_MASK) | intmask ) );
}

/* ͥΤ٤Ƥγ  ߥ٥뤬MAX_IPM ʲγ */

/* ͥΤ٤Ƥγߤػ (NMI)  */
Inline void disint(void)
{
	/* set_intmask( (IPM) MAX_IPM ); */
	set_exr( (IPM) ((current_exr() & ~EXR_I_MASK) | MAX_IPM ) );
}

/* ͥΤ٤Ƥγߤ (NMI) */
/*   νϡ¾塢̵ͥͭ鷺٤Ƥγߤ
     Ĥ뤳ȤˤʤäƤ롣 */
Inline void enaint()
{
	/* set_intmask( (IPM) 0 ); */
	set_exr( (IPM)  (current_exr() & ~EXR_I_MASK) );
}

/*
 *  ߥå֤Ѵؿ
 */

/* ٤Ƥγߤػ (NMI) */
Inline void _disint_()
{
	/* set_intmask( (IPM) 7 ); */
	set_exr( (IPM) (current_exr() | EXR_I_MASK) );
}

/*
 *  ӥåѴؿ
 */

/* ӥåȥꥢ */
Inline void bitclr(UW addr, UB bit)
{
	Asm( "bclr %1l, @%0" :: "r"(addr), "r"(bit) );
}

/* ӥåȥå */
Inline void bitset(UW addr, UB bit)
{
	Asm( "bset %1l, @%0" :: "r"(addr), "r"(bit) );
}

#endif /* _MACRO_ONLY */

#endif /* _CPU_INSN_H_ */
