/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

/*
 *  ץå¸⥸塼(H8S)
 */

#include "jsp_kernel.h"
#include "check.h"
#include "task.h"

/*
 *  ƥȤǤγߥޥ
 */
#ifdef SUPPORT_CHG_IPM
IPM	task_intmask;		/* IPM -> UB̵8ӥå */
#endif /* SUPPORT_CHG_IPM */

/*
 *  󥿥ƥȤǤγߥޥ
 */
IPM	int_intmask;

/*
 *  ߥͥȥ
 */
UW	intnest;

/*
 *  ץå¸ν
 */
void cpu_initialize() {

#ifdef SUPPORT_CHG_IPM
	/* ƥȤǤγߥޥν */
	task_intmask = 0x00;
#endif /* SUPPORT_CHG_IPM */

	/* ߡCPU㳰ͥȥ󥿤ν */
	intnest = 1;

	/* ߥ٥ν */
	icu_set_ilv( (VP) IPRA, IPR_UPR, 0 );
	icu_set_ilv( (VP) IPRA, IPR_LOW, 0 );
	icu_set_ilv( (VP) IPRB, IPR_UPR, 0 );
	icu_set_ilv( (VP) IPRB, IPR_LOW, 0 );
	icu_set_ilv( (VP) IPRC, IPR_UPR, 0 );
	icu_set_ilv( (VP) IPRC, IPR_LOW, 0 );
	icu_set_ilv( (VP) IPRD, IPR_UPR, 0 );
	icu_set_ilv( (VP) IPRD, IPR_LOW, 0 );
	icu_set_ilv( (VP) IPRE, IPR_UPR, 0 );
	icu_set_ilv( (VP) IPRE, IPR_LOW, 0 );
	icu_set_ilv( (VP) IPRF, IPR_UPR, 0 );
	icu_set_ilv( (VP) IPRF, IPR_LOW, 0 );
	icu_set_ilv( (VP) IPRG, IPR_UPR, 0 );
	icu_set_ilv( (VP) IPRG, IPR_LOW, 0 );
	icu_set_ilv( (VP) IPRH, IPR_UPR, 0 );
	icu_set_ilv( (VP) IPRH, IPR_LOW, 0 );
	icu_set_ilv( (VP) IPRI, IPR_UPR, 0 );
	icu_set_ilv( (VP) IPRI, IPR_LOW, 0 );
	icu_set_ilv( (VP) IPRJ, IPR_UPR, 0 );
	icu_set_ilv( (VP) IPRJ, IPR_LOW, 0 );
	icu_set_ilv( (VP) IPRK, IPR_UPR, 0 );
	icu_set_ilv( (VP) IPRK, IPR_LOW, 0 );
}

/*
 *  ץå¸νλ
 */
void cpu_terminate() {
}

/*
 *  Ԥ
 */
void sil_dly_nse(UINT dlytim) {
	/* er0 = dlytim */
	Asm("		sub.l	%0, er0" :: "g"(SIL_DLY_TIM1) );
	Asm("		ble	sil_dly_nse_2");
				/* dlytim < SIL_DLY_TIM1 ʤ롼׽λ */
	Asm("	sil_dly_nse_1:");
	Asm("		sub.l	%0, er0" :: "g"(SIL_DLY_TIM2) );
	Asm("		bgt	sil_dly_nse_1");
				/* dlytim > SIL_DLY_TIM2 ʤ롼³ */
	Asm("	sil_dly_nse_2:");
}

#ifdef SUPPORT_CHG_IPM

/*
 *  ߥޥѹ
 *
 *  chg_ipm Ȥäơߥޥ MAX_IPM NMI ֥⡼ȥ֥졼 ʳ
 *    Τ٤Ƥγߤػߡ˰ʾѹ뤳ȤϤǤޤNMI ֥⡼
 *    ֥졼ʳΤ٤Ƥγߤػߤˤϡloc_cpuˤCPUå
 *    ֤ˤƤ
 *  ߥޥ 0 ʳλǤäƤ⡢ǥѥåαޤ
 *    ΤȤߥޥξ֤ϡǥѥåˤäƿ¹Ծ֤
 *    ʤäء١Ѥޤ
 *    Τᡢ¹ˡߤȯǥѥå̤Υ
 *    ˤäƳߥޥѹ礬ޤ
 *    TOPPERS/JSP ͥǤϡߥޥѹϥ㳰롼ˤ
 *    ƤⵯΤǡˤäư񤷤ʤϾʤȻפޤ
 *  ߥޥͤˤäƥǥѥåػߤˤϡdis_dsp 
 *    ʻѤƤ
 */
SYSCALL ER
chg_ipm(IPM ipm)
{
	ER	ercd;

	LOG_CHG_IPM_ENTER(ipm);
	CHECK_TSKCTX_UNL();
	CHECK_PAR( /*(0 <= ipm) &&*/ (ipm <= MAX_IPM) );
	/* IPM ϡunsigned ƤΤǡȥȤ
	   ȤϡΩƤ뤿ᡢWarnning ȯ롣
	   ꤫顢Ū˵ҤƤ */

	t_lock_cpu();
	task_intmask = ipm;
	ercd = E_OK;
	t_unlock_cpu();

    exit:
	LOG_CHG_IPM_LEAVE(ercd)
	return(ercd);
}

/*
 *  ߥޥλ
 */
SYSCALL ER
get_ipm(IPM *p_ipm)
{
	ER	ercd;

	LOG_GET_IPM_ENTER(p_ipm);
	CHECK_TSKCTX_UNL();

	t_lock_cpu();
	*p_ipm = task_intmask;
	ercd = E_OK;
	t_unlock_cpu();

    exit:
	LOG_GET_IPM_LEAVE(ercd, *p_ipm);
	return(ercd);
}

#endif /* SUPPORT_CHG_IPM */

/*============================================================================*/
/*  ̥ɥȤˤϤʤȼʬ  */

/*
 * ϿƤʤߤȯȸƤӽФ
 */
void cpu_experr(EXCSTACK *sp)
{
	syslog( LOG_EMERG, "Unexpected interrupt." );
	syslog( LOG_EMERG, "SP  = %08x PC  = %08x CCR = %08x",
				sp - 34, sp->pc,  sp->ccr );
	syslog( LOG_EMERG, "ER0 = %08x ER1 = %08x ER2 = %08x ER3 = %08x",
				sp->er0, sp->er1, sp->er2, sp->er3 );
	syslog( LOG_EMERG, "ER4 = %08x ER5 = %08x ER6 = %08x ",
				sp->er4, sp->er5, sp->er6 );

	while(1);
}

/*
 *  ֥å饤֥
 *	(ItIsή)
 *
 *  ؿλͤϡANSI C 饤֥λͤƱɸ饤֥ΤΤ
 *  ȤäΨɤǽ롥
 *
 */
VP _dummy_memcpy(VP dest, VP src, UINT len)
{
	VB	*d = (VB *)dest;
	VB	*s = (VB *)src;

	while (len-- > 0) {
		*d++ = *s++;
	}

	return(dest);
}
