/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#ifndef _UTIL_H_
#define _UTIL_H_

/*
 *  Υإåե˴ޤޤƤޥϡ§Ȥơͥ볫ȯԤФ
 *  ƤΤǤ롣Τᡢѥ᡼åʤɤԽʬǤ롣
 *  桼ˤäƤϡǤˤѤ뤳ȡ
 */

/*
 *  ӥåֹ
 */
#define BIT0              0x1
#define BIT1              0x2
#define BIT2              0x4
#define BIT3              0x8
#define BIT4             0x10
#define BIT5             0x20
#define BIT6             0x40
#define BIT7             0x80
#define BIT8            0x100
#define BIT9            0x200
#define BIT10           0x400
#define BIT11           0x800
#define BIT12          0x1000
#define BIT13          0x2000
#define BIT14          0x4000
#define BIT15          0x8000

#define DUMMY		    0

/*
 *  Хȥǡѥޥ
 */
/* ʲˤơx */

/* ʲΤ褦ʽȡɤäɤ
     (UH) (((UW) (c)) & 0x0000ffff)
     (UH) (((UW) (c)) & 0xffff0000) >> 16
*/

/* (UH) xxaa -> (UB) aa */			/* 1ХȼФ */
#define LO8(c)		(UB)( (UH)(c) & 0xff )
/* (UH) aaxx -> (UB) aa */			/* 1ХȼФ */
#define HI8(c)		LO8( (UH)(c) >>  8 )

/* (UW) xxxxaaaa -> (UH) aaaa */		/* 2ХȼФ */
#define LO16(c)		(UH)( (UW)(c) & 0xffff )
/* (UW) aaaaxxxx -> (UH) aaaa */		/* 2ХȼФ */
#define HI16(c)		LO16( (UW)(c) >> 16 )

/* (UH) aaaa, (UH) bbbb -> (UW) aaaabbbb */	/* 2Хȥǡη */
#define JOIN16(hi, lo)	(UW)( ((UW)(hi) << 16) | (lo) )
/* (UB) aa, (UB) bb -> (UH) aabb */		/* 1Хȥǡη */
#define JOIN8(hi, lo)	(UH)( ((UH)(hi) <<  8) | (lo) )

/* (BIN) : ʿ */
/* (BIN) xxxxaaaa -> (BIN) 0000aaaa */		/* 0-3ӥåȤ  */
#define TO_LO4(c)	( (UB)(c) & 0xf )
/* (BIN) xxxxaaaa -> (BIN) aaaa0000 */		/* 4-7ӥåȤ  */
#define TO_HI4(c)	(((UB)(c) << 4) & 0xf0)

/*
 *  ܥ̾η
 */
#define JOINT(a,b)      _JOINT(a,b)
#define _JOINT(a,b)     a##b

#define JOINT3(a,b,c)   _JOINT3(a,b,c)
#define _JOINT3(a,b,c)  JOINT(a,JOINT(b,c))

#define JOINT4(a,b,c,d)   _JOINT4(a,b,c,d)
#define _JOINT4(a,b,c,d)  JOINT(a,JOINT3(b,c,d))

#endif /* _UTIL_H_ */
