/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <h8s_tpu.h>

/*
 *   ޥɥ饤СH8Sեߥ꡼ѡ
 *     H8Sեߥ꡼ˤϡTPU(16bit)  8bit Σब
 *     Ƥꡢܿϡƥץåˤۤʤ롣
 *     ܼǤϡTPU(16bit) ѤƤ롣ä˥ͥ룰
 *     ¾H8Sץåˤơ8bit Ѥϡѹ
 *     Ԥɬפ롣
 */

/*
 *  ޳ߥϥɥΥ٥ֹ
 */
#define	INHNO_TIMER	IRQ_TGI0A

#ifndef _MACRO_ONLY

/*
 *  ͤɽη
 */
typedef UH	CLOCK;

#endif	/* _MACRO_ONLY */

/*
 *  ޼ñ̤ɽѴ
 *  	jsp/kernel/time_manage.cǤ
 */
#define TO_CLOCK(nume, deno)	(TIMER_CLOCK * (nume) / (deno))
#define TO_USEC(clock)		((clock) * 1000 / TIMER_CLOCK)

/*
 *  ޼ñ̤ɽѴ
 */
#define CLOCK_PER_TICK	((CLOCK) TO_CLOCK(TIC_NUME, TIC_DENO))

/*
 *  ǤΥ޼ñ̤ɽ
 */
#define MAX_CLOCK	((CLOCK) 0xffff)

/*
 *  ǽɾѥƥФݤν֤θѤ
 *	ñ̤ɽ
 *	աʬå˰¸
 */

#define GET_TOLERANCE	100u
#define	BEFORE_IREQ(clock) \
		((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)

#ifndef _MACRO_ONLY

/*
 *  ޳׵Υꥢ
 */
Inline void
hw_timer_int_clear(void)
{
	/* ͥ룰γ׵᥯ꥢ (TGFA = 0) */
	h8s_andb_reg( (VP) TSR0, ~TGFA );
}

/*
 *  ޤεư
 *    ޤŪʥ޳׵ȯ롥
 */
Inline void
hw_timer_initialize(void)
{
	/* ⥸塼륹ȥåץ⡼ɲ */
	h8s_andh_reg( (VP) MSTPCR, ~MSTPCR_TPU );

	/* ͥ룰ư */
	h8s_andb_reg( (VP) TSTR, ~CST0 );

	/* TCR 
	   TGRAڥޥåǥ󥿤򥯥ꥢ(CCLR = 1)
	   Ω夬ꥨåǥ(CKEG1,0 = 0)
	 å/4ǥ(ʬꡨTPSC0 =1) */
	h8s_wrb_reg( (VP) TCR0, (CCLR0 | TPSC0) );

	/* TIER 
	   TGFAӥåȤˤ׵ */
	h8s_wrb_reg( (VP) TIER0, TGIEA );

	/* TIOR 
	   TGRAڥޥåˤüҽ϶ػ */
	/* ꤹ٤Τ̵ */

	/* TGR0A 
	   TGRA쥸ʥɸ͡*/
	h8s_wrh_reg( (VP) TGR0A, CLOCK_PER_TICK );

	h8s_wrh_reg( (VP) TCNT0, 0 );		/* 󥿤򥯥ꥢ */

	/*
	 *  ߴϢ
	 */
	icu_set_ilv( IPRF, IPR_UPR, TPU0_INT_LVL );
						/* ߥ٥ */
	hw_timer_int_clear();			/* ׵򥯥ꥢ */

	/* ͥ룰ư */
	h8s_orb_reg( (VP) TSTR, CST0 );
}

/*
 *  ޤ߽
 */
Inline void
hw_timer_terminate(void)
{
	/* ͥ룰ư */
	h8s_andb_reg( (VP) TSTR, ~CST0 );

	hw_timer_int_clear();			/* ׵򥯥ꥢ */
}

/*
 *  ޤθͤɤ߽Ф
 *    ߶ػ߶ǸƤӽФȡ
 */
Inline CLOCK
hw_timer_get_current(void)
{
	/* åץ󥿤ʤΤ */
	return( (CLOCK) h8s_reh_reg( (VP) TCNT0 ) );
}

/*
 *  ޳׵Υå
 */
Inline BOOL
hw_timer_fetch_interrupt(void)
{
	return( h8s_reb_reg( (VP) TSR0 ) & TGFA );
}

#endif	/* _MACRO_ONLY */

#endif /* _HW_TIMER_H_ */
