/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 *  @(#) $Id: h8_sil.c,v 1.7 2007/03/23 07:22:15 honda Exp $
 */

/*
 * ƥ।󥿥ե쥤ɲʬ
 *I/OݡȤΥǡǥ쥯󡦥쥸DDRؤΥ
 *H8DDRϽ񤭹ѤǤꡢΤޤޤǤϽ˾ΥӥåȤ
 *ѹ뤳ȤǤʤbset,bclr̿ǤԲġ
 *ΤᡢܼǤϡ˥ƥݥѰդơDDR
 *ͤݻˡΤäƤ롣
 *
 *ʤݡ7ѤDDR쥸ʤᡢάƤ롣
 */

#include "jsp_kernel.h"
#include "check.h"
#include "task.h"
#include <h8_sil.h>

#define	DUMMY	0

/*  Υƥݥΰ  */
static UB ddr_tmp[] = {
	/* 1         2         3         4         5      */
	H8P1DDR0, H8P2DDR0, H8P3DDR0, H8P4DDR0, H8P5DDR0, 
	/* 6         8         9         A         B      */
	H8P6DDR0, H8P8DDR0, H8P9DDR0, H8PADDR0, H8PBDDR0
};

/*  ƥݡȤΥɥ쥹  */
static const VP ddr_adr[] = {
	(VP)H8P1DDR, (VP)H8P2DDR, (VP)H8P3DDR, (VP)H8P4DDR, (VP)H8P5DDR, 
	(VP)H8P6DDR, (VP)H8P8DDR, (VP)H8P9DDR, (VP)H8PADDR, (VP)H8PBDDR
};


/*
 *  Ԥ
 *  ץȥsil.hˤ
 */
void sil_dly_nse(UINT dlytim) {
	/* er0 = dlytim */
	Asm("		sub.l	%0, er0" :: "g"(SIL_DLY_TIM1) );
	Asm("		ble	sil_dly_nse_2");
				/* dlytim < SIL_DLY_TIM1 ʤ롼׽λ */
	Asm("	sil_dly_nse_1:");
	Asm("		sub.l	%0, er0" :: "g"(SIL_DLY_TIM2) );
	Asm("		bgt	sil_dly_nse_1");
				/* dlytim > SIL_DLY_TIM2 ʤ롼³ */
	Asm("	sil_dly_nse_2:");
}

/*
 *      DDRɤ߽Ф
 */
UB sil_reb_ddr(UINT port)
{
	assert((IO_PORT1 <= port) && (port <= IO_PORTB));
	return ddr_tmp[port];
}

/*
 *      DDRν񤭹
 */
void sil_wrb_ddr(UINT port, UB data)
{
	assert((IO_PORT1 <= port) && (port <= IO_PORTB));
	ddr_tmp[port] = data;
	sil_wrb_mem(ddr_adr[port], (VB)data);
}

/*
 *      DDRAND黻
 */
void sil_anb_ddr(UINT port, UB data)
{
	UB ddr = sil_reb_ddr(port);
	
	ddr &= data;
	sil_wrb_ddr(port, ddr);
}

/*
 *      DDROR黻
 */
void sil_orb_ddr(UINT port, UB data)
{
	UB ddr = sil_reb_ddr(port);

	ddr |= data;
	sil_wrb_ddr(port, ddr);
}

