/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_config.h,v 1.18 2007/03/23 07:22:15 honda Exp $
 */

/*
 *	ץå¸⥸塼H8ѡ
 *
 *  Υ󥯥롼ɥեϡt_config.h Τߤ饤󥯥롼ɤ롥
 *  ¾Υե뤫ľܥ󥯥롼ɤƤϤʤʤ
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

#include <h8.h>

/*
 *  ͥ̾Υ͡
 */

#include <cpu_rename.h>

/*
 *  ץåü̿Υ饤ؿ
 */

#ifndef _MACRO_ONLY
#include <cpu_insn.h>

/*
 *  ƥȥ֥å
 */

typedef struct task_context_block {
	VP	sp;		/* åݥ */
	FP	pc;		/* ץ५ */
} CTXB;

/*
 *  ߥޥ饤֥
 */

/*
 *  ߤγߥޥɽФ
 */

Inline UB
current_intmask(void)
{
	return(current_ccr() & H8INT_MASK_ALL);
}

/*
 *  ߥޥ
 */

Inline void
set_intmask(UB intmask)
{
	set_ccr((current_ccr() & ~H8INT_MASK_ALL) | intmask);
}

/*
 *  ߥͥȥ
 */

extern volatile UB intnest;

/*
 *  ƥȻ
 *
 *  ߥͥȥ󥿤ɤ߽Фľ˳ߤȯƤ⡢ä
 *  ˤϥƥȤ⸵äƤ
 */

Inline BOOL
sense_context(void)
{
	BOOL ret;
	
	ret = (intnest != 0) ? TRUE : FALSE;
	return(ret);
}

/*
 *  CPUå֤λ
 */

/*
 *  CPUå֤ɽե饰
 */
extern volatile BOOL    iscpulocked;

#define sense_lock()    iscpulocked
#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock

/*
 *  CPUåȤβʥƥѡ
 *
 *  task_intmask ϡchg_ipm 򥵥ݡȤ뤿ѿchg_ipm 򥵥ݡ
 *  ʤˤϡt_unlock_cpu  task_intmask  0 ֤Ƥ褤
 */

#ifdef SUPPORT_CHG_IPM
extern volatile UB       task_intmask;   /* ƥȤǤγߥޥ */
#endif /* SUPPORT_CHG_IPM */

Inline void
t_lock_cpu(void)
{
        disint();
        iscpulocked = TRUE;
}

Inline void
t_unlock_cpu(void)
{
        iscpulocked = FALSE;
#ifdef SUPPORT_CHG_IPM
        /*
         *  t_unlock_cpu ƤӽФΤ CPUå֤ΤߤǤ뤿ᡢ
         *   task_intmask 񤭴뤳ȤϤʤ
         */
        set_intmask(task_intmask);
#else /* SUPPORT_CHG_IPM */
        enaint();               /* cpu_insn.h */
#endif /* SUPPORT_CHG_IPM */
}

/*
 *  CPUåȤβ󥿥ƥѡ
 */

extern volatile UB int_intmask;    /* 󥿥ƥȤǤγߥޥ */

Inline void
i_lock_cpu(void)
{
        UB      intmask = current_intmask();
        /*
         *  ѿ intmask ȤäƤΤϡcurrent_intmask()Ƥ
         *  ľ˳ߤȯư줿ߥϥɥ
         *  int_intmask ѹǽ뤿Ǥ롥
         */

        disint();
        int_intmask = intmask;
        iscpulocked = TRUE;
}

Inline void
i_unlock_cpu(void)
{
        iscpulocked = FALSE;
        set_intmask(int_intmask);
}

/*
 *  ǥѥå
 */

/*
 *  ǹ̥ͥؤΥǥѥåcpu_support.S
 *
 *  dispatch ϡƥȤƤӽФ줿ӥ
 *  ǡCPUå֤ǸƤӽФʤФʤʤ
 */

extern void	dispatch(void);

/*
 *  ߤΥƥȤΤƤƥǥѥåcpu_support.S
 *
 *  exit_and_dispatch ϡCPUå֤ǸƤӽФʤФʤʤ
 */

extern void	exit_and_dispatch(void);

/*
 *
 *  ߥϥɥ
 *
 *  ٥ȥֹ inhno γߥϥɥεưϤ inthdr ꤹ롥
 *
 */

#define JMP_OPECODE		0x5a000000u

Inline void
define_inh(INHNO inhno, FP inthdr)
{
#ifdef REDBOOT
   UW *addr = (UW *)VECTOR_TABLE_ADDR;
   addr[inhno] = JMP_OPECODE | (UW)inthdr;
#endif	/*  #ifdef REDBOOT  */
}

/*
 *   CPU㳰ϥɥ
 */

Inline void
define_exc(EXCNO excno, FP exchdr)
{
}

#endif	/*  _MACRO_ONLY  */

/*
 *  ߥϥɥν
 *
 */

/*
 *  ߥϥɥνޥ
 *		ʼ
 */

/*  
 * C롼δؿ̾Υ٥ ޥ
 */

/*  CѤΥ٥  */
#define	INT_ENTRY(inthdr)	_kernel_##inthdr##_entry
#define	EXC_ENTRY(exchdr)	INT_ENTRY(exchdr)

/*  ֥ѤΥ٥  */
#define	INT_ENTRY_ASM(inthdr)	__kernel_##inthdr##_entry



/*
 *ߤޥ
 *ʳװ˰ۤʤʬ
 *
 *ѥ᡼
 *	entryΥ٥
 *inthdrC롼δؿ̾Ƭ'_'դʤ
 *intmaskߵĻ˳ߥޥꤹ
 *IPM_LEVEL1IPM_LEVEL2Τ줫ˤ뤳
 *
 *H8Ǥϳ߼ľϥϡɥŪ˳߶ػߤˤʤäƤ
 *
 *쥸
 *er0er3
 *er2C롼Ƭɥ쥹
 *r3lߵĻ˳ߥޥꤹ
 *
 */
#define	INTHDR_ENTRY2(entry, inthdr, intmask)	 \
	_INTHDR_ENTRY2(entry, inthdr, intmask)

#define	_INTHDR_ENTRY2(entry, inthdr, intmask)	 \
asm(".text					\n"\
"	.align 2				\n"\
"	.global "#entry"			\n"\
#entry":					\n"\
	/*  ɬ׺Ǿ¤Υ쥸򥹥å  */\
"	push.l	er0				\n"\
"	push.l	er1				\n"\
"	push.l	er2				\n"\
"	push.l	er3				\n"\
	/*  C롼Ƭɥ쥹  */	 \
"	mov.l   #_"#inthdr", er2		\n"\
	/*  ߵĻꤹߥޥ  */\
"	mov.b   #"#intmask", r3l		\n"\
"	jmp	@__kernel_common_interrupt_process"\
)

/*  _INTHDR_ENTRY()ޥޤ  */

/*
 *  ߥϥɥνޥ
 *
 */

#define INTHDR_ENTRY(inthdr)				\
	extern void INT_ENTRY(inthdr)(void) throw();	\
	INTHDR_ENTRY2(INT_ENTRY_ASM(inthdr), inthdr, inthdr##_intmask)

/*
 *  CPU㳰ϥɥνޥ
 */

#define	EXCHDR_ENTRY(exchdr)	INTHDR_ENTRY(exchdr)


#ifndef _MACRO_ONLY

/*
 *  CPU㳰ȯΥƥ֤λ
 */

/*
 *  CPU㳰ȯΥƥȽ
 */

Inline BOOL
exc_sense_context(VP p_excinf)
{
        /* H8ǤǤϸƤФʤ */
        return(TRUE);
}

/*
 *  CPU㳰ȯCPUå֤λ
 */

Inline BOOL
exc_sense_lock(VP p_excinf)
{
        /* H8ǤǤϸƤФʤ */
        return(TRUE);
}

/*
 *  ץå¸ν
 */

extern void	cpu_initialize(void);

/*
 *  ץå¸νλ
 */

extern void	cpu_terminate(void);

/*
 *  ̤ȯΥ顼ϻΥå¤
 */

typedef struct exc_stack {
	UW	er0;
	UW	er1;
	UW	er2;
	UW	er3;
	UW	er4;
	UW	er5;
	UW	er6;
	UW	pc;	/*  ץࡦ  	*/
} EXCSTACK;

/*
 * ̤ȯΥ顼 (cpu_config.c, cpu_support.S)
 */

extern void     cpu_experr(EXCSTACK *sp) throw();

/*
 *  åȥƥʸ
 *
 *  ƥ٥ʸϥ롼
 */

extern void cpu_putc(char c);

#endif /* _MACRO_ONLY_ */

#endif /* _CPU_CONFIG_H_ */
