/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 *  @(#) $Id: user_config.h,v 1.7 2007/03/23 07:58:33 honda Exp $
 */

#ifndef _USER_CONFIG_H_
#define _USER_CONFIG_H_

/*
 *  桼ե졼
 */

/*
 *  chg_ipm򥵥ݡȤ뤫ɤ
 *֥Ѥuser_config_asm.incˤƱͤɬפʤΤ
 */
#define SUPPORT_CHG_IPM

/*
 *  vxget_tim򥵥ݡȤ뤫ɤ
 */
#define SUPPORT_VXGET_TIM

/*
 *  åȿ [Hz]
 *user_config_asm.incˤƱͤɬפʤΤ
 */
#define CPU_CLOCK               24576000ul


/*
 *  ꥢݡȤ
 */

/*
 *  ݡȤ륷ꥢǥХοʺ 2
 *user_config_asm.incˤƱͤɬפʤΤ
 */
#define TNUM_PORT               1u

/*
 *  ݡֹ
 *
 *  hw_serial.h٤ץץफ
 *  Ȥ뤿ᡢ롣
 */
#define SCI_PORTID1				1		/*  ѹػ  */
#define SCI_PORTID2				2		/*  Ʊ  */

/*
 *  ݡֹγ
 *
 *  E10T-USBǥǥХåԤݤˤϡSCI1ͭ뤿ᡢ
 *  桼ץSCI0ΤߤѤ롣
 *
 *ݡȿΤȤ
 *ܡȣ(SCI0)ƥݡȡʸ
 *ݡȿΤȤ
 *ܡȣ(SCI0)ƥݡȡ桼ݡǽ
 *ܡȣ(SCI1)Ʊ
 */
#if TNUM_PORT == 1u

#define SYSTEM_PORTID           SCI_PORTID1		/*    */

#elif TNUM_PORT == 2u    /* of #if TNUM_PORT == 1u */

#define SYSTEM_PORTID           SCI_PORTID1		/*  򴹲ǽ  */
#define USER_PORTID             SCI_PORTID2

#else   /* of #if TNUM_PORT == 1u || TNUM_PORT == 2u */

#error TNUM_PORT <= 2u

#endif  /* of #if TNUM_PORT == 1u */

/*
 *  ٥ϤѤ륷ꥢݡȤΥݡֹ
 */
#define SCI_LOW_PORTID			SYSTEM_PORTID

/*  ܡ졼Ȥȥץ饤ƥ٥  */
#define SCI_PORT1_BAUD_RATE     38400ul		/* ܡ졼 [bps]     */
#define SCI_PORT1_IPM           IPM_LEVEL0	/* ץ饤ƥ٥  */

#if TNUM_PORT == 2u

#define SCI_PORT2_BAUD_RATE     38400ul		/* ܡ졼 [bps]     */
#define SCI_PORT2_IPM           IPM_LEVEL0	/* ץ饤ƥ٥  */

#endif  /* of #if TNUM_PORT == 2u */


/*
 * 顼ߤϳߤ̤ϥȤ򳰤
 *user_config_asm.incˤƱͤɬפʤΤ
 */
#if 0
#define H8_CFG_SCI_ERR_HANDLER
#endif


/*
 *  ޤ
 */

/*
 *  ƥå
 */

#define TIC_NUME        1u               /* ƥåμʬ */
#define TIC_DENO        1u               /* ƥåμʬ */

/*  ޤ˶뤵륯åȿ [kHz]  */
#define TIMER_CLOCK     ((CPU_CLOCK)/8000ul)     /* 8ʬ */

/*  ץ饤ƥ٥  */
#define SYSTEM_TIMER_IPM                IPM_LEVEL1


#endif /* _USER_CONFIG_H_ */
