/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: start.S,v 1.19 2007/01/05 02:02:38 honda Exp $
 */
                
/*
 *    ͥѤΥȥåץ⥸塼(ARMv4)
 */
#define _MACRO_ONLY
#include <armv4.h>
#include <sys_defs.h>
        
#include <t_config.h>
 


        /*
         * Vectorơ֥ȥץơ֥
         * Ϲ0x3c
         */
        .section .vector,"a"
        .code 32
        .align 0
        .global vector_table
vector_table:
        ldr pc, reset_vector       /* ꥻå             */
        ldr pc, undef_vector       /* ̤̿           */
        ldr pc, swi_vector         /* եȥ   */
        ldr pc, prefech_vector     /* ץեåܡ */
        ldr pc, data_abort_vector  /* ǡܡ       */
        ldr pc, reset_vector
        ldr pc, irq_vector         /* IRQ                  */
        ldr pc, fiq_vector         /* IRQ                  */

/*
 *  ٥ơ֥
 */
reset_vector:
        .long   start
undef_vector:
        .long   undef_exception
swi_vector:
        .long   swi_exception
prefech_vector:
        .long   prefetch_exception
data_abort_vector:
        .long   data_abort_exception
irq_vector:
        .long   irq_exception
fiq_vector:
        .long   fiq_exception




        .text
        .code 32
        .align     0
        .global    start
start:
        mov  r1,  #(CPSR_SVC|CPSR_FIQ_BIT|CPSR_IRQ_BIT) /* To System mode */
		msr  cpsr, r1

        /*
         * åݥ󥿤ȡե졼ݥ󥿤ν
         * SL(å¥쥸r10)ꤹɬפ뤫?
         * gccϥǥեȤǤ-mapcsʤΤɬפʤ
         */
        ldr  r3, =STACKTOP
        mov  sp, r3
        mov  r11, #0        /* Arm⡼ѥե졼ݥ   */         
        mov  r7, #0         /* Thubm⡼ѥե졼ݥ */

        /*
         * hardware_init_hookθƤӽФ 0Ǥʤ
         *
         * åȥϡɥ˰¸ɬפʽ
         * ϡhardware_init_hook ȤؿѰդ
         */
        ldr  r0, =hardware_init_hook
        cmp  r0, #0x00
        blne hardware_init_hook


        /*
         *  bssΥꥢ
         */        
start_1:
        ldr  r1, =__bss_start
        ldr  r2, =__bss_end
        cmp  r1,r2
        bhs  start_3
        mov  r0,#0
start_2:
        str  r0,[r1],#4
        cmp  r1, r2
        blo  start_2
        
        /*
         *  dataν(ROMб)
         *  __idata_start  __idata_end ޤǤ__data_start ʹߤ
         *  ԡ
         */
start_3:
#if 0
        ldr  r1, =__idata_start
        ldr  r3, =__idata_end
        cmp  r1, r3
        bhs  start_5
        ldr  r2, =__data_start
start_4:        
        ldr  r0, [r1],#4
        str  r0, [r2],#4
        cmp  r1, r3
        blo  start_4
#endif
        
        /*
         *  software_init_hook ƽФ0 Ǥʤ
         *
         *  եȥĶä˥饤֥ˤ˰¸ɬפʽ
         *  ϡsoftware_init_hook ȤؿѰդ
         *  褤
         */
start_5:
        ldr   r0, =software_init_hook
        cmp   r0, #0x00
        blne  software_init_hook

start_6:        
        bl    kernel_start
