/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003      by Advanced Data Controls, Corp
 *  Copyright (C) 2004 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN  
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sys_support.S,v 1.3 2006/02/02 00:50:32 honda Exp $
 */

#define _MACRO_ONLY
#include "jsp_kernel.h"
#include <integrator.h>
        
/*
 *  ٥Υåȥƥ¸ν
 *
 *  ȥåץ⥸塼ǡ˸ƤӽФ롥          
 */       

        .text
        .align 2
        .global hardware_init_hook
hardware_init_hook: 

init_done:
        mov     pc, lr


        .text
        .align 2
        .global software_init_hook
software_init_hook:
        mov     pc, lr

        .text
        .align 2
        .global software_term_hook
software_term_hook:
        mov     pc, lr





/*
 *
 *  ߤν
 *         
 */        
        .text
        .align 4    
        .global IRQ_Handler
IRQ_Handler:

        /* 
         * ߥ⡼ 
         * 
         * cpsrspsr_irq褬r14_irq(lp)ꡤ
         * spsr_irqr14_irqr13(sp)_irq r14,r13Ȥʤ롥
         */

        /* 
         *  ư⡼(ѡХ⡼)
         */
        mov   sp,#(CPSR_SVC | CPSR_FIQ_BIT | CPSR_IRQ_BIT) 
        msr   cpsr_all, sp
        stmfd sp!, {r0-r3,ip,lr,pc} /* pcϥߡ */

 
  
        /*
         * spsrϤ뤿IRQ⡼ɤ
         */
        mov   r0,#(CPSR_IRQ | CPSR_FIQ_BIT | CPSR_IRQ_BIT)
        msr   cpsr,r0
        sub   r0,lr,#4
        mrs   r1,spsr
   
        /*
         *  ѡХ⡼ɤ
         */
        and   r2,  r1, #CPSR_FIQ_BIT /* FIQӥåȤηѾ */
        orr   r2,  r2, #(CPSR_SVC|CPSR_IRQ_BIT)        
        msr   cpsr_all, r2
        str   r0, [sp,#0x18] /* Store pc */
        stmfd sp!,{r1}       /* spsr */


        /*
         *  ¿ųߤȽ
         */
        ldr     r2, =interrupt_count
        ldr     r3, [r2]
        add     r0,r3,#1
        str     r0, [r2]
        cmp     r3, #0x00

        moveq   r2,sp            /* ͥȳߤǤʤ */
        ldreq   sp,=STACKTOP     /* åѹ    */
        stmeqfd sp!,{r2}         /* å¸ */


        /*
         *  װȽꡥ
         */
        ldr     r1, =IRQ0_STATUS
        ldr     r2, [r1]
        mov     r0, #31
find_bit_loop:
        mov     r3, r2, asr r0
        tst     r3, #1
        bne     find_bit_end   
        subs    r0, r0, #1
        bpl     find_bit_loop
find_bit_end:
        mov     r3, r0
        ldr     r0,=int_mask_table    /* ߥޥơ֥θƤӽФ*/
        ldr     r0,[r0,r3,lsl #2]     /* r0<-ߥޥ              */    
        ldr     r1, =IRQ0_ENABLECLR   /* ߥ쥸ؤΥå      */
        str     r0,[r1]

        stmfd   sp!, {r0}             /* ޥӥåȤ¸            */

        
        ldr     r0,  =int_table       /* ߵơ֥ɤ߽Ф  */
        ldr     r0,  [r0,r3,lsl #2]   /* r0<-ߥϥɥ            */    


        /*
         *  ̤γߤå
         */
        cmp     r0, #0x00
        beq     undefined_interrupt
        
        /* 
         * ߵ 
         */                
        mrs     r2, cpsr
        and     r2,  r2, #~CPSR_IRQ_BIT /* ߵ */
        msr     cpsr,r2

        /* 
         * Call Handler  
         */        
        mov     lr,  pc   
        mov     pc,  r0

        /* 
         * ߶ػ 
         */
        mrs     r2, cpsr
        and     r2,  r2, #CPSR_FIQ_BIT /* FIQӥåȤηѾ */         
        orr     r2,  r2, #(CPSR_SVC|CPSR_IRQ_BIT)
        msr     cpsr,r2

        ldmfd   sp!, {r0}                /* ޥӥåȤ */
        ldr     r1,  =IRQ0_ENABLESET        /*ߵ*/
        str     r0,  [r1]

        /* 
         * ߥͥȲ(interrupt_count) ǥ 
         */
        ldr     r2, =interrupt_count
        ldr     r1, [r2]        
        sub     r3, r1, #1                        
        str     r3, [r2]
        cmp     r3, #0x00        
        bne     return_to_task_irq
        
        /* 
         * å 
         */
        ldmfd   sp!,{r0}         
        mov     sp, r0        
                
        ldr     r1, =reqflg    /* Check reqflg */
        ldr     r0, [r1]
        cmp     r0, #0
        beq     return_to_task_irq
        mov     r0, #0
        str     r0, [r1]       /* Clear reqflg */
        b       ret_int

return_to_task_irq:
        /*
         *  
         *  ߵĤȤʤ뤬ƥȾ¸Ƥ뤿ᡤ
         *  Ϥʤ
         */
        ldmfd   sp!,{r1}           /* CPSR */
        mrs     r2, cpsr           /* FIQѾ            */
        and     r2, r2, #CPSR_FIQ_BIT
        and     r1, r1, #~CPSR_FIQ_BIT
        orr     r1, r1, r2                 
        msr     spsr, r1              /* cpsrspsr */
        ldmfd   sp!,{r0-r3,ip,lr,pc}^ /*  ^դʤΤǡcpsr <- spsr */        

        /*
         *  ̤γߤäȤ˸ƤӽФ
         */    
undefined_interrupt:
         b      undef_interrupt
    

