/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  Copyright (C) 2005-2007 by Y.D.K.Co.,LTD Technologies company
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: hw_timer.h,v 1.1 2007/05/11 06:06:35 honda Exp $
 */

/*
 *  ޥ⥸塼
 *  TIMER0
 */

#ifndef	_HW_TIMER_H_
#define	_HW_TIMER_H_

#include	<s_services.h>
#ifndef	_NS9360_H_
#include	<ns9360.h>
#endif

/*
 *  ޳ߤγֹ(ޡ˥åȤͥ)
 */
#define		INHNO_TIMER		INTLV_TIM0

#ifndef	_MACRO_ONLY

/*
 *  ͤɽη
 */
typedef	UW		CLOCK;

/*
 *  ͤɽȥߥáñ̤ȤѴ
 *  TIMER_CLOCK ϥåȥܡ
 */
#define	TO_CLOCK(nume, deno)	(TIMER_CLOCK * (nume) / (deno))
#define	TO_USEC(clock)			((clock) * 1000 / TIMER_CLOCK)

/*
 *  ǤΥ޼ñ̤ɽ
 */
#define	MAX_CLOCK	((CLOCK) 0xffffffff)

/*
 *  ޤθͤȯͤȤߤʤȽ
 */
#define	GET_TOLERANCE	100
#define	BEFORE_IREQ(clock) \
		((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)

/*
 *  ޤεư
 *
 *  ޤŪʥ޳׵ȯ롥
 */
Inline void
hw_timer_initialize()
{
	CLOCK    cyc = TO_CLOCK(TIC_NUME, TIC_DENO);
	    
	sil_wrw_mem((VP)TIMER0_CR,0x00);  			/* ,ߥꥢ,߶ػ */
	assert(cyc <= MAX_CLOCK);					/* ޾ͤΥå */
	sil_wrw_mem((VP)TIMER0_CR,0x00000007);		/* ,ߥꥢ,߶ػ */
	sil_wrw_mem((VP)TIMER0_RLC_REG,cyc);		/* ͥå       */
	/*
	 *  ߴϢ
	 */
	/* ߥޥꥢߵ */
	sil_wrw_mem((VP)INT_CFG4_7_REG,sil_rew_mem((VP)INT_CFG4_7_REG)|0x80000000);	/* IRQ4 IntEnable */

	/* ߵ,ޥ */
	sil_wrw_mem((VP)TIMER0_CR,0x0000800f); 
}



/*
 *  ޳׵Υꥢ
 */
Inline void
hw_timer_int_clear()
{
	UW	n;

	n = (sil_rew_mem((VP)TIMER0_CR));
	sil_wrw_mem((VP)TIMER0_CR, n | 0x200);
	sil_wrw_mem((VP)TIMER0_CR, n & ~0x200);
}


/*
 *  ޤ߽
 */
Inline void
hw_timer_terminate()
{
	/* ,ߥꥢ,߶ػ */
	sil_wrw_mem((VP)TIMER0_CR,0x00000107);
	/* ߥޥåȳ߶ػ */
	sil_wrw_mem((VP)INT_CFG4_7_REG,sil_rew_mem((VP)INT_CFG4_7_REG)&~(0x80000000));	/* IRQ4 IntDisable */
}


/*
 *  ޤθͤɤߤ
 *
 *  ߶ػ߶ǸƤӽФȡ
 */
Inline CLOCK
hw_timer_get_current(void)
{
	return(TO_CLOCK(TIC_NUME, TIC_DENO) -
		sil_rew_mem((VP)TIMER0_RR));
}


Inline BOOL
hw_timer_fetch_interrupt(void)
{
	return(sil_rew_mem((VP)TIS_REG) & 1);
}

#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */
