/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *                2003      by Advanced Data Controls, Corp
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: integrator.c,v 1.4 2003/12/24 08:05:00 honda Exp $
 *  
 */

/*
 * Integrator ǽѥɥ饤
 */
#include <s_services.h>
#include <integrator.h>


/*
 * ꥢI/OݡȽ֥å
 */
const SIOPINIB siopinib_table[TNUM_SIOP] = {
    {(VP)UART1_DR,(VP)UART1_CR,(VP)UART1_LCRL,
     (VP)UART1_LCRM,(VP)UART1_LCRH,(VP)UART1_IIR,
     (VP)UART1_FR,IRQ_UART1
    }
#if TNUM_SIOP >= 2
    ,
    {(VP)UART0_DR,(VP)UART0_CR,(VP)UART0_LCRL,
     (VP)UART0_LCRM,(VP)UART0_LCRH,(VP)UART0_IIR,
     (VP)UART0_FR,IRQ_UART0
    }

#endif /* TNUM_SIOP >= 2 */
};


/*
 *  ꥢI/Oݡȴ֥åΥꥢ
 */
SIOPCB  siopcb_table[TNUM_SIOP];


/*
 *  ꥢI/OݡID֥åФΥޥ
 */
#define INDEX_SIOP(siopid)  ((UINT)((siopid) - 1))
#define get_siopcb(siopid)  (&(siopcb_table[INDEX_SIOP(siopid)]))


/*
 * ʸ?
 */ 
Inline BOOL
uart_getready(SIOPCB *siopcb)
{
    return((sil_rew_mem((VP)(siopcb->siopinib->int_identifier)) & IIR_RIS)!=0);
}

/*
 * ʸǤ뤫?
 */
Inline BOOL
uart_putready(SIOPCB *siopcb)
{
    return((sil_rew_mem((VP)(siopcb->siopinib->flag_register)) & UFR_BUSY)==0);
}

/*
 *  ʸμФ
 */
Inline UB
uart_getchar(SIOPCB *siopcb)
{
    return(sil_rew_mem((VP)(siopcb->siopinib->uart_data)));
}

/*
 *  ʸν񤭹
 */
Inline void
uart_putchar(SIOPCB *siopcb, UB c)
{
    sil_wrw_mem((VP)(siopcb->siopinib->uart_data),c);
}

/*
 *  ߵ
 */
Inline void
uart_enable_send(SIOPCB *siopcb)
{
    sil_wrw_mem((VP)(siopcb->siopinib->uart_control),
            (sil_rew_mem((VP)(siopcb->siopinib->uart_control)) | UCR_TIE));
}

/*
 *  ߶ػ
 */
Inline void
uart_disable_send(SIOPCB *siopcb)
{
    sil_wrw_mem((VP)(siopcb->siopinib->uart_control),
	    (sil_rew_mem((VP)(siopcb->siopinib->uart_control)) & ~UCR_TIE));
}


/*
 *  ߵ
 */
Inline void
uart_enable_rcv(SIOPCB *siopcb)
{
    sil_wrw_mem((VP)(siopcb->siopinib->uart_control),
	    (sil_rew_mem((VP)(siopcb->siopinib->uart_control)) | UCR_RIE));
}

/*
 *  ߶ػ
 */
Inline void
uart_disable_rcv(SIOPCB *siopcb)
{

    sil_wrw_mem((VP)(siopcb->siopinib->uart_control),
	    (sil_rew_mem((VP)(siopcb->siopinib->uart_control)) & ~UCR_RIE));

}



/*
 *  SIOɥ饤Фν롼
 *  1ݡȤʤᡤޤ̣Ϥʤ
 */
void
uart_initialize()
{
    SIOPCB  *siopcb;
    UINT    i;

    /*
     *  ꥢI/Oݡȴ֥åν
     */
    for (siopcb = siopcb_table, i = 0; i < TNUM_SIOP; siopcb++, i++) {
        siopcb->siopinib = &(siopinib_table[i]);
        siopcb->openflag = FALSE;
        siopcb->sendflag = FALSE;
    }
}

/*
 * ץ󤷤ƤݡȤ뤫
 */
BOOL
uart_openflag(void)
{
    return(siopcb_table[0].openflag);
}

/*
 * ꥢI/OݡȤΥץ
 */
SIOPCB *
uart_opn_por(ID siopid, VP_INT exinf)
{
    SIOPCB      *siopcb;
    const SIOPINIB  *siopinib;

    siopcb = get_siopcb(siopid);
    siopinib = siopcb->siopinib;

    /* Disable Interrupt */
    sil_wrw_mem((VP)siopinib->uart_control, ~UCR_UARTEN);
    /* 19200bps */
    sil_wrw_mem((VP)siopinib->linectrl_lo, ULCRL_19200); 
    sil_wrw_mem((VP)siopinib->linectrl_mid, ULCRM_19200);
    /* 8Data, 1Stop, No Parity */
    sil_wrw_mem((VP)siopinib->linectrl_hi, ULCRH_WLEN_8BIT);

    
    /*
     * ߴϢ
     */
    sil_wrw_mem((VP)siopinib->uart_control, UCR_UARTEN); /* Enable Interrupt */
    sil_wrw_mem((VP)IRQ0_ENABLESET,siopinib->irq_bit);/*Enable interrupt register*/
    
    siopcb->exinf = exinf;
    siopcb->getready = siopcb->putready = FALSE;
    siopcb->openflag = TRUE;

    return(siopcb);    
}



/*
 *  ꥢI/OݡȤΥ
 */
void
uart_cls_por(SIOPCB *siopcb)
{
    sil_wrw_mem((VP)(siopcb->siopinib->uart_control),
	    (sil_rew_mem((VP)(siopcb->siopinib->uart_control))&~UCR_UARTEN)); /* Disable Interrupt */
    
    siopcb->openflag = FALSE;
}

/*
 *  ꥢI/OݡȤؤʸ
 */
BOOL
uart_snd_chr(SIOPCB *siopcb, char c)
{
    if (uart_putready(siopcb)){
        uart_putchar(siopcb, c);
        return(TRUE);
    }
    return(FALSE);
}

/*
 *  ꥢI/OݡȤʸ
 */
INT
uart_rcv_chr(SIOPCB *siopcb)
{
    if (uart_getready(siopcb)) {
        return((INT)(UB) uart_getchar(siopcb));
    }
    return(-1);
}

/*
 *  ꥢI/OݡȤΥХåε
 */
void
uart_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{
    switch (cbrtn) {
        case SIO_ERDY_SND:
            uart_enable_send(siopcb);
            break;
        case SIO_ERDY_RCV:
            uart_enable_rcv(siopcb);
            break;
    }
}


/*
 *  ꥢI/OݡȤΥХåζػ
 */
void
uart_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{
    switch (cbrtn) {
        case SIO_ERDY_SND:
            uart_disable_send(siopcb);
            break;
        case SIO_ERDY_RCV:
            uart_disable_rcv(siopcb);
            break;
    }
}



/*
 *  ꥢI/OݡȤФ߽
 */
static void
uart_isr_siop(SIOPCB *siopcb)
{
    if (uart_getready(siopcb)) {
        /*
         *  ΥХå롼ƤӽФ
         */
        uart_ierdy_rcv(siopcb->exinf);
    }
    if (uart_putready(siopcb)) {
        /*
         *  ǽХå롼ƤӽФ
         */
        uart_ierdy_snd(siopcb->exinf);
    }
}


/*
 *  SIOγߥӥ롼
 */
void
uart_isr0()
{
    uart_isr_siop(&(siopcb_table[0]));
}

#if TNUM_SIOP >= 2
void
uart_isr1()
{
    uart_isr_siop(&(siopcb_table[1]));
}
#endif
