/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2005 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 */

/*
 *  ץå˰¸Xstormy16ѡ
 */

#ifndef _CPU_DEFS_H_
#define _CPU_DEFS_H_

/*
 *  ץåά
 */
#define XSTORMY16

/*
 *  ߡCPU㳰ϥɥֹη
 */
#ifndef _MACRO_ONLY
typedef UINT INHNO;         /* ߥϥɥֹ */
typedef UINT EXCNO;         /* CPU㳰ϥɥֹ */
#endif /* _MACRO_ONLY */

/*
 *  ץåΥǥ
 */
#define SIL_ENDIAN SIL_ENDIAN_LITTLE

/*
 *  ߥϥɥֹ
 */
#define TNUM_INTERRUPT 17   /* װ */
#define INHNO_WATCHDOG 0    /* åɥåޡߥϥɥֹ */
#define INHNO_BASETIMER 1   /* ١ޡߥϥɥֹ */
#define INHNO_TIMER0 2      /* ޡ0ߥϥɥֹ */
#define INHNO_TIMER1 3      /* ޡ1ߥϥɥֹ */
#define INHNO_UART 16       /* UARTߥϥɥֹ */

/*
 *  CPU㳰ϥɥֹ
 */
#define TNUM_EXCEPTION 4    /* 㳰װ */
#define EXCNO_UDINST 0      /* ̤̿㳰ϥɥֹ */
#define EXCNO_WORDODD 1     /* ϤؤΥɥ㳰ϥɥֹ */
#define EXCNO_OUTRANGE 2    /* ϰϳ㳰ϥɥֹ */
#define EXCNO_UNKNOWN 3     /* CPU㳰ϥɥֹ */

#ifndef _MACRO_ONLY

/*
 *  ƥå
 */
extern UINT _kernel_tic_nume ;          /* ƥåμʬ */
#define TIC_NUME    _kernel_tic_nume    /*     (globalѿȤ) */
#define TIC_DENO    1u                  /* ƥåμʬ */

/*
 *  ǥХåѥ֥졼ݥ
 */
#define __BREAKPOINT() { __asm__( "nop" ); __asm__( ".hword 0x0007" ); }

/*
 *  stdio٥ϴؿ
 */
extern int _write ( int fd, char *buf, int nbytes ) ;
extern int _read ( int fd, char *buf, int nbytes ) ;

#endif /* _MACRO_ONLY */
#endif /* _CPU_DEFS_H_ */
