/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2006 by Witz Corporation, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_config.h,v 1.1 2006/04/10 08:19:25 honda Exp $
 */

/*
 *	ץå¸⥸塼TLCS-900L1ѡ
 *
 *  Υ󥯥롼ɥեϡt_config.h Τߤ饤󥯥롼ɤ롥
 *  ¾Υե뤫ľܥ󥯥롼ɤƤϤʤʤ
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *  ͥ̾Υ͡
 */
#include <cpu_rename.h>

/*
 *  ץåü̿Υ饤ؿ
 */
#ifndef _MACRO_ONLY
#include <cpu_insn.h>
#endif /* _MACRO_ONLY */

/*
 *  chg_ipm/get_ipm 򥵥ݡȤ뤫ɤ
 */
#define	SUPPORT_CHG_IPM

/*
 *  TCB ΥեɤΥӥå
 *
 *  cpu_context.h 쥬ȤȤΰ¸δطǡ
 *  cpu_context.h ˤʤ
 */
#define	TBIT_TCB_TSTAT		8	/* tstat եɤΥӥå */
#define	TBIT_TCB_PRIORITY	4	/* priority եɤΥӥå */

#ifndef _MACRO_ONLY
/*
 *  ƥȥ֥å
 */
typedef struct task_context_block {
	VP	xsp;		/* åݥ */
	FP	pc;		/* ץ५ */
} CTXB;

/* 
 *  /CPU㳰ͥȥ
 */
extern UINT	intcnt;

/*
 *  ߥޥ饤֥
 *
 *  ߥޥintmaskˤϡIPMInterrupt Priority Maskˤ12ӥå
 *  ˥եȤΤǤ롥
 */

/*
 *  ߤγߥޥɽФ
 */
#pragma inline current_intmask
UH
current_intmask()
{
	return(current_sr() & 0x7000);
}

/*
 *  ߥޥ
 */
#pragma inline set_intmask
void
set_intmask(UH intmask)
{
	set_sr((current_sr() & ~0x7000) | intmask);
}

/*
 *  ƥֻ
 */

#pragma inline sense_context
BOOL
sense_context()
{
	Asm("	ldc	hl, intnest");
	return __HL;
}

#pragma inline sense_lock
BOOL
sense_lock()
{
	return(current_intmask() == 0x7000);
}

#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock

/*
 *  CPUåȤβʥƥѡ
 *
 *  task_intmask ϡchg_ipm 򥵥ݡȤ뤿ѿchg_ipm 򥵥ݡ
 *  Ȥʤˤϡtask_intmask  0 ˤʤäƤȹͤФ褤
 */

#ifdef SUPPORT_CHG_IPM
extern UH	task_intmask;	/* ƥȤǤγߥޥ */
#endif /* SUPPORT_CHG_IPM */

#pragma inline t_lock_cpu
void
t_lock_cpu()
{
	disint();
}

#pragma inline t_unlock_cpu
void
t_unlock_cpu()
{
#ifdef SUPPORT_CHG_IPM
	/*
	 *  t_unlock_cpu ƤӽФΤ CPUå֤ΤߤǤ뤿
	 *  ᡤ task_intmask 񤭴뤳ȤϤʤ
	 */
	set_intmask(task_intmask);
#else /* SUPPORT_CHG_IPM */
	enaint();
#endif /* SUPPORT_CHG_IPM */
}

/*
 *  CPUåȤβ󥿥ƥѡ
 */

extern UH	int_intmask;	/* 󥿥ƥȤǤγߥޥ */

#pragma inline i_lock_cpu
void
i_lock_cpu()
{
	UH	intmask;

	/*
	 *  ѿ intmask ȤäƤΤϡcurrent_intmask() 
	 *  ľ˳ߤȯư줿ߥϥɥ
	 *  int_intmask ѹǽ뤿Ǥ롥
	 */
	intmask = current_intmask();
	disint();
	int_intmask = intmask;
}

#pragma inline i_unlock_cpu
void
i_unlock_cpu()
{
	set_intmask(int_intmask);
}

/*
 *  ǥѥå
 */

/*
 *  ǹ̥ͥؤΥǥѥåcpu_support.asm
 *
 *  dispatch ϡƥȤƤӽФ줿ӥ
 *  ǡCPUå֤ǸƤӽФʤФʤʤ
 */
extern void	dispatch(void);

/*
 *  ߤΥƥȤΤƤƥǥѥåcpu_support.asm
 *
 *  exit_and_dispatch ϡCPUå֤ǸƤӽФʤФʤʤ
 */
extern void	exit_and_dispatch(void);

/*
 *  ߥϥɥ顿CPU㳰ϥɥ
 */

/*
 *  ߥϥɥ
 *
 *  ٥ȥֹ inhno γߥϥɥεưϤ inthdr ꤹ롥
 *  ߥϥɥϿ٥ơ֥ROM˼,
 *  ˽񤭹. ΤᤳǤϲ⤷ʤ
 */

#pragma inline define_inh
void
define_inh(INHNO inhno, FP inthdr)
{
}

/*
 *  CPU㳰ϥɥ
 *
 *  ٥ȥֹ excno CPU㳰ϥɥεưϤ exchdr ꤹ롥
 *  ߥϥɥϿ٥ơ֥ROM˼,
 *  ˽񤭹. ΤᤳǤϲ⤷ʤ
 */
#pragma inline define_exc
void
define_exc(EXCNO excno, FP exchdr)
{
}


/*
 *  ߥϥɥ顿CPU㳰ϥɥν
 */

/*
 *  ߥϥɥޥ
 *
 *  ȯΥåڤؤ򥽥եȥǼ¸롥Τᡤ
 *  ߥϥɥˤƳ߶ػ߽Ԥʤȯ
 *  ߶ػߤԤޤǤδ֤¿ųߤȯȡ¿ųߤǤ
 *  Ȥ򥽥եȥǸΤǤʤᡤǽȯ߽
 *  Ԥʤޤޥǥѥåǽ롥¿ųߤ
 *  Τ뤿˥ϡɥ INTNEST 쥸Ѥ롥
 *
 *  TLCS-900 Family C Compiler Ǥ XIZ 쥸ʳƥå
 *  Ǥ롥ʤǻѤ륹å쥸Τߤ
 *  ݻĤϳ߶̽ݻ롥
 *
 *  ϡCPU㳰ϥɥޥƱͤ
 *  뤳ȡ
 */
#define	INTHDR_ENTRY(inthdr) \
extern void _kernel_interrupt(void); \
extern void inthdr##(void); \
void inthdr##_entry(void) \
{ \
Asm("	push	xwa	");	/* Ѥ륹å쥸¸ */ \
Asm("	push	sr");	/* ȯIFF	*/ \
Asm("	pop		wa"); \
Asm("	ei		7");	/* ߶ػ	*/ \
Asm("	push	xhl	");	/* Ѥ륹å쥸¸ */ \
Asm("	ld		xhl, _" #inthdr );	/* 桼ϥɥݥ󥿤	*/ \
Asm("	jp	__kernel_interrupt"	);	/* ߶̽	*/ \
}
/*
 *  嵭ϡCPU㳰ϥɥޥƱͤ
 *  뤳ȡ
 */


#define	INT_ENTRY(inthdr)	inthdr##_entry

/*
 *  CPU㳰ϥɥνޥ
 *
 *  CPU㳰ϥɥϡ󥿥ƥȤǼ¹Ԥ롥
 *  CPU㳰ϥɥϡߥϥɥƱȤ롥
 *  ʤ㳰ϥɥΰۤʤ뤿ᡤƱΥޥ
 *  롥
 *
 *  ϡγߥϥɥޥƱͤ
 *  뤳ȡ
 */

#define	EXCHDR_ENTRY(exchdr) \
extern void _kernel_interrupt(void); \
extern void exchdr##(VP p_excinf); \
void exchdr##_entry(void) \
{ \
Asm("	push	xwa	");	/* Ѥ륹å쥸¸ */ \
Asm("	push	sr");	/* ȯIFF	*/ \
Asm("	pop		wa"); \
Asm("	ei		7");	/* ߶ػ	*/ \
Asm("	push	xhl	");	/* Ѥ륹å쥸¸ */ \
Asm("	ld		xhl, _" #exchdr );	/* 桼ϥɥݥ󥿤	*/ \
Asm("	jp	__kernel_interrupt"	);	/* ߶̽	*/ \
}
/*
 *  ϡγߥϥɥޥƱͤ
 *  뤳ȡ
 */

#define	EXC_ENTRY(exchdr)	exchdr##_entry


/*
 *  CPU㳰ȯΥƥ֤λ
 */

/*
 *  CPU㳰ȯΥƥȤλ
 */
#pragma inline exc_sense_context
BOOL
exc_sense_context(VP p_excinf)
{
	Asm("	ldc	hl, intnest");
	return ( __HL > 1 );
}

/*
 *  CPU㳰ȯCPUå֤λ
 */
#pragma inline exc_sense_lock
BOOL
exc_sense_lock(VP p_excinf)
{
	return ((*((UH *) p_excinf) & 0x7000) == 0x7000);
}

/*
 *  ץå¸ν
 */
extern void	cpu_initialize(void);

/*
 *  ץå¸νλ
 */
extern void	cpu_terminate(void);

#endif /* _MACRO_ONLY */
#endif /* _CPU_CONFIG_H_ */
