/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000,2001 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002 by Hokkaido Industrial Research Institute, JAPAN
 *
 *  嵭ԤϡFree Software Foundation ˤäƸɽƤ
 *  GNU General Public License  Version 2 ˵ҤƤ狼
 *  ξΤ줫˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥѲǽʥХʥꥳɡʥ֥륪
 *      ȥե饤֥ʤɡˤηѤˤϡ
 *      ȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭ɽ
 *      Ѿ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥԲǽʥХʥꥳɤηޤϵ
 *      ߹ѤˤϡΤ줫ξȡ
 *    (a) ѤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) Ѥη֤̤ˡˤäơ嵭Ԥ𤹤
 *        ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭Ԥդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥϡ
 *  ܥեȥ˴ؤơŬѲǽޤơʤݾڤԤ
 *  ʤޤܥեȥѤˤľŪޤϴŪ
 *  ʤ»˴ؤƤ⡤Ǥʤ
 *
 *  @(#) $Id: sh7145.h,v 1.5 2005/07/06 00:45:07 honda Exp $
 */

#ifndef _SH7145_H_
#define _SH7145_H_

#include <sil.h>

/*
 *  ߤΥ٥ֹ
 */

#define ERI0	128				/*  SCI0    */
#define RXI0	129				/*  SCI0    */
#define TXI0	130				/*  SCI0    */
#define ERI1	132				/*  SCI1    */
#define RXI1	133				/*  SCI1    */
#define TXI1	134				/*  SCI1    */
#define CMI0	144				/*  CMT    */
#define ERI2	168				/*  SCI2    */
#define RXI2	169				/*  SCI2    */
#define TXI2	170				/*  SCI2    */

#ifndef _MACRO_ONLY

/*
 *  SH2쥸
 */
/* ⥸塼륹Х쥸 */
#define MSTCR1	((VH *)0xffff861c)
#define MSTCR2	((VH *)0xffff861e)

#define BCR1	((VH *)0xffff8620)
#define BCR2	((VH *)0xffff8622)
#define WCR1	((VH *)0xffff8624)
#define PACRH	((VH *)0xffff8388)
#define PACRL1	((VH *)0xffff838c)
#define PACRL2	((VH *)0xffff838e)
#define PBCR1	((VH *)0xffff8398)
#define PBCR2	((VH *)0xffff839a)
#define PCCR	((VH *)0xffff839c)
#define PDCRH1	((VH *)0xffff83a8)
#define PDCRH2	((VH *)0xffff83aa)
#define PDCRL1	((VH *)0xffff83ac)
#define PDCRL2	((VH *)0xffff83ae)
#define PECRL1	((VH *)0xffff83b8)
#define PECRL2	((VH *)0xffff83ba)
#define PAIORL	((VH *)0xffff8386)
#define PBIOR	((VH *)0xffff8394)
#define PEIORL	((VH *)0xffff83b4)
#define PEDRL	((VH *)0xffff83b0)

/* ͥ٥٥쥸 */
#define IPRA    ((VH *)0xffff8348)
#define IPRB    ((VH *)0xffff834a)
#define IPRC    ((VH *)0xffff834c)
#define IPRD    ((VH *)0xffff834e)
#define IPRE    ((VH *)0xffff8350)
#define IPRF    ((VH *)0xffff8352)
#define IPRG    ((VH *)0xffff8354)
#define IPRH    ((VH *)0xffff8356)
#define IPRI    ((VH *)0xffff835c)
#define IPRJ    ((VH *)0xffff835e)

/*
 * ߥȥν
 */
Inline void sh2_init_intcontorller(void)
{
	sil_wrh_mem (IPRA, 0x0000);
	sil_wrh_mem (IPRB, 0x0000);
	sil_wrh_mem (IPRC, 0x0000);
	sil_wrh_mem (IPRD, 0x0000);
	sil_wrh_mem (IPRE, 0x0000);
	sil_wrh_mem (IPRF, 0x0000);
	sil_wrh_mem (IPRG, 0x0000);
	sil_wrh_mem (IPRH, 0x0000);
	sil_wrh_mem (IPRI, 0x0000);
	sil_wrh_mem (IPRJ, 0x0000);
}
#endif /* _MACRO_ONLY */

#endif /* _SH7145_H_ */
